/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.scijava.maven.plugin.DependencyUtils;
import org.scijava.maven.plugin.SciJavaDependencyException;
import org.scijava.maven.plugin.SnapshotFinder;

public class VerifyNoSnapshotsMojo
extends AbstractMojo {
    private MavenSession mavenSession;
    private MavenProject mavenProject;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder projectBuilder;
    private ArtifactRepository localRepository;
    private List<MavenProject> reactorModules;
    private Boolean failFast;
    private String groupId;
    private List<Object> groupIds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.reactorModules = DependencyUtils.findEffectiveReactor(this.reactorModules, this.mavenSession, this.mavenProject, this.projectBuilder, this.localRepository);
        }
        catch (ProjectBuildingException exc) {
            this.getLog().warn((CharSequence)("Error during project construction:\n" + exc.getMessage()), (Throwable)exc);
        }
        SnapshotFinder fs = new SnapshotFinder(this.projectBuilder, this.localRepository, this.mavenProject.getRemoteArtifactRepositories());
        fs.setLog(this.getLog());
        fs.setFailFast(this.failFast);
        fs.setGroupIds(this.getGroupIds());
        fs.setReactorModules(this.reactorModules);
        try {
            DependencyUtils.checkDependencies(this.mavenProject, this.localRepository, this.dependencyTreeBuilder, fs);
        }
        catch (SciJavaDependencyException e) {
            throw new MojoFailureException(e.getMessage() + "\nTo disable Maven Enforcer rules for local development, re-run" + " Maven\n with the -Denforcer.skip property set.\n");
        }
    }

    private Set<String> getGroupIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.groupIds != null) {
            for (Object id : this.groupIds) {
                ids.add(id == null ? null : id.toString());
            }
        }
        if (this.groupId != null) {
            ids.add(this.groupId);
        }
        return ids;
    }
}

