/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.install;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.Node;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.util.StringUtils;
import org.scijava.maven.plugin.install.AbstractCopyJarsMojo;

@Mojo(name="install-artifact", requiresProject=false)
public class InstallArtifactMojo
extends AbstractCopyJarsMojo {
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Parameter(property="localRepository", readonly=true)
    private ArtifactRepository localRepository;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter(property="artifact")
    private String artifact;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(property="force")
    private boolean force;
    private DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.handleBackwardCompatibility();
        if (this.appDirectory == null) {
            throw new MojoExecutionException("The 'scijava.app.directory' property is unset!");
        }
        File appDir = new File(this.appDirectory);
        if (!appDir.isDirectory() && !appDir.mkdirs()) {
            throw new MojoFailureException("Could not make directory: " + appDir);
        }
        if (this.appSubdirectory == null) {
            this.getLog().info((CharSequence)"No property name for the scijava.app.directory directory location was specified; Installing in default location");
        }
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
        if (this.pomRemoteRepositories != null) {
            repoList.addAll(this.pomRemoteRepositories);
        }
        if (this.remoteRepositories != null) {
            String[] repos;
            for (String repo : repos = this.remoteRepositories.split(",")) {
                repoList.add(this.parseRepository(repo, always));
            }
        }
        repoList.add(this.parseRepository("http://maven.imagej.net/content/groups/public", always));
        if (this.artifactId == null && this.artifact == null) {
            throw new MojoFailureException("No artifact specified (e.g. by -Dartifact=net.imagej:ij:1.48p)");
        }
        if (this.artifact != null) {
            String[] tokens = this.artifact.split(":");
            this.parseArtifact(tokens);
        }
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setLocalRepository(this.localRepository);
            buildingRequest.setRemoteRepositories(repoList);
            ScopeFilter scopeFilter = ScopeFilter.excluding((String[])new String[]{"system", "provided", "test"});
            AbstractFilter notOptionalFilter = new AbstractFilter(){

                public boolean accept(Node node, List<Node> parents) {
                    return !node.getDependency().isOptional();
                }
            };
            AndFilter scopeAndNotOptionalFilter = new AndFilter(Arrays.asList(scopeFilter, notOptionalFilter));
            Iterable resolveDependencies = this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, (DependableCoordinate)this.coordinate, (TransformableFilter)scopeAndNotOptionalFilter);
            for (ArtifactResult result : resolveDependencies) {
                try {
                    if (this.isSameGAV((DependableCoordinate)this.coordinate, result.getArtifact())) {
                        this.installArtifact(result.getArtifact(), appDir, this.appSubdirectory, false, this.deleteOtherVersionsPolicy);
                        continue;
                    }
                    if (this.ignoreDependencies) continue;
                    this.installArtifact(result.getArtifact(), appDir, false, this.deleteOtherVersionsPolicy);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Couldn't download artifact " + this.artifact + ": " + e.getMessage(), (Exception)e);
                    return;
                }
            }
        }
        catch (DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't resolve dependencies for artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private boolean isSameGAV(DependableCoordinate coordinateToCompare, Artifact artifactToCompare) {
        boolean same = coordinateToCompare.getGroupId().equals(artifactToCompare.getGroupId());
        same = same && coordinateToCompare.getArtifactId().equals(artifactToCompare.getArtifactId());
        same = same && coordinateToCompare.getVersion().equals(artifactToCompare.getVersion());
        return same;
    }

    private void parseArtifact(String[] tokens) throws MojoFailureException {
        if (tokens.length != 3) {
            throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version " + this.artifact);
        }
        this.groupId = tokens[0];
        this.artifactId = tokens[1];
        this.version = tokens[2];
        this.coordinate.setGroupId(this.groupId);
        this.coordinate.setArtifactId(this.artifactId);
        this.coordinate.setVersion(this.version);
        if (tokens.length == 4) {
            this.coordinate.setType(tokens[3]);
        }
    }

    private ArtifactRepository parseRepository(String repository, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repository;
        if (repository.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repository);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repository, "Invalid syntax for repository: " + repository, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }
}

