/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.install;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;
import org.scijava.util.VersionUtils;

public abstract class AbstractCopyJarsMojo
extends AbstractMojo {
    @Deprecated
    @Parameter(property="imagej.app.directory", required=false)
    String imagejDirectory;
    @Parameter(property="scijava.app.directory", required=false)
    String appDirectory;
    @Deprecated
    @Parameter(property="imagej.app.subdirectory", required=false)
    String imagejSubdirectory;
    @Parameter(property="scijava.app.subdirectory", required=false)
    String appSubdirectory;
    @Deprecated
    @Parameter(property="delete.other.versions")
    boolean deleteOtherVersions;
    @Deprecated
    @Parameter(property="imagej.deleteOtherVersions")
    OtherVersions imagejDeleteOtherVersionsPolicy;
    @Parameter(property="scijava.deleteOtherVersions", defaultValue="older")
    OtherVersions deleteOtherVersionsPolicy;
    @Parameter(property="scijava.ignoreDependencies", defaultValue="false")
    boolean ignoreDependencies;
    @Parameter(defaultValue="${session}")
    MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    MojoExecution mojoExecution;
    public static final String imagejDirectoryProperty = "imagej.app.directory";
    public static final String imagejSubdirectoryProperty = "imagej.app.subdirectory";
    public static final String deleteOtherVersionsProperty = "delete.other.versions";
    public static final String imagejDeleteOtherVersionsPolicyProperty = "imagej.deleteOtherVersions";
    public static final String appDirectoryProperty = "scijava.app.directory";
    public static final String appSubdirectoryProperty = "scijava.app.subdirectory";
    public static final String deleteOtherVersionsPolicyProperty = "scijava.deleteOtherVersions";
    public static final String ignoreDependenciesProperty = "scijava.ignoreDependencies";
    private static final Pattern versionPattern = Pattern.compile("(.+?)(-\\d+(\\.\\d+|\\d{7})+[a-z]?\\d?(-[A-Za-z0-9.]+?|\\.GA)*?)?((-(swing|swt|sources|javadoc|native|linux-x86|linux-x86_64|linux-armhf|linux-ppc64le|macosx-x86_64|windows-x86|windows-x86_64|android-x86|android-x86_64|android-arm|android-arm64|ios-x86_64|ios-arm64|natives-windows|natives-macos|natives-linux))?(\\.jar(-[a-z]*)?))");
    private static final int PREFIX_INDEX = 1;
    private static final int VERSION_INDEX = 2;
    private static final int SUFFIX_INDEX = 5;

    void handleBackwardCompatibility() {
        PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
        try {
            if (evaluator.evaluate("${scijava.app.directory}") == null && evaluator.evaluate("${scijava.app.subdirectory}") == null && evaluator.evaluate("${scijava.deleteOtherVersions}") == null) {
                if (evaluator.evaluate("${delete.other.versions}") != null) {
                    this.getLog().warn((CharSequence)"Property 'delete.other.versions' is deprecated. Use 'scijava.deleteOtherVersions' instead");
                    OtherVersions otherVersions = this.deleteOtherVersionsPolicy = this.deleteOtherVersions ? OtherVersions.older : OtherVersions.never;
                }
                if (this.imagejDirectory != null) {
                    if (evaluator.evaluate("${imagej.app.directory}") == null) {
                        this.getLog().warn((CharSequence)"Configuration property 'imagejDirectory' is deprecated.Use 'appDirectory' instead");
                    } else {
                        this.getLog().warn((CharSequence)"Property 'imagej.app.directory' is deprecated. Use 'scijava.app.directory' instead");
                    }
                    this.appDirectory = this.imagejDirectory;
                }
                if (this.imagejSubdirectory != null) {
                    if (evaluator.evaluate("${imagej.app.subdirectory}") == null) {
                        this.getLog().warn((CharSequence)"Configuration property 'imagejSubdirectory' is deprecated.Use 'appSubdirectory' instead");
                    } else {
                        this.getLog().warn((CharSequence)"Property 'imagej.app.subdirectory' is deprecated. Use 'scijava.app.subdirectory' instead");
                    }
                    this.appSubdirectory = this.imagejSubdirectory;
                }
                if (this.imagejDeleteOtherVersionsPolicy != null) {
                    if (evaluator.evaluate("${imagej.deleteOtherVersions}") == null) {
                        this.getLog().warn((CharSequence)"Configuration property 'imagejDeleteOtherVersionsPolicy' is deprecated.Use 'deleteOtherVersionsPolicy' instead");
                    } else {
                        this.getLog().warn((CharSequence)"Property 'imagej.deleteOtherVersions' is deprecated. Use 'scijava.deleteOtherVersions' instead");
                    }
                    this.deleteOtherVersionsPolicy = this.imagejDeleteOtherVersionsPolicy;
                }
            } else {
                this.getLog().info((CharSequence)"At least one scijava.* property is set. Ignoring imagej.* properties");
            }
        }
        catch (ExpressionEvaluationException e) {
            this.getLog().warn((Throwable)e);
        }
    }

    protected boolean hasIJ1Dependency(MavenProject project) {
        List dependencies = project.getDependencies();
        for (Dependency dependency : dependencies) {
            String artifactId = dependency.getArtifactId();
            if (!"ij".equals(artifactId) && !"imagej".equals(artifactId)) continue;
            return true;
        }
        return false;
    }

    protected String interpolate(String original, MavenProject project, MavenSession session) throws MojoExecutionException {
        if (original == null || original.indexOf("${") < 0) {
            return original;
        }
        try {
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            ArrayList<String> synonymPrefixes = new ArrayList<String>();
            synonymPrefixes.add("project.");
            synonymPrefixes.add("pom.");
            if (project != null) {
                PrefixedValueSourceWrapper modelWrapper = new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)project.getModel()), synonymPrefixes, true);
                interpolator.addValueSource((ValueSource)modelWrapper);
                PrefixedValueSourceWrapper pomPropertyWrapper = new PrefixedValueSourceWrapper((ValueSource)new PropertiesBasedValueSource(project.getModel().getProperties()), synonymPrefixes, true);
                interpolator.addValueSource((ValueSource)pomPropertyWrapper);
            }
            if (session != null) {
                interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(session.getExecutionProperties()));
            }
            PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(synonymPrefixes, true);
            return interpolator.interpolate(original, (RecursionInterceptor)recursionInterceptor);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not interpolate '" + original + "'", e);
        }
    }

    protected void installArtifact(Artifact artifact, File appDirectory, boolean force, OtherVersions otherVersionsPolicy) throws IOException {
        this.installArtifact(artifact, appDirectory, "", force, otherVersionsPolicy);
    }

    protected void installArtifact(Artifact artifact, File appDirectory, String appSubdirectory, boolean force, OtherVersions otherVersionsPolicy) throws IOException {
        Path targetPath;
        if (!"jar".equals(artifact.getType())) {
            return;
        }
        File source = artifact.getFile();
        File targetDirectory = appSubdirectory != null && !appSubdirectory.equals("") ? new File(appDirectory, appSubdirectory) : (AbstractCopyJarsMojo.isIJ1Plugin(source) ? new File(appDirectory, "plugins") : ("ome".equals(artifact.getGroupId()) || "loci".equals(artifact.getGroupId()) && (source.getName().startsWith("scifio-4.4.") || source.getName().startsWith("jai_imageio-4.4.")) ? new File(appDirectory, "jars/bio-formats") : new File(appDirectory, "jars")));
        String fileName = "Fiji_Updater".equals(artifact.getArtifactId()) ? artifact.getArtifactId() + ".jar" : source.getName();
        File target = new File(targetDirectory, fileName);
        boolean newerVersion = false;
        Path directoryPath = Paths.get(appDirectory.toURI());
        Collection<Path> otherVersions = this.getEncroachingVersions(directoryPath, targetPath = Paths.get(target.toURI()));
        if (otherVersions != null && !otherVersions.isEmpty()) {
            for (Path other : otherVersions) {
                Path otherName = other.getFileName();
                switch (otherVersionsPolicy) {
                    case never: {
                        this.getLog().warn((CharSequence)("Possibly incompatible version exists: " + otherName));
                        break;
                    }
                    case older: {
                        String toInstall = artifact.getVersion();
                        Matcher matcher = versionPattern.matcher(otherName.toString());
                        if (!matcher.matches()) break;
                        String group = matcher.group(2);
                        if (group == null) {
                            newerVersion = true;
                            this.getLog().warn((CharSequence)("Impenetrable version suffix for file: " + otherName));
                        } else {
                            String otherVersion = group.substring(1);
                            boolean bl = newerVersion = VersionUtils.compare((String)toInstall, (String)otherVersion) < 0;
                            if (this.majorVersion(toInstall) != this.majorVersion(otherVersion)) {
                                this.getLog().warn((CharSequence)("Found other version that is incompatible according to SemVer: " + otherVersion));
                            }
                        }
                        if (newerVersion) break;
                    }
                    case always: {
                        if (Files.deleteIfExists(other)) {
                            this.getLog().info((CharSequence)("Deleted overridden " + otherName));
                            newerVersion = false;
                            break;
                        }
                        this.getLog().warn((CharSequence)("Could not delete overridden " + otherName));
                    }
                }
            }
        }
        if (!force && target.exists() && target.lastModified() > source.lastModified()) {
            this.getLog().info((CharSequence)("Dependency " + fileName + " is already there; skipping"));
        } else if (newerVersion) {
            this.getLog().info((CharSequence)("A newer version for " + fileName + " was detected; skipping"));
        } else {
            this.getLog().info((CharSequence)("Copying " + fileName + " to " + targetDirectory));
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isIJ1Plugin(File file) {
        String name = file.getName();
        if (name.indexOf(95) < 0) return false;
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return new File(file, "src/main/resources/plugins.config").exists();
        }
        if (!name.endsWith(".jar")) {
            return false;
        }
        try (JarFile jar = new JarFile(file);){
            JarEntry entry;
            Iterator<JarEntry> iterator = Collections.list(jar.entries()).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(entry = iterator.next()).getName().equals("plugins.config"));
            jar.close();
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private String majorVersion(String v) {
        int dot = v.indexOf(46);
        return dot < 0 ? v : v.substring(0, dot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Path> getEncroachingVersions(Path directory, Path file) {
        Matcher matcher = versionPattern.matcher(file.getFileName().toString());
        if (!matcher.matches()) {
            return null;
        }
        String prefix = matcher.group(1);
        String suffix = matcher.group(5);
        Collection<Path> result = new ArrayList<Path>();
        try {
            Collection<Path> collection = result = (Collection)Files.walk(directory, new FileVisitOption[0]).filter(path -> path.getFileName().toString().startsWith(prefix)).filter(path -> {
                Matcher matcherIterator = versionPattern.matcher(path.getFileName().toString());
                return matcherIterator.matches() && prefix.equals(matcherIterator.group(1)) && suffix.equals(matcherIterator.group(5));
            }).filter(path -> !path.getFileName().toString().equals(file.getFileName().toString())).collect(Collectors.toCollection(ArrayList::new));
            return collection;
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        finally {
            result = new ArrayList();
        }
        return result;
    }

    public static enum OtherVersions {
        always,
        older,
        never;

    }
}

