/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.scijava.maven.plugin.SciJavaDependencyChecker;
import org.scijava.maven.plugin.dependency.tree.DependencyNode;

public abstract class AbstractSciJavaDependencyChecker
implements SciJavaDependencyChecker {
    private boolean failFast = false;
    private boolean failed = false;
    private Set<String> groupIds;
    private Log log;

    @Override
    public void setLog(Log log) {
        this.log = log;
    }

    @Override
    public void debug(String message) {
        if (this.log != null) {
            this.log.debug((CharSequence)message);
        }
    }

    @Override
    public void error(String message) {
        if (this.log != null) {
            this.log.error((CharSequence)message);
        }
    }

    @Override
    public void info(String message) {
        if (this.log != null) {
            this.log.info((CharSequence)message);
        }
    }

    @Override
    public void setGroupIds(Set<String> groupIds) {
        this.groupIds = groupIds;
    }

    @Override
    public boolean matches(String groupId) {
        if (this.groupIds == null || this.groupIds.isEmpty()) {
            return true;
        }
        return this.groupIds.contains(groupId);
    }

    @Override
    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    @Override
    public boolean isRoot(DependencyNode node) {
        return node.getParent() == null;
    }

    @Override
    public void setFailed() {
        this.failed = true;
    }

    @Override
    public boolean failed() {
        return this.failed;
    }

    @Override
    public boolean stopVisit() {
        return this.isFailFast() && this.failed();
    }

    @Override
    public boolean endVisit(DependencyNode node) {
        return this.isRoot(node) ? this.failed() : !this.stopVisit();
    }
}

