/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="set-rootdir", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class SetRootDirPropertyMojo
extends AbstractMojo {
    @Parameter(defaultValue="rootdir", property="setRootdir.rootdirPropertyName")
    private String rootdirPropertyName;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject currentProject;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException {
        if (this.isRootdirPropertyNameDefined()) {
            this.logUsingPreviouslyDefinedRootdir();
        } else {
            this.setRootdirPropertyName();
        }
    }

    private synchronized void setRootdirPropertyName() {
        if (this.isRootdirPropertyNameDefined()) {
            this.logUsingPreviouslyDefinedRootdir();
        } else if (SetRootDirPropertyMojo.isLocalProject(this.currentProject)) {
            MavenProject parent;
            MavenProject project = this.currentProject;
            while ((parent = project.getParent()) != null && SetRootDirPropertyMojo.isLocalProject(parent)) {
                project = parent;
            }
            String rootdir = project.getBasedir().getAbsolutePath();
            this.getLog().info((CharSequence)("Setting rootdir: " + rootdir));
            for (MavenProject reactorProject : this.reactorProjects) {
                reactorProject.getProperties().setProperty(this.rootdirPropertyName, rootdir);
            }
        }
    }

    private boolean isRootdirPropertyNameDefined() {
        return this.currentProject.getProperties().getProperty(this.rootdirPropertyName) != null;
    }

    private void logUsingPreviouslyDefinedRootdir() {
        this.getLog().debug((CharSequence)"Using previously defined rootdir");
    }

    private static boolean isLocalProject(MavenProject project) {
        File baseDir = project.getBasedir();
        return baseDir != null && baseDir.exists();
    }
}

