/*-
 * #%L
 * Java implementation of the SciJava Ops matching engine.
 * %%
 * Copyright (C) 2016 - 2024 SciJava developers.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */
/*
 * This is autogenerated source code -- DO NOT EDIT. Instead, edit the
 * corresponding template in templates/ and rerun bin/generate.groovy.
 */

package org.scijava.ops.engine.adapt.lift;

import java.util.function.Function;

import org.scijava.function.Inplaces;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpCollection;

/**
 * Collection of ops designed to lift {@link Inplaces} to operate
 * on arrays. TODO: multi-threading support
 * 
 * @author Gabriel Selzer
 */
public class InplaceToArrays<IO, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> implements OpCollection {

	private int minLength(Object[]... arrays) {
		int minLength = Integer.MAX_VALUE;
		for (Object[] array : arrays)
			if (array.length < minLength) minLength = array.length;
		return minLength;
	}
	
	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity1<IO>, Inplaces.Arity1<IO[]>> liftInplace1 =
		(inplace) -> {
			return (io) -> {
				int max = minLength(io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity2_1<IO, I2>, Inplaces.Arity2_1<IO[], I2[]>> liftInplace2_1 =
		(inplace) -> {
			return (io, in2) -> {
				int max = minLength(io, in2);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity2_2<I1, IO>, Inplaces.Arity2_2<I1[], IO[]>> liftInplace2_2 =
		(inplace) -> {
			return (in1, io) -> {
				int max = minLength(in1, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity3_1<IO, I2, I3>, Inplaces.Arity3_1<IO[], I2[], I3[]>> liftInplace3_1 =
		(inplace) -> {
			return (io, in2, in3) -> {
				int max = minLength(io, in2, in3);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity3_2<I1, IO, I3>, Inplaces.Arity3_2<I1[], IO[], I3[]>> liftInplace3_2 =
		(inplace) -> {
			return (in1, io, in3) -> {
				int max = minLength(in1, io, in3);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity3_3<I1, I2, IO>, Inplaces.Arity3_3<I1[], I2[], IO[]>> liftInplace3_3 =
		(inplace) -> {
			return (in1, in2, io) -> {
				int max = minLength(in1, in2, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity4_1<IO, I2, I3, I4>, Inplaces.Arity4_1<IO[], I2[], I3[], I4[]>> liftInplace4_1 =
		(inplace) -> {
			return (io, in2, in3, in4) -> {
				int max = minLength(io, in2, in3, in4);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity4_2<I1, IO, I3, I4>, Inplaces.Arity4_2<I1[], IO[], I3[], I4[]>> liftInplace4_2 =
		(inplace) -> {
			return (in1, io, in3, in4) -> {
				int max = minLength(in1, io, in3, in4);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity4_3<I1, I2, IO, I4>, Inplaces.Arity4_3<I1[], I2[], IO[], I4[]>> liftInplace4_3 =
		(inplace) -> {
			return (in1, in2, io, in4) -> {
				int max = minLength(in1, in2, io, in4);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity4_4<I1, I2, I3, IO>, Inplaces.Arity4_4<I1[], I2[], I3[], IO[]>> liftInplace4_4 =
		(inplace) -> {
			return (in1, in2, in3, io) -> {
				int max = minLength(in1, in2, in3, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity5_1<IO, I2, I3, I4, I5>, Inplaces.Arity5_1<IO[], I2[], I3[], I4[], I5[]>> liftInplace5_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5) -> {
				int max = minLength(io, in2, in3, in4, in5);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity5_2<I1, IO, I3, I4, I5>, Inplaces.Arity5_2<I1[], IO[], I3[], I4[], I5[]>> liftInplace5_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5) -> {
				int max = minLength(in1, io, in3, in4, in5);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity5_3<I1, I2, IO, I4, I5>, Inplaces.Arity5_3<I1[], I2[], IO[], I4[], I5[]>> liftInplace5_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5) -> {
				int max = minLength(in1, in2, io, in4, in5);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity5_4<I1, I2, I3, IO, I5>, Inplaces.Arity5_4<I1[], I2[], I3[], IO[], I5[]>> liftInplace5_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5) -> {
				int max = minLength(in1, in2, in3, io, in5);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity5_5<I1, I2, I3, I4, IO>, Inplaces.Arity5_5<I1[], I2[], I3[], I4[], IO[]>> liftInplace5_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io) -> {
				int max = minLength(in1, in2, in3, in4, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity6_1<IO, I2, I3, I4, I5, I6>, Inplaces.Arity6_1<IO[], I2[], I3[], I4[], I5[], I6[]>> liftInplace6_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6) -> {
				int max = minLength(io, in2, in3, in4, in5, in6);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity6_2<I1, IO, I3, I4, I5, I6>, Inplaces.Arity6_2<I1[], IO[], I3[], I4[], I5[], I6[]>> liftInplace6_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6) -> {
				int max = minLength(in1, io, in3, in4, in5, in6);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity6_3<I1, I2, IO, I4, I5, I6>, Inplaces.Arity6_3<I1[], I2[], IO[], I4[], I5[], I6[]>> liftInplace6_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6) -> {
				int max = minLength(in1, in2, io, in4, in5, in6);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity6_4<I1, I2, I3, IO, I5, I6>, Inplaces.Arity6_4<I1[], I2[], I3[], IO[], I5[], I6[]>> liftInplace6_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6) -> {
				int max = minLength(in1, in2, in3, io, in5, in6);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity6_5<I1, I2, I3, I4, IO, I6>, Inplaces.Arity6_5<I1[], I2[], I3[], I4[], IO[], I6[]>> liftInplace6_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6) -> {
				int max = minLength(in1, in2, in3, in4, io, in6);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity6_6<I1, I2, I3, I4, I5, IO>, Inplaces.Arity6_6<I1[], I2[], I3[], I4[], I5[], IO[]>> liftInplace6_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity7_1<IO, I2, I3, I4, I5, I6, I7>, Inplaces.Arity7_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[]>> liftInplace7_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity7_2<I1, IO, I3, I4, I5, I6, I7>, Inplaces.Arity7_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[]>> liftInplace7_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity7_3<I1, I2, IO, I4, I5, I6, I7>, Inplaces.Arity7_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[]>> liftInplace7_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity7_4<I1, I2, I3, IO, I5, I6, I7>, Inplaces.Arity7_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[]>> liftInplace7_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity7_5<I1, I2, I3, I4, IO, I6, I7>, Inplaces.Arity7_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[]>> liftInplace7_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity7_6<I1, I2, I3, I4, I5, IO, I7>, Inplaces.Arity7_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[]>> liftInplace7_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity7_7<I1, I2, I3, I4, I5, I6, IO>, Inplaces.Arity7_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[]>> liftInplace7_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_1<IO, I2, I3, I4, I5, I6, I7, I8>, Inplaces.Arity8_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[]>> liftInplace8_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_2<I1, IO, I3, I4, I5, I6, I7, I8>, Inplaces.Arity8_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[]>> liftInplace8_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_3<I1, I2, IO, I4, I5, I6, I7, I8>, Inplaces.Arity8_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[]>> liftInplace8_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_4<I1, I2, I3, IO, I5, I6, I7, I8>, Inplaces.Arity8_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[]>> liftInplace8_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_5<I1, I2, I3, I4, IO, I6, I7, I8>, Inplaces.Arity8_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[]>> liftInplace8_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_6<I1, I2, I3, I4, I5, IO, I7, I8>, Inplaces.Arity8_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[]>> liftInplace8_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_7<I1, I2, I3, I4, I5, I6, IO, I8>, Inplaces.Arity8_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[]>> liftInplace8_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity8_8<I1, I2, I3, I4, I5, I6, I7, IO>, Inplaces.Arity8_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[]>> liftInplace8_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_1<IO, I2, I3, I4, I5, I6, I7, I8, I9>, Inplaces.Arity9_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[]>> liftInplace9_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_2<I1, IO, I3, I4, I5, I6, I7, I8, I9>, Inplaces.Arity9_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[]>> liftInplace9_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_3<I1, I2, IO, I4, I5, I6, I7, I8, I9>, Inplaces.Arity9_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[]>> liftInplace9_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_4<I1, I2, I3, IO, I5, I6, I7, I8, I9>, Inplaces.Arity9_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[]>> liftInplace9_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_5<I1, I2, I3, I4, IO, I6, I7, I8, I9>, Inplaces.Arity9_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[]>> liftInplace9_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_6<I1, I2, I3, I4, I5, IO, I7, I8, I9>, Inplaces.Arity9_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[]>> liftInplace9_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_7<I1, I2, I3, I4, I5, I6, IO, I8, I9>, Inplaces.Arity9_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[]>> liftInplace9_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_8<I1, I2, I3, I4, I5, I6, I7, IO, I9>, Inplaces.Arity9_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[]>> liftInplace9_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity9_9<I1, I2, I3, I4, I5, I6, I7, I8, IO>, Inplaces.Arity9_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[]>> liftInplace9_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10>, Inplaces.Arity10_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[]>> liftInplace10_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9, in10) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10>, Inplaces.Arity10_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[]>> liftInplace10_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9, in10) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10>, Inplaces.Arity10_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[], I10[]>> liftInplace10_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9, in10) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10>, Inplaces.Arity10_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[], I10[]>> liftInplace10_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9, in10) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10>, Inplaces.Arity10_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[], I10[]>> liftInplace10_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9, in10) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10>, Inplaces.Arity10_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[], I10[]>> liftInplace10_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9, in10) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10>, Inplaces.Arity10_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[], I10[]>> liftInplace10_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9, in10) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10>, Inplaces.Arity10_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[], I10[]>> liftInplace10_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9, in10) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10>, Inplaces.Arity10_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[], I10[]>> liftInplace10_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io, in10) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io, in10);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i], in10[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity10_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO>, Inplaces.Arity10_10<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], IO[]>> liftInplace10_10 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11>, Inplaces.Arity11_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[]>> liftInplace11_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11>, Inplaces.Arity11_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[]>> liftInplace11_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11>, Inplaces.Arity11_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[]>> liftInplace11_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11>, Inplaces.Arity11_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[], I10[], I11[]>> liftInplace11_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11>, Inplaces.Arity11_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[], I10[], I11[]>> liftInplace11_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11>, Inplaces.Arity11_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[], I10[], I11[]>> liftInplace11_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11>, Inplaces.Arity11_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[], I10[], I11[]>> liftInplace11_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11>, Inplaces.Arity11_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[], I10[], I11[]>> liftInplace11_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11>, Inplaces.Arity11_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[], I10[], I11[]>> liftInplace11_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i], in10[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11>, Inplaces.Arity11_10<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], IO[], I11[]>> liftInplace11_10 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], io[i], in11[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity11_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO>, Inplaces.Arity11_11<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], IO[]>> liftInplace11_11 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12>, Inplaces.Arity12_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[]>> liftInplace12_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12>, Inplaces.Arity12_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[]>> liftInplace12_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12>, Inplaces.Arity12_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[]>> liftInplace12_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12>, Inplaces.Arity12_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[]>> liftInplace12_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12>, Inplaces.Arity12_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[], I10[], I11[], I12[]>> liftInplace12_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12>, Inplaces.Arity12_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[], I10[], I11[], I12[]>> liftInplace12_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12>, Inplaces.Arity12_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[], I10[], I11[], I12[]>> liftInplace12_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12>, Inplaces.Arity12_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[], I10[], I11[], I12[]>> liftInplace12_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12>, Inplaces.Arity12_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[], I10[], I11[], I12[]>> liftInplace12_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i], in10[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12>, Inplaces.Arity12_10<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], IO[], I11[], I12[]>> liftInplace12_10 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], io[i], in11[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12>, Inplaces.Arity12_11<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], IO[], I12[]>> liftInplace12_11 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], io[i], in12[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity12_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO>, Inplaces.Arity12_12<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], IO[]>> liftInplace12_12 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13>, Inplaces.Arity13_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13>, Inplaces.Arity13_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13>, Inplaces.Arity13_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13>, Inplaces.Arity13_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13>, Inplaces.Arity13_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13>, Inplaces.Arity13_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13>, Inplaces.Arity13_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13>, Inplaces.Arity13_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[], I10[], I11[], I12[], I13[]>> liftInplace13_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13>, Inplaces.Arity13_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[], I10[], I11[], I12[], I13[]>> liftInplace13_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i], in10[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13>, Inplaces.Arity13_10<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], IO[], I11[], I12[], I13[]>> liftInplace13_10 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], io[i], in11[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13>, Inplaces.Arity13_11<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], IO[], I12[], I13[]>> liftInplace13_11 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], io[i], in12[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13>, Inplaces.Arity13_12<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], IO[], I13[]>> liftInplace13_12 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], io[i], in13[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity13_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO>, Inplaces.Arity13_13<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], IO[]>> liftInplace13_13 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14>, Inplaces.Arity14_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14>, Inplaces.Arity14_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[], I10[], I11[], I12[], I13[], I14[]>> liftInplace14_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i], in10[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14>, Inplaces.Arity14_10<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], IO[], I11[], I12[], I13[], I14[]>> liftInplace14_10 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], io[i], in11[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14>, Inplaces.Arity14_11<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], IO[], I12[], I13[], I14[]>> liftInplace14_11 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], io[i], in12[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14>, Inplaces.Arity14_12<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], IO[], I13[], I14[]>> liftInplace14_12 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], io[i], in13[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14>, Inplaces.Arity14_13<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], IO[], I14[]>> liftInplace14_13 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io, in14) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io, in14);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], io[i], in14[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity14_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO>, Inplaces.Arity14_14<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], IO[]>> liftInplace14_14 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15>, Inplaces.Arity15_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[], I10[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15>, Inplaces.Arity15_10<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], IO[], I11[], I12[], I13[], I14[], I15[]>> liftInplace15_10 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], io[i], in11[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15>, Inplaces.Arity15_11<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], IO[], I12[], I13[], I14[], I15[]>> liftInplace15_11 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], io[i], in12[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15>, Inplaces.Arity15_12<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], IO[], I13[], I14[], I15[]>> liftInplace15_12 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], io[i], in13[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15>, Inplaces.Arity15_13<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], IO[], I14[], I15[]>> liftInplace15_13 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io, in14, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io, in14, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], io[i], in14[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15>, Inplaces.Arity15_14<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], IO[], I15[]>> liftInplace15_14 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, io, in15) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, io, in15);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], io[i], in15[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity15_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO>, Inplaces.Arity15_15<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], IO[]>> liftInplace15_15 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], io[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_1<IO[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_1 =
		(inplace) -> {
			return (io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(io, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(io[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_2<I1[], IO[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_2 =
		(inplace) -> {
			return (in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, io, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], io[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_3<I1[], I2[], IO[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_3 =
		(inplace) -> {
			return (in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, io, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], io[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_4<I1[], I2[], I3[], IO[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_4 =
		(inplace) -> {
			return (in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, io, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], io[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_5<I1[], I2[], I3[], I4[], IO[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_5 =
		(inplace) -> {
			return (in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, io, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], io[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_6<I1[], I2[], I3[], I4[], I5[], IO[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_6 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, io, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], io[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_7<I1[], I2[], I3[], I4[], I5[], I6[], IO[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_7 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, io, in8, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], io[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_8<I1[], I2[], I3[], I4[], I5[], I6[], I7[], IO[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_8 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, io, in9, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], io[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_9<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], IO[], I10[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_9 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, io, in10, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], io[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15, I16>, Inplaces.Arity16_10<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], IO[], I11[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_10 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, io, in11, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], io[i], in11[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15, I16>, Inplaces.Arity16_11<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], IO[], I12[], I13[], I14[], I15[], I16[]>> liftInplace16_11 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, io, in12, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], io[i], in12[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15, I16>, Inplaces.Arity16_12<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], IO[], I13[], I14[], I15[], I16[]>> liftInplace16_12 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, io, in13, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], io[i], in13[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15, I16>, Inplaces.Arity16_13<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], IO[], I14[], I15[], I16[]>> liftInplace16_13 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io, in14, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, io, in14, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], io[i], in14[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15, I16>, Inplaces.Arity16_14<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], IO[], I15[], I16[]>> liftInplace16_14 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, io, in15, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, io, in15, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], io[i], in15[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO, I16>, Inplaces.Arity16_15<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], IO[], I16[]>> liftInplace16_15 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, io, in16) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, io, in16);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], io[i], in16[i]);
				}
			};
		};

	@OpField(names = "engine.adapt", params = "fromOp, toOp")
	public final Function<Inplaces.Arity16_16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, IO>, Inplaces.Arity16_16<I1[], I2[], I3[], I4[], I5[], I6[], I7[], I8[], I9[], I10[], I11[], I12[], I13[], I14[], I15[], IO[]>> liftInplace16_16 =
		(inplace) -> {
			return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, io) -> {
				int max = minLength(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, io);
				for (int i = 0; i < max; i++) {
					inplace.mutate(in1[i], in2[i], in3[i], in4[i], in5[i], in6[i], in7[i], in8[i], in9[i], in10[i], in11[i], in12[i], in13[i], in14[i], in15[i], io[i]);
				}
			};
		};

}
