/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.reduce;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.meta.Versions;
import org.scijava.ops.api.Hints;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.exceptions.impl.NullablesOnMultipleMethodsException;
import org.scijava.ops.engine.matcher.impl.DefaultOpFieldInfo;
import org.scijava.ops.engine.matcher.impl.DefaultOpMethodInfo;
import org.scijava.ops.engine.reduce.BiFunctionWithNullable;
import org.scijava.ops.engine.reduce.TestOpNullableFromIFace;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpMethod;

public class NullableArgumentsFromIFaceTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.nullableAnd", params={"in1, in2, in3"})
    public final BiFunctionWithNullable<Boolean, Boolean, Boolean, Boolean> bar = (in1, in2, in3) -> {
        if (in3 == null) {
            in3 = true;
        }
        return in1 & in2 & in3;
    };
    public final BiFunctionWithNullable<Double, Double, Double, Double> foo = new BiFunctionWithNullable<Double, Double, Double, Double>(){

        @Override
        public Double apply(Double in1, Double in2, @Nullable Double in3) {
            if (in3 == null) {
                in3 = 0.0;
            }
            return in1 + in2 + in3;
        }
    };

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new NullableArgumentsFromIFaceTest()});
        ops.register(new Object[]{new TestOpNullableFromIFace()});
    }

    @OpMethod(names="test.nullableSubtract", type=BiFunctionWithNullable.class)
    public static Double foo(Double i1, Double i2, Double i3) {
        if (i3 == null) {
            i3 = 0.0;
        }
        return i1 - i2 - i3;
    }

    @Test
    public void testMethodWithOneNullable() {
        Double o = (Double)ops.op("test.nullableSubtract").input((Object)2.0, (Object)5.0, (Object)7.0).outType(Double.class).apply();
        Double expected = -10.0;
        Assertions.assertEquals((Double)expected, (Double)o);
    }

    @Test
    public void testMethodWithoutNullables() {
        Double o = (Double)ops.op("test.nullableSubtract").input((Object)2.0, (Object)5.0).outType(Double.class).apply();
        Double expected = -3.0;
        Assertions.assertEquals((Double)expected, (Double)o);
    }

    @Test
    public void testFieldWithNullables() {
        Boolean in1 = true;
        Boolean in2 = true;
        Boolean in3 = false;
        Boolean o = (Boolean)ops.op("test.nullableAnd").input((Object)in1, (Object)in2, (Object)in3).outType(Boolean.class).apply();
        Boolean expected = false;
        Assertions.assertEquals((Object)expected, (Object)o);
    }

    @Test
    public void testFieldWithoutNullables() {
        Boolean in1 = true;
        Boolean in2 = true;
        Boolean o = (Boolean)ops.op("test.nullableAnd").input((Object)in1, (Object)in2).outType(Boolean.class).apply();
        Boolean expected = true;
        Assertions.assertEquals((Object)expected, (Object)o);
    }

    @Test
    public void testClassWithNullables() {
        Boolean in1 = true;
        Boolean in2 = false;
        Boolean in3 = false;
        Boolean o = (Boolean)ops.op("test.nullableOr").input((Object)in1, (Object)in2, (Object)in3).outType(Boolean.class).apply();
        Boolean expected = true;
        Assertions.assertEquals((Object)expected, (Object)o);
    }

    @Test
    public void testClassWithoutNullables() {
        Boolean in1 = true;
        Boolean in2 = false;
        Boolean o = (Boolean)ops.op("test.nullableOr").input((Object)in1, (Object)in2).outType(Boolean.class).apply();
        Boolean expected = true;
        Assertions.assertEquals((Object)expected, (Object)o);
    }

    public static Boolean baz(Boolean i1, Boolean i2, @Nullable Boolean i3) {
        if (i3 == null) {
            i3 = false;
        }
        return i1 ^ i2 ^ i3;
    }

    @Test
    public void testNullablesOnOpMethodAndIFace() throws NoSuchMethodException {
        Method m = this.getClass().getDeclaredMethod("baz", Boolean.class, Boolean.class, Boolean.class);
        Assertions.assertThrows(NullablesOnMultipleMethodsException.class, () -> new DefaultOpMethodInfo(m, BiFunctionWithNullable.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"test.optionalOnIFaceAndOp"}));
    }

    @Test
    public void testNullablesOnOpFieldAndIFace() throws NoSuchFieldException {
        Field f = this.getClass().getDeclaredField("foo");
        Assertions.assertThrows(NullablesOnMultipleMethodsException.class, () -> new DefaultOpFieldInfo((Object)this, f, Versions.of(this.getClass()), "This is an invalid OpFieldInfo", new Hints(new String[0]), 1.0, new String[]{"test.optionalOnIFaceAndOp"}));
    }
}

