/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.scijava.common3.GenericTyped;
import org.scijava.common3.Types;
import org.scijava.types.infer.FunctionalInterfaces;

public final class LambdaTypeBaker {
    private LambdaTypeBaker() {
    }

    public static <T> T bakeLambdaType(T originalOp, Type reifiedType) {
        LambdaTypeBaker.ensureImplementation(originalOp, reifiedType);
        try {
            return (T)LambdaTypeBaker.javassistOp(originalOp, reifiedType);
        }
        catch (Throwable exc) {
            throw new RuntimeException(exc);
        }
    }

    private static <T> void ensureImplementation(T originalOp, Type reifiedType) {
        Class typeFIFace;
        Class<?> opClass = originalOp.getClass();
        Class opFIFace = FunctionalInterfaces.findFrom(opClass);
        if (!opFIFace.equals(typeFIFace = FunctionalInterfaces.findFrom((Type)reifiedType))) {
            throw new IllegalArgumentException(originalOp + " does not implement " + Types.raw((Type)reifiedType));
        }
    }

    private static Object javassistOp(Object originalOp, Type reifiedType) throws Throwable {
        Class c;
        ClassPool pool = ClassPool.getDefault();
        String className = LambdaTypeBaker.formClassName(originalOp, reifiedType);
        try {
            c = pool.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            CtClass cc = LambdaTypeBaker.generateSimplifiedWrapper(pool, className, reifiedType);
            c = cc.toClass(MethodHandles.lookup());
        }
        return c.getDeclaredConstructor(Types.raw((Type)reifiedType), Type.class).newInstance(originalOp, reifiedType);
    }

    private static String formClassName(Object op, Type reifiedType) {
        String packageName = LambdaTypeBaker.class.getPackageName();
        StringBuilder sb = new StringBuilder(packageName + ".");
        String implementationName = op.getClass().getSimpleName();
        String originalName = implementationName.substring(implementationName.lastIndexOf(46) + 1);
        String className = originalName.concat("_typeBaked_" + reifiedType.getTypeName());
        if ((className = className.replaceAll("[^a-zA-Z0-9_]", "_")).chars().anyMatch(c -> !Character.isJavaIdentifierPart(c))) {
            throw new IllegalArgumentException(className + " is not a valid class name!");
        }
        sb.append(className);
        return sb.toString();
    }

    private static CtClass generateSimplifiedWrapper(ClassPool pool, String className, Type reifiedType) throws Throwable {
        CtClass cc = pool.makeClass(className);
        CtClass jasOpType = pool.get(Types.raw((Type)reifiedType).getName());
        cc.addInterface(jasOpType);
        CtClass genTyped = pool.get(GenericTyped.class.getName());
        cc.addInterface(genTyped);
        CtField opField = LambdaTypeBaker.createTypeField(pool, cc, Types.raw((Type)reifiedType), "op");
        cc.addField(opField);
        CtField type = LambdaTypeBaker.createTypeField(pool, cc, Type.class, "type");
        cc.addField(type);
        CtConstructor constructor = CtNewConstructor.make((String)LambdaTypeBaker.createConstructor(cc, Types.raw((Type)reifiedType)), (CtClass)cc);
        cc.addConstructor(constructor);
        CtMethod functionalMethod = CtNewMethod.make((String)LambdaTypeBaker.createFunctionalMethod(reifiedType), (CtClass)cc);
        cc.addMethod(functionalMethod);
        CtMethod genTypedMethod = CtNewMethod.make((String)LambdaTypeBaker.createGenericTypedMethod(), (CtClass)cc);
        cc.addMethod(genTypedMethod);
        return cc;
    }

    private static String createGenericTypedMethod() {
        return "public java.lang.reflect.Type type() {return type;}";
    }

    private static CtField createTypeField(ClassPool pool, CtClass cc, Class<?> opType, String fieldName) throws NotFoundException, CannotCompileException {
        CtClass fType = pool.get(opType.getName());
        CtField f = new CtField(fType, fieldName, cc);
        f.setModifiers(18);
        return f;
    }

    private static String createConstructor(CtClass cc, Class<?> opType) {
        StringBuilder sb = new StringBuilder();
        sb.append("public " + cc.getSimpleName() + "( ");
        sb.append(" " + opType.getName() + " op, java.lang.reflect.Type type ) {");
        sb.append("this.op = op;");
        sb.append("this.type = type;");
        sb.append("}");
        return sb.toString();
    }

    private static String createFunctionalMethod(Type reifiedType) {
        StringBuilder sb = new StringBuilder();
        Class raw = Types.raw((Type)reifiedType);
        Method m = FunctionalInterfaces.functionalMethodOf((Type)raw);
        sb.append(LambdaTypeBaker.generateSignature(m));
        sb.append(" {");
        if (m.getReturnType() != Void.TYPE) {
            sb.append("return ");
        }
        sb.append("op." + m.getName() + "(");
        for (int i = 0; i < m.getParameterCount(); ++i) {
            sb.append(" in" + i);
            if (i + 1 >= m.getParameterCount()) continue;
            sb.append(",");
        }
        sb.append(");");
        sb.append("}");
        return sb.toString();
    }

    private static String generateSignature(Method m) {
        StringBuilder sb = new StringBuilder();
        String methodName = m.getName();
        boolean isVoid = m.getReturnType() == Void.TYPE;
        sb.append("public " + (isVoid ? "void" : "Object") + " " + methodName + "(");
        int inputs = m.getParameterCount();
        for (int i = 0; i < inputs; ++i) {
            sb.append(" Object in" + i);
            if (i >= inputs - 1) continue;
            sb.append(",");
        }
        sb.append(" )");
        return sb.toString();
    }
}

