/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.scijava.common3.Any;
import org.scijava.common3.Comparisons;
import org.scijava.common3.Types;
import org.scijava.function.Computers;
import org.scijava.meta.Versions;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.Ops;
import org.scijava.ops.api.RichOp;
import org.scijava.ops.engine.conversionLoss.LossReporter;
import org.scijava.ops.engine.matcher.convert.Conversions;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.OpRetypingMemberParser;
import org.scijava.ops.engine.struct.RetypingRequest;
import org.scijava.ops.engine.util.Infos;
import org.scijava.struct.ItemIO;
import org.scijava.struct.Member;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.Structs;
import org.scijava.types.Nil;
import org.scijava.types.infer.FunctionalInterfaces;
import org.scijava.types.infer.GenericAssignability;

public class ConvertedOpInfo
implements OpInfo {
    protected static final String IMPL_DECLARATION = "|Conversion:";
    protected static final String PRECONVERTER_DELIMITER = "|Preconverter:";
    protected static final String POSTCONVERTER_DELIMITER = "|Postconverter:";
    protected static final String OUTPUT_COPIER_DELIMITER = "|OutputCopier:";
    protected static final String ORIGINAL_INFO = "|OriginalInfo:";
    private final OpInfo info;
    private final OpEnvironment env;
    private final Map<TypeVariable<?>, Type> typeVarAssigns;
    final List<RichOp<Function<?, ?>>> preconverters;
    final List<Type> inTypes;
    final RichOp<Function<?, ?>> postconverter;
    final Type outType;
    final RichOp<Computers.Arity1<?, ?>> copyOp;
    private final Type opType;
    private final Struct struct;
    private Double priority = null;
    private final Hints hints;
    private final Function<?, ?> IGNORED = t -> t;

    public ConvertedOpInfo(OpInfo info, List<RichOp<Function<?, ?>>> preconverters, RichOp<Function<?, ?>> postconverter, RichOp<Computers.Arity1<?, ?>> copyOp, OpEnvironment env) {
        this(info, ConvertedOpInfo.generateOpType(info, preconverters, postconverter), preconverters, Arrays.asList(ConvertedOpInfo.inTypes(info.inputTypes(), preconverters)), postconverter, ConvertedOpInfo.outType(info.outputType(), postconverter), copyOp, env, Collections.emptyMap());
    }

    private static Type generateOpType(OpInfo info, List<RichOp<Function<?, ?>>> preconverter, RichOp<Function<?, ?>> postconverter) {
        Type[] inTypes = ConvertedOpInfo.inTypes(info.inputTypes(), preconverter);
        Type outType = ConvertedOpInfo.outType(info.outputType(), postconverter);
        Class fIface = FunctionalInterfaces.findFrom((Type)info.opType());
        return ConvertedOpInfo.retypeOpType(fIface, inTypes, outType);
    }

    public ConvertedOpInfo(OpInfo info, Type opType, List<RichOp<Function<?, ?>>> preconverters, List<Type> reqInputs, RichOp<Function<?, ?>> postconverter, Type reqOutput, RichOp<Computers.Arity1<?, ?>> copyOp, OpEnvironment env, Map<TypeVariable<?>, Type> typeVarAssigns) {
        this.info = info;
        this.opType = ConvertedOpInfo.mapAnys(opType, info);
        this.preconverters = preconverters;
        this.inTypes = reqInputs;
        this.postconverter = postconverter;
        this.outType = reqOutput;
        this.copyOp = copyOp;
        this.env = env;
        this.struct = this.generateStruct();
        this.hints = info.declaredHints().plus(new String[]{"conversion.FORBIDDEN", "converted"});
        this.typeVarAssigns = typeVarAssigns;
    }

    private Struct generateStruct() {
        int toIOIdx;
        ArrayList<Type> originalIns = new ArrayList<Type>(this.info.inputTypes());
        ArrayList<Member> ioMembers = new ArrayList<Member>(this.info.struct().members());
        int fromIOIdx = Conversions.mutableIndexOf(Types.raw((Type)this.info.opType()));
        if (fromIOIdx != (toIOIdx = Conversions.mutableIndexOf(Types.raw((Type)this.opType)))) {
            originalIns.add(toIOIdx, (Type)originalIns.remove(fromIOIdx));
            ioMembers.add(toIOIdx, (Member)ioMembers.remove(fromIOIdx));
        }
        int index = 0;
        ArrayList<FunctionalMethodType> fmts = new ArrayList<FunctionalMethodType>();
        for (Member m : ioMembers) {
            if (m.getIOType() == ItemIO.NONE) continue;
            Type newType = m.isInput() ? this.inTypes.get(index++) : (m.isOutput() ? this.outType : null);
            fmts.add(new FunctionalMethodType(newType, m.getIOType()));
        }
        RetypingRequest r = new RetypingRequest(this.info.struct(), fmts);
        return Structs.from((Object)r, (Type)this.opType, (MemberParser[])new MemberParser[]{new OpRetypingMemberParser()});
    }

    public OpInfo srcInfo() {
        return this.info;
    }

    public List<String> names() {
        return this.srcInfo().names();
    }

    public String description() {
        return this.srcInfo().description();
    }

    public Type opType() {
        return this.opType;
    }

    public Hints declaredHints() {
        return this.hints;
    }

    public Struct struct() {
        return this.struct;
    }

    public String implementationName() {
        StringBuilder sb = new StringBuilder(this.info.implementationName());
        sb.append("|converted");
        for (Member m : this.struct()) {
            if (!m.isInput() && !m.isOutput()) continue;
            sb.append("_");
            sb.append(Conversions.getClassName(m.type()));
        }
        return sb.toString();
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.info.getAnnotationBearer();
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        Object op = this.info.createOpInstance(dependencies).object();
        try {
            Object convertedOp = ConvertedOpInfo.javassistOp(op, this, this.preconverters.stream().map(rich -> {
                if (rich == null) {
                    return this.IGNORED;
                }
                return (Function)rich.asOpType();
            }).collect(Collectors.toList()), this.postconverter == null ? this.IGNORED : (Function)this.postconverter.asOpType(), this.copyOp == null ? null : (Computers.Arity1)this.copyOp.asOpType());
            return this.struct().createInstance(convertedOp);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Failed to invoke parameter conversion of Op: \n" + this.info + "\nProvided Op dependencies were: " + dependencies, ex);
        }
    }

    public String toString() {
        return Infos.describe(this);
    }

    public int compareTo(OpInfo that) {
        if (this.priority() < that.priority()) {
            return 1;
        }
        if (this.priority() > that.priority()) {
            return -1;
        }
        int implNameDiff = Comparisons.compare((Comparable)((Object)this.implementationName()), (Comparable)((Object)that.implementationName()));
        if (implNameDiff != 0) {
            return implNameDiff;
        }
        if (that instanceof ConvertedOpInfo) {
            return this.compareConvertedInfos((ConvertedOpInfo)that);
        }
        return 0;
    }

    private int compareConvertedInfos(ConvertedOpInfo that) {
        int thisHash = this.struct().members().hashCode();
        int thatHash = that.struct().members().hashCode();
        return thisHash - thatHash;
    }

    public String version() {
        return Versions.of(this.getClass());
    }

    public String id() {
        StringBuilder sb = new StringBuilder(IMPL_DECLARATION);
        for (RichOp<Function<?, ?>> i : this.preconverters) {
            sb.append(PRECONVERTER_DELIMITER);
            sb.append(i.infoTree().signature());
        }
        sb.append(POSTCONVERTER_DELIMITER);
        sb.append(this.postconverter.infoTree().signature());
        if (this.copyOp != null) {
            sb.append(OUTPUT_COPIER_DELIMITER);
            sb.append(this.copyOp.infoTree().signature());
        }
        sb.append(ORIGINAL_INFO);
        sb.append(this.srcInfo().id());
        return sb.toString();
    }

    private static Type[] inTypes(List<Type> originalInputs, List<RichOp<Function<?, ?>>> preconverters) {
        HashMap typeAssigns = new HashMap();
        Type[] inTypes = new Type[originalInputs.size()];
        for (int i = 0; i < originalInputs.size(); ++i) {
            typeAssigns.clear();
            Type type = preconverters.get(i).instance().type();
            ParameterizedType pType = (ParameterizedType)type;
            inTypes[i] = pType.getActualTypeArguments()[0];
            if (inTypes[i] instanceof WildcardType) {
                inTypes[i] = (Type)Ops.info(preconverters.get(i)).inputTypes().get(0);
            }
            GenericAssignability.inferTypeVariables((Type[])new Type[]{pType.getActualTypeArguments()[1]}, (Type[])new Type[]{originalInputs.get(i)}, typeAssigns);
            inTypes[i] = Types.unroll((Type)inTypes[i], typeAssigns);
        }
        return inTypes;
    }

    private static Type outType(Type originalOutput, RichOp<Function<?, ?>> postconverter) {
        if (postconverter == null) {
            return originalOutput;
        }
        Type type = postconverter.instance().type();
        ParameterizedType pType = (ParameterizedType)type;
        Type outType = pType.getActualTypeArguments()[1];
        if (outType instanceof WildcardType) {
            outType = Ops.info(postconverter).outputType();
        }
        HashMap vars = new HashMap();
        GenericAssignability.inferTypeVariables((Type[])new Type[]{pType.getActualTypeArguments()[0]}, (Type[])new Type[]{originalOutput}, vars);
        return Types.unroll((Type)outType, vars);
    }

    public double priority() {
        if (this.priority == null) {
            this.priority = this.calculatePriority(this.env);
        }
        return this.priority;
    }

    private static Type mapAnys(Type opType, OpInfo info) {
        ParameterizedType raw = Types.parameterize((Class)Types.raw((Type)opType), (Type[])new Type[0]);
        HashMap<TypeVariable, Type> reqMap = new HashMap<TypeVariable, Type>();
        GenericAssignability.inferTypeVariables((Type[])new Type[]{raw}, (Type[])new Type[]{opType}, reqMap);
        HashMap infoMap = new HashMap();
        GenericAssignability.inferTypeVariables((Type[])new Type[]{raw}, (Type[])new Type[]{info.opType()}, infoMap);
        for (TypeVariable key : reqMap.keySet()) {
            Type val = (Type)reqMap.get(key);
            if (!Any.is((Object)val)) continue;
            reqMap.put(key, (Type)infoMap.get(key));
        }
        return Types.unroll((Type)raw, reqMap);
    }

    private double calculatePriority(OpEnvironment env) {
        double base = -10000.0;
        double originalPriority = this.info.priority();
        double penalty = 0.0;
        List originalInputs = this.info.inputTypes();
        List inputs = this.inputTypes();
        for (int i = 0; i < inputs.size(); ++i) {
            Type from = (Type)inputs.get(i);
            Type to = Types.unroll((Type)((Type)originalInputs.get(i)), this.typeVarAssigns);
            penalty += ConvertedOpInfo.determineLoss(env, Nil.of((Type)from), Nil.of((Type)to));
        }
        Type opOutput = this.info.outputType();
        return base + originalPriority - (penalty += ConvertedOpInfo.determineLoss(env, Nil.of((Type)opOutput), Nil.of((Type)this.outputType())));
    }

    private static <T, R> double determineLoss(OpEnvironment env, Nil<T> from, Nil<R> to) {
        ParameterizedType specialType = Types.parameterize(LossReporter.class, (Type[])new Type[]{from.type(), to.type()});
        Nil specialTypeNil = Nil.of((Type)specialType);
        try {
            ParameterizedType nilFromType = Types.parameterize(Nil.class, (Type[])new Type[]{from.type()});
            ParameterizedType nilToType = Types.parameterize(Nil.class, (Type[])new Type[]{to.type()});
            Hints h = new Hints(new String[]{"adaptation.FORBIDDEN", "conversion.FORBIDDEN", "history.IGNORE"});
            LossReporter op = (LossReporter)env.op("engine.lossReporter", specialTypeNil, new Nil[]{Nil.of((Type)nilFromType), Nil.of((Type)nilToType)}, Nil.of(Double.class), h);
            return op.apply(from, to);
        }
        catch (OpMatchingException e) {
            return Double.POSITIVE_INFINITY;
        }
    }

    private static ParameterizedType retypeOpType(Type originalOpType, Type[] newArgs, Type newOutType) {
        Class opType = Types.raw((Type)originalOpType);
        Method fMethod = FunctionalInterfaces.functionalMethodOf((Type)opType);
        HashMap typeVarAssigns = new HashMap();
        Type[] genericParameterTypes = ConvertedOpInfo.paramTypesFromOpType(opType, fMethod);
        GenericAssignability.inferTypeVariables((Type[])genericParameterTypes, (Type[])newArgs, typeVarAssigns);
        Type genericReturnType = ConvertedOpInfo.returnTypeFromOpType(opType, fMethod);
        if (genericReturnType != Void.TYPE) {
            GenericAssignability.inferTypeVariables((Type[])new Type[]{genericReturnType}, (Type[])new Type[]{newOutType}, typeVarAssigns);
        }
        return Types.parameterize((Class)opType, typeVarAssigns);
    }

    private static Type[] paramTypesFromOpType(Class<?> opType, Method fMethod) {
        Type[] genericParameterTypes = fMethod.getGenericParameterTypes();
        if (fMethod.getDeclaringClass().equals(opType)) {
            return genericParameterTypes;
        }
        return ConvertedOpInfo.typesFromOpType(opType, fMethod, genericParameterTypes);
    }

    private static Type returnTypeFromOpType(Class<?> opType, Method fMethod) {
        Type genericReturnType = fMethod.getGenericReturnType();
        if (fMethod.getDeclaringClass().equals(opType)) {
            return genericReturnType;
        }
        return ConvertedOpInfo.typesFromOpType(opType, fMethod, genericReturnType)[0];
    }

    private static Type[] typesFromOpType(Class<?> opType, Method fMethod, Type ... types) {
        HashMap map = new HashMap();
        Class<?> declaringClass = fMethod.getDeclaringClass();
        ParameterizedType genericDeclaringClass = Types.parameterize(declaringClass, (Type[])new Type[0]);
        ParameterizedType genericClass = Types.parameterize(opType, (Type[])new Type[0]);
        Type superGenericClass = Types.superTypeOf((Type)genericClass, declaringClass);
        GenericAssignability.inferTypeVariables((Type[])new Type[]{genericDeclaringClass}, (Type[])new Type[]{superGenericClass}, map);
        return Types.unroll((Type[])types, map);
    }

    private static Object javassistOp(Object originalOp, OpInfo alteredInfo, List<Function<?, ?>> preconverters, Function<?, ?> postconverter, Computers.Arity1<?, ?> copyOp) throws Throwable {
        Class c;
        ClassPool pool = ClassPool.getDefault();
        String className = ConvertedOpInfo.formClassName(alteredInfo);
        try {
            c = pool.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            CtClass cc = ConvertedOpInfo.generateConvertedClass(pool, className, alteredInfo, preconverters, copyOp);
            c = cc.toClass(MethodHandles.lookup());
        }
        return c.getDeclaredConstructor(ConvertedOpInfo.constructorClasses(alteredInfo, copyOp != null)).newInstance(ConvertedOpInfo.constructorArgs(preconverters, postconverter, copyOp, originalOp));
    }

    private static Class<?>[] constructorClasses(OpInfo originalInfo, boolean addCopyOp) {
        int numMutators = originalInfo.inputTypes().size() + 1;
        int numOps = addCopyOp ? 2 : 1;
        Class[] args = new Class[numMutators + numOps];
        for (int i = 0; i < numMutators; ++i) {
            args[i] = Function.class;
        }
        args[args.length - numOps] = Types.raw((Type)originalInfo.opType());
        if (addCopyOp) {
            args[args.length - 1] = Computers.Arity1.class;
        }
        return args;
    }

    private static Object[] constructorArgs(List<Function<?, ?>> preconverters, Function<?, ?> postconverter, Computers.Arity1<?, ?> outputCopier, Object op) {
        ArrayList args = new ArrayList(preconverters);
        args.add(postconverter);
        args.add((Function<?, ?>)op);
        if (outputCopier != null) {
            args.add((Function<?, ?>)outputCopier);
        }
        return args.toArray();
    }

    private static String formClassName(OpInfo altered) {
        String packageName = Conversions.class.getPackageName();
        StringBuilder sb = new StringBuilder(packageName + ".");
        String implementationName = altered.implementationName();
        String className = implementationName.replaceAll("[^a-zA-Z0-9\\-]", "_");
        if (className.chars().anyMatch(c -> !Character.isJavaIdentifierPart(c))) {
            throw new IllegalArgumentException(className + " is not a valid class name!");
        }
        sb.append(className);
        return sb.toString();
    }

    private static CtClass generateConvertedClass(ClassPool pool, String className, OpInfo altered, List<Function<?, ?>> preconverters, Computers.Arity1<?, ?> outputCopier) throws Throwable {
        CtClass cc = pool.makeClass(className);
        Class rawType = Types.raw((Type)altered.opType());
        CtClass jasOpType = pool.get(rawType.getName());
        cc.addInterface(jasOpType);
        ConvertedOpInfo.generateNFields(pool, cc, "preconverter", preconverters.size());
        ConvertedOpInfo.generateNFields(pool, cc, "postconverter", 1);
        CtField opField = ConvertedOpInfo.createOpField(pool, cc, rawType, "op");
        cc.addField(opField);
        if (outputCopier != null) {
            CtField copyOpField = ConvertedOpInfo.createOpField(pool, cc, Computers.Arity1.class, "copyOp");
            cc.addField(copyOpField);
        }
        CtConstructor constructor = CtNewConstructor.make((String)ConvertedOpInfo.createConstructor(cc, altered, preconverters.size(), outputCopier != null), (CtClass)cc);
        cc.addConstructor(constructor);
        Class opType = Types.raw((Type)altered.opType());
        int ioIndex = Conversions.mutableIndexOf(opType);
        CtMethod functionalMethod = CtNewMethod.make((String)ConvertedOpInfo.createFunctionalMethod(opType, ioIndex, altered, preconverters, outputCopier), (CtClass)cc);
        cc.addMethod(functionalMethod);
        return cc;
    }

    private static void generateNFields(ClassPool pool, CtClass cc, String base, int numFields) throws NotFoundException, CannotCompileException {
        for (int i = 0; i < numFields; ++i) {
            CtField f = ConvertedOpInfo.createMutatorField(pool, cc, base + i);
            cc.addField(f);
        }
    }

    private static CtField createMutatorField(ClassPool pool, CtClass cc, String name) throws NotFoundException, CannotCompileException {
        CtClass fType = pool.get(Function.class.getName());
        CtField f = new CtField(fType, name, cc);
        f.setModifiers(18);
        return f;
    }

    private static CtField createOpField(ClassPool pool, CtClass cc, Class<?> opType, String fieldName) throws NotFoundException, CannotCompileException {
        CtClass fType = pool.get(opType.getName());
        CtField f = new CtField(fType, fieldName, cc);
        f.setModifiers(18);
        return f;
    }

    private static String createConstructor(CtClass cc, OpInfo altered, int numInputProcessors, boolean hasCopyOp) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("public ").append(cc.getSimpleName()).append("(");
        Class<Function> depClass = Function.class;
        for (i = 0; i < numInputProcessors; ++i) {
            sb.append(depClass.getName()).append(" preconverter").append(i);
            sb.append(",");
        }
        sb.append(depClass.getName()).append(" postconverter0");
        sb.append(",");
        sb.append(" ").append(Types.raw((Type)altered.opType()).getName()).append(" op");
        if (hasCopyOp) {
            Class<Computers.Arity1> copyOpClass = Computers.Arity1.class;
            sb.append(", ").append(copyOpClass.getName()).append(" copyOp");
        }
        sb.append(") {");
        for (i = 0; i < numInputProcessors; ++i) {
            sb.append("this.preconverter").append(i).append(" = preconverter").append(i).append(";");
        }
        sb.append("this.postconverter0 = postconverter0;");
        sb.append("this.op = op;");
        if (hasCopyOp) {
            sb.append("this.copyOp = copyOp;");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String createFunctionalMethod(Class<?> opType, int ioIndex, OpInfo altered, List<Function<?, ?>> preconverters, Computers.Arity1<?, ?> copier) {
        StringBuilder sb = new StringBuilder();
        Method m = FunctionalInterfaces.functionalMethodOf(opType);
        Object opOutput = "originalOut";
        if (ioIndex > -1) {
            opOutput = "processed" + ioIndex;
        }
        sb.append(ConvertedOpInfo.generateSignature(m));
        sb.append(" {");
        sb.append(ConvertedOpInfo.fMethodPreprocessing(preconverters));
        sb.append(ConvertedOpInfo.fMethodProcessing(m, (String)opOutput, ioIndex, altered));
        sb.append(ConvertedOpInfo.fMethodPostprocessing((String)opOutput, ioIndex, copier));
        if (ioIndex == -1) {
            sb.append("return processedOutput;");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String generateSignature(Method m) {
        StringBuilder sb = new StringBuilder();
        String methodName = m.getName();
        boolean isVoid = m.getReturnType() == Void.TYPE;
        sb.append("public ").append(isVoid ? "void" : "Object").append(" ").append(methodName).append("(");
        int inputs = m.getParameterCount();
        for (int i = 0; i < inputs; ++i) {
            sb.append(" Object in").append(i);
            if (i >= inputs - 1) continue;
            sb.append(",");
        }
        sb.append(" )");
        return sb.toString();
    }

    private static String fMethodProcessing(Method m, String opOutput, int ioIndex, OpInfo altered) {
        StringBuilder sb = new StringBuilder();
        if (ioIndex == -1) {
            sb.append("Object ").append(opOutput).append(" = ");
        }
        sb.append("op.").append(m.getName()).append("(");
        int numInputs = altered.inputTypes().size();
        for (int i = 0; i < numInputs; ++i) {
            sb.append(" processed").append(i);
            if (i + 1 >= numInputs) continue;
            sb.append(",");
        }
        sb.append(");");
        return sb.toString();
    }

    private static String fMethodPostprocessing(String opOutput, int ioIndex, Computers.Arity1<?, ?> outputCopier) {
        StringBuilder sb = new StringBuilder();
        sb.append("Object processedOutput = postconverter0.apply(").append(opOutput).append(");");
        if (outputCopier != null) {
            String originalIOArg = "in" + ioIndex;
            sb.append("copyOp.compute(processedOutput, ").append(originalIOArg).append(");");
        }
        return sb.toString();
    }

    private static String fMethodPreprocessing(List<Function<?, ?>> preconverter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < preconverter.size(); ++i) {
            sb.append("Object processed").append(i).append(" = preconverter").append(i).append(".apply(in").append(i).append(");");
        }
        return sb.toString();
    }

    public Map<TypeVariable<?>, Type> typeVarAssigns() {
        return this.typeVarAssigns;
    }
}

