/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.exceptions.impl.InstanceOpMethodException;
import org.scijava.ops.engine.exceptions.impl.PrivateOpException;
import org.scijava.ops.engine.exceptions.impl.UnreadableOpException;
import org.scijava.ops.engine.struct.MethodOpDependencyMemberParser;
import org.scijava.ops.engine.struct.MethodParameterMemberParser;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.engine.util.internal.OpMethodUtils;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.Structs;

public class DefaultOpMethodInfo
implements OpInfo {
    private final Method method;
    private final String description;
    private final String version;
    private final List<String> names;
    private final Type opType;
    private final Struct struct;
    private final double priority;
    private final Hints hints;

    public DefaultOpMethodInfo(Method method, Class<?> opType, String version, String description, Hints hints, double priority, String ... names) {
        this.method = method;
        this.version = version;
        this.description = description;
        this.names = Arrays.asList(names);
        this.hints = hints;
        this.priority = priority;
        this.checkModifiers();
        this.opType = OpMethodUtils.getOpMethodType(opType, method);
        this.struct = Structs.from((Object)method, opType, (MemberParser[])new MemberParser[]{new MethodParameterMemberParser(), new MethodOpDependencyMemberParser()});
        Infos.validate(this);
    }

    private void checkModifiers() {
        String packageName;
        if (!Modifier.isPublic(this.method.getModifiers())) {
            throw new PrivateOpException(this.method);
        }
        if (!Modifier.isStatic(this.method.getModifiers())) {
            throw new InstanceOpMethodException(this.method);
        }
        Module methodModule = this.method.getDeclaringClass().getModule();
        if (methodModule != this.getClass().getModule() && !methodModule.isOpen(packageName = this.method.getDeclaringClass().getPackageName(), methodModule)) {
            throw new UnreadableOpException(packageName);
        }
    }

    public List<String> names() {
        return this.names;
    }

    public String description() {
        return this.description;
    }

    public Type opType() {
        return this.opType;
    }

    public Struct struct() {
        return this.struct;
    }

    public Hints declaredHints() {
        return this.hints;
    }

    public double priority() {
        return this.priority;
    }

    public String implementationName() {
        String fullyQualifiedMethod = this.method.toGenericString();
        String packageName = this.method.getDeclaringClass().getPackageName();
        int classNameIndex = fullyQualifiedMethod.indexOf(packageName);
        return fullyQualifiedMethod.substring(classNameIndex);
    }

    public StructInstance<?> createOpInstance(List<?> dependencies) {
        return OpMethodUtils.createOpInstance(this, this.method, dependencies);
    }

    public String version() {
        return this.version;
    }

    public String id() {
        return "|Info:" + this.implementationName() + "@" + this.version();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultOpMethodInfo)) {
            return false;
        }
        OpInfo that = (OpInfo)o;
        return this.struct().equals(that.struct());
    }

    public int hashCode() {
        return this.struct().hashCode();
    }

    public String toString() {
        return Infos.describe(this);
    }

    public AnnotatedElement getAnnotationBearer() {
        return this.method;
    }
}

