/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.reduce;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.matcher.reduce.InfoReducer;
import org.scijava.ops.engine.matcher.reduce.ReducedOpInfo;
import org.scijava.types.infer.FunctionalInterfaces;

public abstract class AbstractInfoReducer
implements InfoReducer {
    @Override
    public boolean canReduce(OpInfo info) {
        boolean isReducerType = this.isReducerType(FunctionalInterfaces.findFrom((Type)info.opType()));
        boolean canReduce = info.declaredHints().containsNone(new String[]{"reduction.FORBIDDEN"});
        return isReducerType && canReduce;
    }

    @Override
    public ReducedOpInfo reduce(OpInfo info, int numReductions) {
        Class rawType = FunctionalInterfaces.findFrom((Type)info.opType());
        int originalArity = this.arityOf(rawType);
        int reducedArity = originalArity - numReductions;
        Class<?> reducedRawType = this.ofArity(reducedArity);
        Type[] inputTypes = (Type[])info.inputTypes().toArray(Type[]::new);
        Type outputType = info.output().type();
        Type[] newTypes = new Type[reducedArity + 1];
        if (reducedArity >= 0) {
            System.arraycopy(inputTypes, 0, newTypes, 0, reducedArity);
        }
        newTypes[newTypes.length - 1] = outputType;
        ParameterizedType reducedOpType = Types.parameterize(reducedRawType, (Type[])newTypes);
        return new ReducedOpInfo(info, reducedOpType, originalArity - reducedArity);
    }

    protected abstract boolean isReducerType(Class<?> var1);

    protected abstract int arityOf(Class<?> var1);

    protected abstract Class<?> ofArity(int var1);
}

