/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.kendallTau;

import java.util.Iterator;
import java.util.function.BiFunction;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.IterablePair;
import net.imglib2.util.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractColocalisationTest;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.coloc.pValue.PValueResult;
import org.scijava.types.Nil;

public class KendallTauBRankTest
extends AbstractOpTest {
    private boolean exhaustive = false;
    private int seed;

    @Test
    public void testKendallTauBRankSimple() {
        Assumptions.assumeTrue((!this.exhaustive ? 1 : 0) != 0);
        this.assertTau(0.5111111111111111, new int[]{4, 10, 3, 1, 9, 2, 6, 7, 8, 5}, new int[]{5, 8, 6, 2, 10, 3, 9, 4, 7, 1});
    }

    @Test
    public void testKendallTauBRankPathological() {
        Assumptions.assumeTrue((!this.exhaustive ? 1 : 0) != 0);
        this.assertTau(Double.NaN, new int[]{1, 1, 1, 1}, new int[]{2, 2, 2, 2});
    }

    @Test
    public void testKendallTauBRankSomeDuplicates() {
        Assumptions.assumeTrue((!this.exhaustive ? 1 : 0) != 0);
        this.assertTau(-0.8, new int[]{1, 1, 2, 3}, new int[]{3, 2, 1, 1});
    }

    @Test
    public void testKendallTauBRankExhaustive() {
        Assumptions.assumeTrue((boolean)this.exhaustive);
        int n = 5;
        int m = 10;
        int[] values1 = new int[5];
        int[] values2 = new int[5];
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 5; ++j) {
                values1[j] = Math.abs(this.pseudoRandom()) % 10;
                values2[j] = Math.abs(this.pseudoRandom()) % 10;
            }
            IterablePair iter = new IterablePair((Iterable)ArrayImgs.ints((int[])values1, (long[])new long[]{5L}), (Iterable)ArrayImgs.ints((int[])values2, (long[])new long[]{5L}));
            double kendallValue1 = this.calculateNaive(iter.iterator());
            double kendallValue2 = (Double)ops.op("coloc.kendallTau").input((Object)values1, (Object)values2).outType(Double.class).apply();
            if (Double.isNaN(kendallValue1)) {
                Assertions.assertTrue((Double.isInfinite(kendallValue2) || Double.isNaN(kendallValue2) ? 1 : 0) != 0, (String)("i: " + i + ", value2: " + kendallValue2));
                continue;
            }
            Assertions.assertEquals((double)kendallValue1, (double)kendallValue2, (double)1.0E-10, (String)("i: " + i));
        }
    }

    @Test
    public void testPValue() {
        double mean = 0.2;
        double spread = 0.1;
        double[] sigma = new double[]{3.0, 3.0};
        Img<FloatType> ch1 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, 19088743L);
        Img<FloatType> ch2 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, -1737075662L);
        Nil<Iterable<FloatType>> nilI = new Nil<Iterable<FloatType>>(){};
        Nil<RandomAccessibleInterval<FloatType>> nilRAI = new Nil<RandomAccessibleInterval<FloatType>>(){};
        BiFunction op = OpBuilder.matchFunction((OpEnvironment)ops, (String)"coloc.kendallTau", (Nil)nilRAI, (Nil)nilRAI, (Nil)new Nil<Double>(){});
        PValueResult value = new PValueResult();
        ops.op("coloc.pValue").input(ch1, ch2, (Object)op).output((Object)value).compute();
        Assertions.assertEquals((double)0.75, (double)value.getPValue(), (double)0.0);
    }

    private int pseudoRandom() {
        this.seed = 3170425 * this.seed + 132102;
        return this.seed;
    }

    private <T extends RealType<T>, U extends RealType<U>> void assertTau(double expected, Iterable<T> img1, Iterable<U> img2) {
        double kendallValue = (Double)ops.op("coloc.kendallTau").input(img1, img2).apply();
        Assertions.assertEquals((double)expected, (double)kendallValue, (double)1.0E-10);
    }

    private void assertTau(double expected, int[] values1, int[] values2) {
        this.assertTau(expected, (Iterable)ArrayImgs.ints((int[])values1, (long[])new long[]{values1.length}), (Iterable)ArrayImgs.ints((int[])values2, (long[])new long[]{values2.length}));
    }

    private <T extends RealType<T>, U extends RealType<U>> double calculateNaive(Iterator<Pair<T, U>> iterator) {
        if (!iterator.hasNext()) {
            return Double.NaN;
        }
        int n = 0;
        int max1 = 0;
        int max2 = 0;
        int max = 255;
        int[][] histogram = new int[max + 1][max + 1];
        while (iterator.hasNext()) {
            Pair<T, U> v = iterator.next();
            double ch1 = ((RealType)v.getA()).getRealDouble();
            double ch2 = ((RealType)v.getB()).getRealDouble();
            if (ch1 < 0.0 || ch2 < 0.0 || ch1 > (double)max || ch2 > (double)max) {
                return Double.NaN;
            }
            ++n;
            int ch1Int = (int)Math.round(ch1);
            int ch2Int = (int)Math.round(ch2);
            int[] nArray = histogram[ch1Int];
            int n2 = ch2Int;
            nArray[n2] = nArray[n2] + 1;
            if (max1 < ch1Int) {
                max1 = ch1Int;
            }
            if (max2 >= ch2Int) continue;
            max2 = ch2Int;
        }
        long n0 = (long)n * (long)(n - 1) / 2L;
        long n1 = 0L;
        long n2 = 0L;
        long nc = 0L;
        long nd = 0L;
        for (int i1 = 0; i1 <= max1; ++i1) {
            int ch1 = 0;
            for (int i2 = 0; i2 <= max2; ++i2) {
                int j2;
                int j1;
                ch1 += histogram[i1][i2];
                int count = histogram[i1][i2];
                for (j1 = 0; j1 < i1; ++j1) {
                    for (j2 = 0; j2 < i2; ++j2) {
                        nc += (long)(count * histogram[j1][j2]);
                    }
                }
                for (j1 = 0; j1 < i1; ++j1) {
                    for (j2 = i2 + 1; j2 <= max2; ++j2) {
                        nd += (long)(count * histogram[j1][j2]);
                    }
                }
            }
            n1 += (long)ch1 * (long)(ch1 - 1) / 2L;
        }
        for (int i2 = 0; i2 <= max2; ++i2) {
            int ch2 = 0;
            for (int i1 = 0; i1 <= max1; ++i1) {
                ch2 += histogram[i1][i2];
            }
            n2 += (long)ch2 * (long)(ch2 - 1) / 2L;
        }
        return (double)(nc - nd) / Math.sqrt((double)(n0 - n1) * (double)(n0 - n2));
    }
}

