/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.saca;

import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractColocalisationTest;
import org.scijava.types.Nil;

public class SACATest
extends AbstractColocalisationTest {
    private static final int[] xPositions = new int[]{30, 79, 77, 104, 7, 52, 164, 88, 119, 65};
    private static final int[] yPositions = new int[]{30, 36, 80, 79, 139, 102, 77, 41, 142, 118};
    private static Img<DoubleType> zscore;

    @BeforeAll
    public static void setUpTest() {
        Img<UnsignedByteType> green = SACATest.getPositiveCorrelationImageCh1();
        Img<UnsignedByteType> red = SACATest.getPositiveCorrelationImageCh2();
        Object gs = ops.op("transform.hyperSliceView").input(green, (Object)2, (Object)15).apply();
        Object rs = ops.op("transform.hyperSliceView").input(red, (Object)2, (Object)15).apply();
        zscore = (Img)ops.op("create.img").input(gs, (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        ops.op("coloc.saca.heatmapZScore").input(gs, rs).output(zscore).compute();
    }

    @Test
    public void testSACAHeatmapZScore() {
        double[] zscoreExpected = new double[]{0.0, 6.117364936585281, 0.0, -1.282447034877343, 0.0, 6.642396454955293, 0.0, -1.6567255788972388, 0.0, 3.5385003044434877};
        RandomAccess zRA = zscore.randomAccess();
        for (int i = 0; i < xPositions.length; ++i) {
            zRA.setPosition(xPositions[i], 0);
            zRA.setPosition(yPositions[i], 1);
            Assertions.assertEquals((double)zscoreExpected[i], (double)((DoubleType)zRA.get()).getRealDouble());
        }
    }

    @Test
    public void testSACASigMask() {
        double[] sigExpected = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0};
        Img sigMask = (Img)ops.op("create.img").input(zscore, (Object)new BitType()).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("coloc.saca.sigMask").input(zscore).output((Object)sigMask).compute();
        RandomAccess sRA = sigMask.randomAccess();
        for (int i = 0; i < xPositions.length; ++i) {
            sRA.setPosition(xPositions[i], 0);
            sRA.setPosition(yPositions[i], 1);
            Assertions.assertEquals((double)sigExpected[i], (double)((BitType)sRA.get()).getRealDouble());
        }
    }
}

