/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.convert.Types;

public class ConvertMapTest
extends AbstractOpTest {
    private static final long[] dims = new long[]{3L, 3L};

    @Test
    public void testLossless() {
        byte[] inArray = new byte[]{12, 122, 9, -6, 56, 34, 108, 1, 73};
        Img<UnsignedByteType> in = ConvertMapTest.generateUnsignedByteImg(inArray);
        float[] outArray = new float[]{134.7f, -13089.32f, 209.3f, 0.6f, 84.0f, -543.1f, 0.0f, 34.908f, 592087.1f};
        Img<FloatType> out = ConvertMapTest.generateFloatImg(outArray);
        Cursor inC1 = in.cursor();
        Cursor outC1 = out.cursor();
        while (inC1.hasNext()) {
            Assertions.assertNotEquals((double)((UnsignedByteType)inC1.next()).getRealDouble(), (double)((FloatType)outC1.next()).getRealDouble(), (double)0.0);
        }
        ops.op("convert.float32").input(in).output(out).compute();
        Cursor inC2 = in.cursor();
        Cursor outC2 = out.cursor();
        while (inC2.hasNext()) {
            Assertions.assertEquals((double)((UnsignedByteType)inC2.next()).getRealDouble(), (double)((FloatType)outC2.next()).getRealDouble(), (double)0.0);
        }
    }

    @Test
    public void testLossy() {
        float[] inArray = new float[]{12.7f, -13089.32f, 78.023f, 0.04f, 12.01f, -1208.9f, 109432.11f, 1204.88f, 87.6f};
        Img<FloatType> in = ConvertMapTest.generateFloatImg(inArray);
        byte[] outArray = new byte[]{4, 123, 18, 64, 90, 120, 12, 17, 73};
        Img<UnsignedByteType> out = ConvertMapTest.generateUnsignedByteImg(outArray);
        ops.op("convert.uint8").input(in).output(out).compute();
        Cursor inC = in.cursor();
        Cursor outC = out.cursor();
        while (inC.hasNext()) {
            double inV = ((FloatType)inC.next()).getRealDouble();
            double outV = ((UnsignedByteType)outC.next()).getRealDouble();
            Assertions.assertNotEquals((double)inV, (double)outV, (double)0.0);
            Assertions.assertEquals((double)Types.uint8((double)inV), (double)outV, (double)0.0);
        }
    }

    private static Img<FloatType> generateFloatImg(float[] values) {
        float[] array = new float[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (array.length != values.length) {
            throw new RuntimeException("Number of values doesn't match dimensions");
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = values[i];
        }
        return ArrayImgs.floats((float[])array, (long[])dims);
    }

    private static Img<UnsignedByteType> generateUnsignedByteImg(byte[] values) {
        byte[] array = new byte[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        if (array.length != values.length) {
            throw new RuntimeException("Number of values doesn't match dimensions");
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = values[i];
        }
        return ArrayImgs.unsignedBytes((byte[])array, (long[])dims);
    }
}

