/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.bilateral;

import net.imglib2.Cursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.ByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;

public class DefaultBilateralTest
extends AbstractOpTest {
    @Test
    public void testBigImage() {
        byte[] data = new byte[]{7, 8, 9, 1, 2, 3, 7, 9, 8, 1, 3, 2, 8, 7, 9, 2, 1, 3, 8, 9, 7, 2, 3, 1, 9, 7, 8, 3, 1, 2, 9, 8, 7, 3, 2, 1};
        ArrayImg in = ArrayImgs.bytes((byte[])data, (long[])new long[]{6L, 6L});
        ArrayImg<ByteType, ByteArray> out = TestImgGeneration.byteArray(false, 6L, 6L);
        ops.op("filter.bilateral").input((Object)in, (Object)15.0, (Object)5.0, (Object)2).output(out).compute();
        byte[] expected = new byte[]{8, 7, 6, 4, 3, 2, 8, 7, 6, 4, 3, 2, 8, 7, 6, 4, 3, 2, 8, 7, 6, 4, 3, 2, 8, 7, 6, 4, 3, 2, 8, 7, 6, 4, 3, 2};
        Cursor cout = out.cursor();
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((byte)((ByteType)cout.next()).get(), (byte)expected[i]);
        }
    }

    @Test
    public void testMath() {
        byte[] data = new byte[]{7, 4, 9, 1};
        ArrayImg in = ArrayImgs.bytes((byte[])data, (long[])new long[]{2L, 2L});
        ArrayImg<ByteType, ByteArray> out = TestImgGeneration.byteArray(false, 2L, 2L);
        ops.op("filter.bilateral").input((Object)in, (Object)15.0, (Object)5.0, (Object)1).output(out).compute();
        Cursor cout = out.cursor();
        byte[] expected = new byte[]{5, 5, 5, 5};
        int counter = 0;
        while (cout.hasNext()) {
            byte actual = ((ByteType)cout.next()).get();
            Assertions.assertEquals((byte)expected[counter++], (byte)actual);
        }
    }

    @Test
    public void testArrayToCellImg() {
        byte[] data = new byte[]{7, 8, 9, 1, 2, 3, 7, 9, 8, 1, 3, 2, 8, 7, 9, 2, 1, 3, 8, 9, 7, 2, 3, 1, 9, 7, 8, 3, 1, 2, 9, 8, 7, 3, 2, 1};
        ArrayImg in = ArrayImgs.bytes((byte[])data, (long[])new long[]{6L, 6L});
        ArrayImg<ByteType, ByteArray> out = TestImgGeneration.byteArray(false, 6L, 6L);
        ArrayImg<ByteType, ByteArray> cellOut = TestImgGeneration.byteArray(false, 6L, 6L);
        ops.op("filter.bilateral").input((Object)in, (Object)15.0, (Object)5.0, (Object)2).output(out).compute();
        ops.op("filter.bilateral").input((Object)in, (Object)15.0, (Object)5.0, (Object)2).output(cellOut).compute();
        Cursor cout = out.cursor();
        Cursor cCellOut = cellOut.cursor();
        while (cout.hasNext()) {
            byte expected = ((ByteType)cout.next()).get();
            byte actual = ((ByteType)cCellOut.next()).get();
            Assertions.assertEquals((byte)expected, (byte)actual);
        }
    }

    @Test
    public void testZeroes() {
        byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ArrayImg in = ArrayImgs.bytes((byte[])data, (long[])new long[]{6L, 6L});
        ArrayImg<ByteType, ByteArray> out = TestImgGeneration.byteArray(false, 6L, 6L);
        ops.op("filter.bilateral").input((Object)in, (Object)15.0, (Object)5.0, (Object)2).output(out).compute();
        Cursor cout = out.cursor();
        while (cout.hasNext()) {
            byte expected = ((ByteType)cout.next()).get();
            Assertions.assertEquals((int)expected, (int)0);
        }
    }

    @Test
    public void testNegatives() {
        byte[] data = new byte[]{-7, -8, -9, -1, -2, -3, -7, -9, -8, -1, -3, -2, -8, -7, -9, -2, -1, -3, -8, -9, -7, -2, -3, -1, -9, -7, -8, -3, -1, -2, -9, -8, -7, -3, -2, -1};
        ArrayImg in = ArrayImgs.bytes((byte[])data, (long[])new long[]{6L, 6L});
        ArrayImg<ByteType, ByteArray> out = TestImgGeneration.byteArray(false, 6L, 6L);
        ops.op("filter.bilateral").input((Object)in, (Object)15.0, (Object)5.0, (Object)2).output(out).compute();
        byte[] expected = new byte[]{-8, -7, -6, -4, -3, -2, -8, -7, -6, -4, -3, -2, -8, -7, -6, -4, -3, -2, -8, -7, -6, -4, -3, -2, -8, -7, -6, -4, -3, -2, -8, -7, -6, -4, -3, -2};
        Cursor cout = out.cursor();
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((byte)((ByteType)cout.next()).get(), (byte)expected[i]);
        }
    }
}

