/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.derivative;

import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.CompositeView;
import net.imglib2.view.composite.RealComposite;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class PartialDerivativeFilterTest
extends AbstractOpTest {
    @Test
    public void test() {
        ArrayImg<FloatType, FloatArray> img = TestImgGeneration.floatArray(false, 20L, 20L);
        Cursor cursorImg = img.cursor();
        int counterX = 0;
        int counterY = 0;
        while (cursorImg.hasNext()) {
            if (counterX > 8 && counterX < 12 || counterY > 8 && counterY < 12) {
                ((FloatType)cursorImg.next()).setOne();
            } else {
                ((FloatType)cursorImg.next()).setZero();
            }
            if (++counterX % 20 == 0) {
                ++counterY;
            }
            if (counterX == 20) {
                counterX = 0;
            }
            if (counterY != 20) continue;
            counterY = 0;
        }
        RandomAccessibleInterval out = (RandomAccessibleInterval)ops.op("filter.partialDerivative").input(img, (Object)0).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        FloatType type = ((FloatType)Util.getTypeFromInterval((Interval)out)).createVariable();
        type.set(4.0f);
        RandomAccess outRA = out.randomAccess();
        int i = 0;
        while (i < 8) {
            outRA.setPosition(new int[]{9, i++});
            Assertions.assertEquals((Object)type, (Object)outRA.get());
        }
        outRA.setPosition(new int[]{9, 8});
        type.set(3.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{9, 10});
        type.set(0.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{9, 11});
        type.set(1.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{9, 12});
        type.set(3.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        type.set(4.0f);
        i = 13;
        while (i < 20) {
            outRA.setPosition(new int[]{9, i++});
            Assertions.assertEquals((Object)type, (Object)outRA.get());
        }
        type.set(-4.0f);
        i = 0;
        while (i < 8) {
            outRA.setPosition(new int[]{12, i++});
            Assertions.assertEquals((Object)type, (Object)outRA.get());
        }
        outRA.setPosition(new int[]{12, 8});
        type.set(-3.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{12, 10});
        type.set(0.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{12, 11});
        type.set(-1.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{12, 12});
        type.set(-3.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        type.set(-4.0f);
        i = 13;
        while (i < 20) {
            outRA.setPosition(new int[]{12, i++});
            Assertions.assertEquals((Object)type, (Object)outRA.get());
        }
    }

    @Test
    public void testAllDerivatives() {
        ArrayImg<FloatType, FloatArray> img = TestImgGeneration.floatArray(false, 20L, 20L, 3L);
        Cursor cursorImg = img.cursor();
        int counterX = 0;
        int counterY = 0;
        while (cursorImg.hasNext()) {
            if (counterX > 8 && counterX < 12 || counterY > 8 && counterY < 12) {
                ((FloatType)cursorImg.next()).setOne();
            } else {
                ((FloatType)cursorImg.next()).setZero();
            }
            if (++counterX % 20 == 0) {
                ++counterY;
            }
            if (counterX == 20) {
                counterX = 0;
            }
            if (counterY != 20) continue;
            counterY = 0;
        }
        CompositeIntervalView out = (CompositeIntervalView)ops.op("filter.partialDerivative").input(img).outType((Nil)new Nil<CompositeIntervalView<FloatType, RealComposite<FloatType>>>(){}).apply();
        CompositeView.CompositeRandomAccess outRA = out.randomAccess();
        FloatType type = ((FloatType)Util.getTypeFromInterval(img)).createVariable();
        outRA.setPosition(new int[]{9, 8, 0});
        RealComposite outvalue = (RealComposite)outRA.get();
        Float[] correctValues = new Float[]{Float.valueOf(12.0f), Float.valueOf(4.0f), Float.valueOf(0.0f)};
        int i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 8, 1});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(12.0f), Float.valueOf(4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 8, 2});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(12.0f), Float.valueOf(4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 9, 0});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(4.0f), Float.valueOf(4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 9, 1});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(4.0f), Float.valueOf(4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 9, 2});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(4.0f), Float.valueOf(4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 10, 0});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 10, 1});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 10, 2});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 11, 0});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(4.0f), Float.valueOf(-4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 11, 1});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(4.0f), Float.valueOf(-4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
        outRA.setPosition(new int[]{9, 11, 2});
        outvalue = (RealComposite)outRA.get();
        correctValues = new Float[]{Float.valueOf(4.0f), Float.valueOf(-4.0f), Float.valueOf(0.0f)};
        i = 0;
        for (FloatType value : outvalue) {
            type.set(correctValues[i].floatValue());
            Assertions.assertEquals((Object)type, (Object)value);
            ++i;
        }
    }
}

