/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.dog;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.dog.DifferenceOfGaussian;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class DoGTest
extends AbstractOpTest {
    @Test
    public void testDogRAI() {
        double[] sigmas1 = new double[]{1.0, 1.0};
        double[] sigmas2 = new double[]{2.0, 2.0};
        long[] dims = new long[]{10L, 10L};
        ArrayImg<ByteType, ByteArray> in = TestImgGeneration.byteArray(true, dims);
        ArrayImg<ByteType, ByteArray> out1 = TestImgGeneration.byteArray(false, dims);
        ArrayImg<ByteType, ByteArray> out2 = TestImgGeneration.byteArray(false, dims);
        OutOfBoundsMirrorFactory outOfBounds = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        ops.op("filter.dog").input(in, (Object)sigmas1, (Object)sigmas2, (Object)outOfBounds).output(out1).compute();
        DifferenceOfGaussian.DoG((double[])sigmas1, (double[])sigmas2, (RandomAccessible)Views.extendMirrorSingle(in), out2, (ExecutorService)Executors.newFixedThreadPool(10));
        Cursor out1Cursor = out1.cursor();
        Cursor out2Cursor = out2.cursor();
        while (out1Cursor.hasNext()) {
            Assertions.assertEquals((double)((ByteType)out1Cursor.next()).getRealDouble(), (double)((ByteType)out2Cursor.next()).getRealDouble(), (double)0.0);
        }
    }

    @Test
    public void testDogRAISingleSigmas() {
        OutOfBoundsMirrorFactory outOfBounds = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        RandomAccessibleInterval res = (RandomAccessibleInterval)ops.op("create.img").input(TestImgGeneration.byteArray(true, 10L, 10L), (Object)new ByteType()).outType((Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}).apply();
        ops.op("filter.dog").input(TestImgGeneration.byteArray(true, 10L, 10L), (Object)1.0, (Object)2.0, (Object)outOfBounds).output((Object)res).compute();
        Assertions.assertNotNull((Object)res);
    }
}

