/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.gauss;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class GaussTest
extends AbstractOpTest {
    @Test
    public void testGauss() {
        ArrayImg<ByteType, ByteArray> in = TestImgGeneration.byteArray(true, 10L, 10L);
        Img out1 = (Img)ops.op("create.img").input(in, (Object)((ByteType)Util.getTypeFromInterval(in))).outType((Nil)new Nil<Img<ByteType>>(){}).apply();
        double sigma = 5.0;
        Img out2 = (Img)ops.op("create.img").input(in, (Object)((ByteType)Util.getTypeFromInterval(in))).outType((Nil)new Nil<Img<ByteType>>(){}).apply();
        ops.op("filter.gauss").input(in, (Object)5.0).output((Object)out1).compute();
        try {
            Gauss3.gauss((double)5.0, (RandomAccessible)Views.extendMirrorSingle(in), (RandomAccessibleInterval)out2);
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
        Cursor c1 = out1.cursor();
        Cursor c2 = out2.cursor();
        while (c1.hasNext()) {
            Assertions.assertEquals((double)((ByteType)c1.next()).getRealDouble(), (double)((ByteType)c2.next()).getRealDouble(), (double)0.0);
        }
    }
}

