/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom3d;

import java.util.Random;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class QuickHull3DTest
extends AbstractOpTest {
    @Test
    public void testQuickhull_100_000() {
        Mesh df = this.randomPoints(100000, 20150818L);
        Mesh convexHull = (Mesh)ops.op("geom.convexHull").input((Object)df).outType(Mesh.class).apply();
        double epsilon = (Double)ops.op("geom.convexHullEpsilon").input((Object)df).outType(Double.TYPE).apply();
        Assertions.assertEquals((int)175, (int)convexHull.vertices().size());
        this.assertConvex(convexHull, epsilon);
    }

    @Test
    public void testQuickhull_4() {
        NaiveDoubleMesh df = new NaiveDoubleMesh();
        df.vertices().add(0.0, 0.0, 0.0);
        df.vertices().add(1.0, 0.0, 0.0);
        df.vertices().add(0.0, 0.0, 1.0);
        df.vertices().add(0.0, 1.0, 0.0);
        Mesh convexHull = (Mesh)ops.op("geom.convexHull").input((Object)df).outType(Mesh.class).apply();
        double epsilon = (Double)ops.op("geom.convexHullEpsilon").input((Object)df).outType(Double.TYPE).apply();
        Assertions.assertEquals((int)4, (int)convexHull.vertices().size());
        this.assertConvex(convexHull, epsilon);
    }

    @Test
    public void testQuickhull_6() {
        NaiveDoubleMesh df = new NaiveDoubleMesh();
        df.vertices().add(3.2, 4.8, 4.4);
        df.vertices().add(0.0, -4.9, 1.1);
        df.vertices().add(-2.4, 4.9, -3.1);
        df.vertices().add(4.5, -0.9, -2.5);
        df.vertices().add(-4.7, 0.4, -4.2);
        df.vertices().add(-1.9, 2.2, -3.3);
        Mesh convexHull = (Mesh)ops.op("geom.convexHull").input((Object)df).outType(Mesh.class).apply();
        double epsilon = (Double)ops.op("geom.convexHullEpsilon").input((Object)df).outType(Double.TYPE).apply();
        Assertions.assertEquals((int)5, (int)convexHull.vertices().size());
        this.assertConvex(convexHull, epsilon);
    }

    @Test
    public void testQuickhull_12() {
        NaiveDoubleMesh df = new NaiveDoubleMesh();
        Vertices v = df.vertices();
        v.add(-0.03621271768232132, 0.3728502838619522, 0.4947140370446388);
        v.add(0.3210853052521919, 0.4807189479290684, 0.4433501688235907);
        v.add(0.07214279572678994, -0.4960366976410492, 0.1112227161519441);
        v.add(0.2229772524190855, -0.4213242506806965, -0.1966818060695024);
        v.add(-0.3411871756810576, -0.3328629143842151, -0.4270033635450559);
        v.add(-0.245701439441835, 0.495905311308713, -0.3194406286994373);
        v.add(0.458374538420117, -0.09914027349943322, -0.2505798421339875);
        v.add(-0.4954086979808367, -0.3339869997780649, -0.3195065691317492);
        v.add(-0.3392973838740004, 0.4288679723896719, -0.01599531622230571);
        v.add(0.2724846394476338, -0.3506708492996831, 0.2750346518820475);
        v.add(0.3544683273457627, -0.450828987127942, -0.0827870439577727);
        v.add(0.1667164640191164, 0.003605551555385444, -0.4014989499947977);
        Mesh convexHull = (Mesh)ops.op("geom.convexHull").input((Object)df).outType(Mesh.class).apply();
        double epsilon = (Double)ops.op("geom.convexHullEpsilon").input((Object)df).outType(Double.TYPE).apply();
        Assertions.assertEquals((int)12, (int)convexHull.vertices().size());
        this.assertConvex(convexHull, epsilon);
    }

    @Test
    public void testQuickhull_40() {
        NaiveDoubleMesh df = new NaiveDoubleMesh();
        Vertices v = df.vertices();
        v.add(0.3215426810286406, 0.1678336189760208, -0.2203710966001927);
        v.add(0.2229772524190855, -0.4213242506806965, -0.1966818060695024);
        v.add(0.3688830163971363, -0.1831502133823468, -0.2056387967482571);
        v.add(-0.1712592515826777, -0.3542439228428937, 0.2223876390814666);
        v.add(-0.3309556113844324, -0.370961861099081, 0.2439994981922204);
        v.add(-0.1004397059794885, -0.09014152417903909, -0.008600084584765189);
        v.add(0.458374538420117, -0.09914027349943322, -0.2505798421339875);
        v.add(-0.4954086979808367, -0.3339869997780649, -0.3195065691317492);
        v.add(0.053091190339151, 0.3036317017894533, 0.1380056861210668);
        v.add(0.4615616439483703, 0.4665423151725366, 0.1766835406205464);
        v.add(-0.4797380864431505, 0.0419809916447671, -0.4254776681079321);
        v.add(-0.003168473023146823, -0.2525299883005488, -0.27151530400991);
        v.add(-0.3577162826971303, -0.1375644040643837, -0.04494194644032229);
        v.add(-0.3392973838740004, 0.4288679723896719, -0.01599531622230571);
        v.add(0.1667164640191164, 0.003605551555385444, -0.4014989499947977);
        v.add(0.00714666676441833, 0.1140243407469469, 0.407090128778564);
        v.add(-0.03621271768232132, 0.3728502838619522, 0.4947140370446388);
        v.add(-0.3411871756810576, -0.3328629143842151, -0.4270033635450559);
        v.add(0.3544683273457627, -0.450828987127942, -0.0827870439577727);
        v.add(-0.4018510635028137, 0.08917494033386464, -0.2367824197158054);
        v.add(0.3978697768392692, -0.002667689232777493, 0.1641431727112673);
        v.add(-0.245701439441835, 0.495905311308713, -0.3194406286994373);
        v.add(0.161352035739787, -0.1563404972258401, 0.3852604361113724);
        v.add(0.07214279572678994, -0.4960366976410492, 0.1112227161519441);
        v.add(0.3201855824516951, 0.359077846965825, 0.02136723140381946);
        v.add(0.1190541238701475, -0.05734495917087884, 0.2032677509852384);
        v.add(0.3210853052521919, 0.4807189479290684, 0.4433501688235907);
        v.add(0.3862800354941562, 0.2085496142586224, 0.09336129957191763);
        v.add(0.1233572616459404, 0.265491605052251, 0.117400122450106);
        v.add(0.1438531872293476, -0.2594872752758556, -0.2026374435076839);
        v.add(0.2724846394476338, -0.3506708492996831, 0.2750346518820475);
        v.add(-0.4926118841325975, -0.3279366743079728, 0.3683135596740186);
        v.add(0.2459906458351674, 0.3647787136629026, -0.1641662355178652);
        v.add(-0.141922976953837, -0.2994764654892278, -0.3009570467294725);
        v.add(-0.1850859398814719, 0.2606059478228967, 0.004159106876849283);
        v.add(-0.09789466634196664, -0.3156603563722785, -0.303610991503681);
        v.add(0.2100642609503719, -0.4499717643018549, 0.3245569875692548);
        v.add(-0.1707163766685095, -0.2301452446078371, -0.05112823569320907);
        v.add(-0.312260808713977, -0.1674135249735914, 0.2808831662692904);
        v.add(-0.1966306233747216, 0.2291105671125563, -0.3387042454804333);
        Mesh convexHull = (Mesh)ops.op("geom.convexHull").input((Object)df).outType(Mesh.class).apply();
        double epsilon = (Double)ops.op("geom.convexHullEpsilon").input((Object)df).outType(Double.TYPE).apply();
        Assertions.assertEquals((int)20, (int)convexHull.vertices().size());
        this.assertConvex(convexHull, epsilon);
    }

    private void assertConvex(Mesh convexHull, double epsilon) {
        long facetCount = convexHull.triangles().size();
        Assumptions.assumeTrue((facetCount <= Integer.MAX_VALUE ? 1 : 0) != 0);
        Vector3D[] centroids = new Vector3D[(int)facetCount];
        Vector3D[] normals = new Vector3D[(int)facetCount];
        int i = 0;
        for (Triangle tri : convexHull.triangles()) {
            centroids[i] = this.computeCentroid(tri);
            normals[i] = new Vector3D(tri.nx(), tri.ny(), tri.nz());
            ++i;
        }
        for (i = 0; i < centroids.length; ++i) {
            for (int j = 0; j < centroids.length; ++j) {
                if (i == j) continue;
                double distance = this.distanceToPlane(normals[i], centroids[i], centroids[j]);
                Assertions.assertTrue((distance < epsilon ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    private Vector3D computeCentroid(Triangle tri) {
        double x = (tri.v0x() + tri.v1x() + tri.v2x()) / 3.0;
        double y = (tri.v0y() + tri.v1y() + tri.v2y()) / 3.0;
        double z = (tri.v0z() + tri.v1z() + tri.v2z()) / 3.0;
        return new Vector3D(x, y, z);
    }

    private double distanceToPlane(Vector3D normal, Vector3D centroid, Vector3D p) {
        double planeOffset = normal.normalize().dotProduct((Vector)centroid);
        return normal.normalize().dotProduct((Vector)p) - planeOffset;
    }

    private Mesh randomPoints(int n, long seed) {
        Random r = new Random(seed);
        NaiveDoubleMesh mesh = new NaiveDoubleMesh();
        for (int i = 0; i < n; ++i) {
            mesh.vertices().add(r.nextDouble(), r.nextDouble(), r.nextDouble());
        }
        return mesh;
    }
}

