/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class DistanceTransform3DTest
extends AbstractOpTest {
    private static final double EPSILON = 1.0E-4;
    private static final long SEED = 305419896L;

    @Test
    public void test() {
        RandomAccessibleInterval in = (RandomAccessibleInterval)ops.op("create.img").input((Object)new FinalInterval(new long[]{20L, 20L, 5L}), (Object)new BitType()).outType((Nil)new Nil<RandomAccessibleInterval<BitType>>(){}).apply();
        this.generate3DImg((RandomAccessibleInterval<BitType>)in);
        RandomAccessibleInterval out = (RandomAccessibleInterval)ops.op("create.img").input((Object)in, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        ops.op("image.distanceTransform").input((Object)in).output((Object)out).compute();
        this.compareResults((RandomAccessibleInterval<FloatType>)out, (RandomAccessibleInterval<BitType>)in, new double[]{1.0, 1.0, 1.0});
        double[] calibration = new double[]{3.74, 5.19, 1.21};
        ops.op("image.distanceTransform").input((Object)in, (Object)calibration).output((Object)out).compute();
        this.compareResults((RandomAccessibleInterval<FloatType>)out, (RandomAccessibleInterval<BitType>)in, calibration);
    }

    private void generate3DImg(RandomAccessibleInterval<BitType> in) {
        RandomAccess raIn = in.randomAccess();
        MersenneTwisterFast random = new MersenneTwisterFast(305419896L);
        int x = 0;
        while ((long)x < in.dimension(0)) {
            int y = 0;
            while ((long)y < in.dimension(1)) {
                int z = 0;
                while ((long)z < in.dimension(2)) {
                    raIn.setPosition(new int[]{x, y, z++});
                    ((BitType)raIn.get()).set(random.nextBoolean());
                }
                ++y;
            }
            ++x;
        }
    }

    private void compareResults(RandomAccessibleInterval<FloatType> out, RandomAccessibleInterval<BitType> in, double[] calibration) {
        RandomAccess raOut = out.randomAccess();
        RandomAccess raIn = in.randomAccess();
        int x0 = 0;
        while ((long)x0 < in.dimension(0)) {
            int y0 = 0;
            while ((long)y0 < in.dimension(1)) {
                int z0 = 0;
                while ((long)z0 < in.dimension(2)) {
                    raIn.setPosition(new int[]{x0, y0, z0});
                    raOut.setPosition(new int[]{x0, y0, z0});
                    if (!((BitType)raIn.get()).get()) {
                        Assertions.assertEquals((double)0.0, (double)((FloatType)raOut.get()).get(), (double)1.0E-4);
                    } else {
                        double actualValue = in.dimension(0) * in.dimension(0) + in.dimension(1) * in.dimension(1) + in.dimension(2) * in.dimension(2);
                        int x = 0;
                        while ((long)x < in.dimension(0)) {
                            int y = 0;
                            while ((long)y < in.dimension(1)) {
                                int z = 0;
                                while ((long)z < in.dimension(2)) {
                                    raIn.setPosition(new int[]{x, y, z});
                                    double dist = calibration[0] * calibration[0] * (double)(x0 - x) * (double)(x0 - x) + calibration[1] * calibration[1] * (double)(y0 - y) * (double)(y0 - y) + calibration[2] * calibration[2] * (double)(z0 - z) * (double)(z0 - z);
                                    if (!((BitType)raIn.get()).get() && dist < actualValue) {
                                        actualValue = dist;
                                    }
                                    ++z;
                                }
                                ++y;
                            }
                            ++x;
                        }
                        Assertions.assertEquals((double)Math.sqrt(actualValue), (double)((FloatType)raOut.get()).get(), (double)1.0E-4);
                    }
                    ++z0;
                }
                ++y0;
            }
            ++x0;
        }
    }
}

