/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.histogram;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class DefaultHistogramTest
extends AbstractOpTest {
    byte[] data = new byte[]{96, 41, 2, 82, 43, 28, 76, 103, 96, 81, 121, 53, 115, 47, 119, 41, 4, 87, 102, 45, 63, 109, 70, 127, 94, 97, 119, 88, 5, 45, 106, 66, 9, 50, 102, 76, 49, 51, 57, 127, 21, 33, 0, 127, 88, 21, 61, 99, 41, 113, 117, 110, 88, 45, 64, 28, 18, 119, 91, 37, 86, 30, 45, 63};

    @Test
    public void testRegression() {
        ArrayImg img = ArrayImgs.unsignedBytes((byte[])this.data, (long[])new long[]{8L, 8L});
        Histogram1d histogram = (Histogram1d)ops.op("image.histogram").input((Object)img, (Object)10).outType((Nil)new Nil<Histogram1d<UnsignedByteType>>(){}).apply();
        Assertions.assertEquals((Object)false, (Object)histogram.hasTails());
        Assertions.assertEquals((double)0.078125, (double)histogram.relativeFrequency(5L, false), (double)1.0E-5);
        Assertions.assertEquals((long)10L, (long)histogram.getBinCount());
        UnsignedByteType type = new UnsignedByteType();
        histogram.getLowerBound(5L, (Object)type);
        Assertions.assertEquals((double)64.0, (double)type.getRealDouble(), (double)1.0E-5);
        histogram.getUpperBound(5L, (Object)type);
        Assertions.assertEquals((double)76.0, (double)type.getRealDouble(), (double)1.0E-5);
    }
}

