/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.watershed;

import java.util.HashSet;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class WatershedTest
extends AbstractOpTest {
    @Test
    public void test() {
        Img<FloatType> watershedTestImg = WatershedTest.openRelativeFloatImg(WatershedTest.class, "watershed_test_image.png");
        RandomAccessibleInterval thresholdedImg = (RandomAccessibleInterval)ops.op("create.img").input(watershedTestImg, (Object)new BitType()).outType((Nil)new Nil<RandomAccessibleInterval<BitType>>(){}).apply();
        ops.op("threshold.apply").input((Object)Views.flatIterable(watershedTestImg), (Object)new FloatType(1.0f)).output((Object)Views.flatIterable((RandomAccessibleInterval)thresholdedImg)).compute();
        RandomAccessibleInterval distMap = (RandomAccessibleInterval)ops.op("create.img").input((Object)thresholdedImg, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        ops.op("image.distanceTransform").input((Object)thresholdedImg).output((Object)distMap).compute();
        RandomAccessibleInterval invertedDistMap = (RandomAccessibleInterval)ops.op("create.img").input((Object)distMap, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        ops.op("image.invert").input((Object)distMap).output((Object)invertedDistMap).compute();
        RandomAccessibleInterval gauss = (RandomAccessibleInterval)ops.op("create.img").input((Object)invertedDistMap, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        ops.op("filter.gauss").input((Object)invertedDistMap, (Object)new double[]{3.0, 3.0}).output((Object)gauss).compute();
        this.testWithoutMask((RandomAccessibleInterval<FloatType>)gauss);
        this.testWithMask((RandomAccessibleInterval<FloatType>)gauss);
    }

    private void testWithoutMask(RandomAccessibleInterval<FloatType> in) {
        long[] dims = new long[in.numDimensions()];
        in.dimensions(dims);
        ArrayImg mask = ArrayImgs.bits((long[])dims);
        for (BitType b : mask) {
            b.setOne();
        }
        ImgLabeling out = (ImgLabeling)ops.op("image.watershed").input(in, (Object)true, (Object)false).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out, (RandomAccessibleInterval<BitType>)mask, true, false, false);
        ImgLabeling out2 = (ImgLabeling)ops.op("image.watershed").input(in, (Object)true, (Object)true).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out2, (RandomAccessibleInterval<BitType>)mask, true, true, false);
        ImgLabeling out3 = (ImgLabeling)ops.op("image.watershed").input(in, (Object)false, (Object)false).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out3, (RandomAccessibleInterval<BitType>)mask, false, false, false);
        ImgLabeling out4 = (ImgLabeling)ops.op("image.watershed").input(in, (Object)false, (Object)true).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out4, (RandomAccessibleInterval<BitType>)mask, false, true, false);
    }

    private void testWithMask(RandomAccessibleInterval<FloatType> in) {
        long[] dims = new long[in.numDimensions()];
        in.dimensions(dims);
        ArrayImg mask = ArrayImgs.bits((long[])dims);
        RandomAccess raMask = mask.randomAccess();
        for (BitType b : mask) {
            b.setZero();
        }
        int x = 0;
        while ((long)x < dims[0] / 2L) {
            int y = 0;
            while ((long)y < dims[1] / 2L) {
                raMask.setPosition(new int[]{x, y++});
                ((BitType)raMask.get()).setOne();
            }
            ++x;
        }
        ImgLabeling out = (ImgLabeling)ops.op("image.watershed").input(in, (Object)true, (Object)false, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out, (RandomAccessibleInterval<BitType>)mask, true, false, true);
        ImgLabeling out2 = (ImgLabeling)ops.op("image.watershed").input(in, (Object)true, (Object)true, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out2, (RandomAccessibleInterval<BitType>)mask, true, true, true);
        ImgLabeling out3 = (ImgLabeling)ops.op("image.watershed").input(in, (Object)false, (Object)false, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out3, (RandomAccessibleInterval<BitType>)mask, false, false, true);
        ImgLabeling out4 = (ImgLabeling)ops.op("image.watershed").input(in, (Object)false, (Object)true, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out4, (RandomAccessibleInterval<BitType>)mask, false, true, true);
    }

    private void assertResults(RandomAccessibleInterval<FloatType> in, ImgLabeling<Integer, IntType> out, RandomAccessibleInterval<BitType> mask, boolean useEighConnect, boolean withWatersheds, boolean smallMask) {
        Cursor curOut = out.cursor();
        RandomAccess raMask = mask.randomAccess();
        while (curOut.hasNext()) {
            curOut.fwd();
            raMask.setPosition((Localizable)curOut);
            if (((BitType)raMask.get()).get()) {
                Assertions.assertEquals((Object)true, (Object)(((LabelingType)curOut.get()).size() == 0 || ((LabelingType)curOut.get()).size() == 1 ? 1 : 0));
                continue;
            }
            Assertions.assertEquals((Object)true, (Object)((LabelingType)curOut.get()).isEmpty());
        }
        IterableRegion regions = Regions.iterable(mask);
        HashSet labelSet = new HashSet();
        for (LabelingType pixel : Regions.sample((IterableInterval)regions, out)) {
            labelSet.addAll(pixel);
        }
        Assertions.assertEquals((int)in.numDimensions(), (int)out.numDimensions());
        Assertions.assertEquals((long)in.dimension(0), (long)out.dimension(0));
        Assertions.assertEquals((long)in.dimension(1), (long)out.dimension(1));
        if (smallMask) {
            Assertions.assertEquals((int)(3 + (withWatersheds ? 1 : 0)), (int)labelSet.size());
        } else {
            Assertions.assertEquals((int)(10 + (withWatersheds ? 1 : 0)), (int)labelSet.size());
        }
    }
}

