/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.segment.detectJunctions;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.DefaultWritablePolyline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class DefaultDetectJunctionsTest
extends AbstractOpTest {
    @Test
    public void testDefaultJunctions() {
        ArrayList<DefaultWritablePolyline> lines = new ArrayList<DefaultWritablePolyline>();
        double threshold = Math.sqrt(2.0);
        ArrayList<RealPoint> list1 = new ArrayList<RealPoint>();
        RealPoint p = new RealPoint(new float[]{-5.0f, 0.0f});
        for (int i = 0; i < 10; ++i) {
            p.move(1, 0);
            list1.add(new RealPoint((RealLocalizable)p));
        }
        lines.add(new DefaultWritablePolyline(list1));
        ArrayList<RealPoint> list2 = new ArrayList<RealPoint>();
        p.setPosition(0, 0);
        p.setPosition(-5, 1);
        for (int i = 0; i < 10; ++i) {
            p.move(1, 1);
            list2.add(new RealPoint((RealLocalizable)p));
        }
        lines.add(new DefaultWritablePolyline(list2));
        ArrayList<RealPoint> list3 = new ArrayList<RealPoint>();
        p.setPosition(-15, 0);
        p.setPosition(-15, 1);
        for (int i = 0; i < 20; ++i) {
            p.move(1, 0);
            p.move(1, 1);
            list3.add(new RealPoint((RealLocalizable)p));
        }
        lines.add(new DefaultWritablePolyline(list3));
        ArrayList<RealPoint> list4 = new ArrayList<RealPoint>();
        p.setPosition(-11, 0);
        p.setPosition(-18, 1);
        for (int i = 0; i < 7; ++i) {
            p.move(1, 1);
            list4.add(new RealPoint((RealLocalizable)p));
        }
        lines.add(new DefaultWritablePolyline(list4));
        List results = (List)ops.op("segment.detectJunctions").input(lines, (Object)threshold).outType((Nil)new Nil<List<RealPoint>>(){}).apply();
        ArrayList<RealPoint> expected = new ArrayList<RealPoint>();
        expected.add(new RealPoint(new float[]{0.0f, 0.0f}));
        expected.add(new RealPoint(new float[]{-11.0f, -11.0f}));
        for (int i = 0; i < results.size(); ++i) {
            Assertions.assertEquals((double)((RealPoint)results.get(i)).getDoublePosition(0), (double)((RealPoint)expected.get(i)).getDoublePosition(0), (double)0.0);
            Assertions.assertEquals((double)((RealPoint)results.get(i)).getDoublePosition(1), (double)((RealPoint)expected.get(i)).getDoublePosition(1), (double)0.0);
        }
    }
}

