/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.segment.detectRidges;

import java.util.List;
import net.imglib2.RandomAccess;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.roi.geom.real.DefaultWritablePolyline;
import net.imglib2.roi.util.RealLocalizableRealPositionable;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class DefaultDetectRidgesTest
extends AbstractOpTest {
    double[] plineVertices = new double[]{15.0, 12.0, 15.0, 11.0, 15.0, 10.0, 15.0, 9.0, 15.0, 8.0, 15.0, 7.0, 15.0, 6.0, 15.0, 5.0, 15.0, 4.0, 15.0, 3.0, 15.0, 2.0, 15.0, 1.0, 1.0, 15.0, 2.0, 15.0, 3.0, 15.0, 4.0, 15.0, 5.0, 15.0, 6.0, 15.0, 7.0, 15.0, 8.0, 15.0, 9.0, 15.0, 10.0, 15.0, 11.0, 15.0, 12.0, 15.0, 22.99751187109411, 18.020211123079733, 23.91666828802532, 18.083331199962224, 24.916668629361407, 19.083331370638593, 25.916668800037776, 20.08333171197468, 25.979788876920267, 21.00248812890589, 25.999999914664198, 22.0, 25.979788876920267, 22.99751187109411, 25.916668800037776, 23.91666828802532, 24.916668629361407, 24.916668629361407, 23.91666828802532, 25.916668800037776, 22.99751187109411, 25.979788876920267, 22.0, 25.999999914664198, 21.00248812890589, 25.979788876920267, 20.08333171197468, 25.916668800037776, 19.083331370638593, 24.916668629361407, 18.083331199962224, 23.91666828802532, 18.020211123079733, 22.99751187109411, 18.000000085335802, 22.0, 18.020211123079733, 21.00248812890589, 18.083331199962224, 20.08333171197468, 19.083331370638593, 19.083331370638593, 20.08333171197468, 18.083331199962224, 21.00248812890589, 18.020211123079733, 22.0, 18.000000085335802, 9.999999999999869, 9.000000085339167, 9.0, 9.0, 8.0, 8.0, 7.0, 7.0, 6.0, 6.0, 5.0, 5.0, 4.0, 4.0, 3.0, 3.0, 2.0, 2.0, 1.0, 1.0, 0.0, 0.8333387946876465};

    @Test
    public void testTooFewDimensions() {
        ArrayImg<FloatType, FloatArray> input = TestImgGeneration.floatArray(false, 30L);
        int ridgeLengthMin = 4;
        double width = 1.0;
        double lowerThreshold = 2.0;
        double higherThreshold = 4.0;
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            List polylines = (List)ops.op("segment.detectRidges").input((Object)input, (Object)width, (Object)lowerThreshold, (Object)higherThreshold, (Object)ridgeLengthMin).outType((Nil)new Nil<List<DefaultWritablePolyline>>(){}).apply();
        });
    }

    @Test
    public void testTooManyDimensions() {
        ArrayImg<FloatType, FloatArray> input = TestImgGeneration.floatArray(false, 30L, 30L, 30L, 30L);
        int ridgeLengthMin = 4;
        double width = 1.0;
        double lowerThreshold = 2.0;
        double higherThreshold = 4.0;
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            List polylines = (List)ops.op("segment.detectRidges").input((Object)input, (Object)width, (Object)lowerThreshold, (Object)higherThreshold, (Object)ridgeLengthMin).outType((Nil)new Nil<List<DefaultWritablePolyline>>(){}).apply();
        });
    }

    @Test
    public void testRegression() {
        ArrayImg<FloatType, FloatArray> input = TestImgGeneration.floatArray(false, 30L, 30L);
        RandomAccess linePainter = input.randomAccess();
        for (int i = 0; i < 2; ++i) {
            linePainter.setPosition(15, i);
            for (int j = 2; j < 12; ++j) {
                linePainter.setPosition(j, 1 - i);
                ((FloatType)linePainter.get()).set(256.0f);
            }
        }
        for (int j = 0; j < 10; ++j) {
            linePainter.setPosition(j, 0);
            linePainter.setPosition(j, 1);
            ((FloatType)linePainter.get()).set(256.0f);
        }
        int radius = 4;
        int h = 22;
        int k = 22;
        for (double a = 0.0; a < Math.PI * 2; a += Math.PI / (double)(4 * radius)) {
            linePainter.setPosition(h + (int)Math.round((double)radius * Math.cos(a)), 0);
            linePainter.setPosition(k + (int)Math.round((double)radius * Math.sin(a)), 1);
            ((FloatType)linePainter.get()).set(256.0f);
        }
        int ridgeLengthMin = 4;
        double width = 1.0;
        double lowerThreshold = 2.0;
        double higherThreshold = 4.0;
        List polylines = (List)ops.op("segment.detectRidges").input(input, (Object)width, (Object)lowerThreshold, (Object)higherThreshold, (Object)ridgeLengthMin).outType((Nil)new Nil<List<DefaultWritablePolyline>>(){}).apply();
        int vertexCount = 0;
        for (DefaultWritablePolyline pline : polylines) {
            for (int i = 0; i < pline.numVertices(); ++i) {
                RealLocalizableRealPositionable p = pline.vertex(i);
                Assertions.assertEquals((double)p.getDoublePosition(0), (double)this.plineVertices[vertexCount++], (double)1.0E-5);
                Assertions.assertEquals((double)p.getDoublePosition(1), (double)this.plineVertices[vertexCount++], (double)1.0E-5);
            }
        }
    }
}

