/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.topology;

import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.topology.BoxCount;
import org.scijava.types.Nil;

public class BoxCountTest
extends AbstractOpTest {
    private static final Long MAX_SIZE = 16L;
    private static final Long MIN_SIZE = 2L;
    private static final double SCALING = 2.0;
    private static final long ITERATIONS = 4L;
    private static final long DIMENSIONS = 2L;
    private static final long[] TEST_DIMS = LongStream.generate(() -> MAX_SIZE).limit(2L).toArray();
    private static final double[] EXPECTED_SIZES = DoubleStream.iterate(MAX_SIZE.longValue(), d -> d / 2.0).map(d -> -Math.log(d)).limit(4L).toArray();

    @Test
    public void testAllBackground() throws Exception {
        double expectedCount = Math.log(0.0);
        ArrayImg img = ArrayImgs.bits((long[])TEST_DIMS);
        List points = (List)ops.op("topology.boxCount").input((Object)img, (Object)MAX_SIZE, (Object)MIN_SIZE, (Object)2.0, (Object)0L).outType((Nil)new Nil<List<ValuePair<DoubleType, DoubleType>>>(){}).apply();
        Assertions.assertNotNull((Object)points);
        Assertions.assertEquals((long)4L, (long)points.size());
        int i = 0;
        while ((long)i < 4L) {
            Assertions.assertEquals((double)EXPECTED_SIZES[i], (double)((DoubleType)((ValuePair)points.get((int)i)).a).get(), (double)1.0E-12);
            Assertions.assertEquals((double)expectedCount, (double)((DoubleType)((ValuePair)points.get((int)i)).b).get(), (double)1.0E-12);
            ++i;
        }
    }

    @Test
    public void testAllForeground() {
        double scalingPow = DoubleStream.generate(() -> 2.0).limit(2L).reduce((i, j) -> i * j).orElse(0.0);
        double[] expectedCounts = DoubleStream.iterate(1.0, i -> i * scalingPow).map(Math::log).limit(4L).toArray();
        ArrayImg img = ArrayImgs.bits((long[])TEST_DIMS);
        img.forEach(BitType::setOne);
        List points = (List)ops.op("topology.boxCount").input((Object)img, (Object)MAX_SIZE, (Object)MIN_SIZE, (Object)2.0, (Object)0L).outType((Nil)new Nil<List<ValuePair<DoubleType, DoubleType>>>(){}).apply();
        int i2 = 0;
        while ((long)i2 < 4L) {
            Assertions.assertEquals((double)EXPECTED_SIZES[i2], (double)((DoubleType)((ValuePair)points.get((int)i2)).a).get(), (double)1.0E-12);
            Assertions.assertEquals((double)expectedCounts[i2], (double)((DoubleType)((ValuePair)points.get((int)i2)).b).get(), (double)1.0E-12);
            ++i2;
        }
    }

    @Test
    public void testHyperCube() {
        double[] expectedSizes = DoubleStream.of(4.0, 2.0, 1.0).map(i -> -Math.log(i)).toArray();
        double[] expectedCounts = DoubleStream.of(1.0, 16.0, 16.0).map(Math::log).toArray();
        ArrayImg img = ArrayImgs.bits((long[])new long[]{4L, 4L, 4L, 4L});
        IntervalView hyperView = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{1L, 1L, 1L, 1L}, (long[])new long[]{2L, 2L, 2L, 2L});
        hyperView.forEach(BitType::setOne);
        List points = (List)ops.op("topology.boxCount").input((Object)img, (Object)4L, (Object)1L, (Object)2.0, (Object)0L).outType((Nil)new Nil<List<ValuePair<DoubleType, DoubleType>>>(){}).apply();
        for (int i2 = 0; i2 < expectedSizes.length; ++i2) {
            Assertions.assertEquals((double)expectedSizes[i2], (double)((DoubleType)((ValuePair)points.get((int)i2)).a).get(), (double)1.0E-12);
            Assertions.assertEquals((double)expectedCounts[i2], (double)((DoubleType)((ValuePair)points.get((int)i2)).b).get(), (double)1.0E-12);
        }
    }

    @Test
    public void testHyperCubeTranslations() {
        double[] expectedSizes = DoubleStream.of(4.0, 2.0, 1.0).map(i -> -Math.log(i)).toArray();
        double[] expectedCounts = DoubleStream.of(1.0, 1.0, 16.0).map(Math::log).toArray();
        ArrayImg img = ArrayImgs.bits((long[])new long[]{4L, 4L, 4L, 4L});
        IntervalView hyperView = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{1L, 1L, 1L, 1L}, (long[])new long[]{2L, 2L, 2L, 2L});
        hyperView.forEach(BitType::setOne);
        List points = (List)ops.op("topology.boxCount").input((Object)img, (Object)4L, (Object)1L, (Object)2.0, (Object)1L).outType((Nil)new Nil<List<ValuePair<DoubleType, DoubleType>>>(){}).apply();
        for (int i2 = 0; i2 < expectedSizes.length; ++i2) {
            Assertions.assertEquals((double)expectedSizes[i2], (double)((DoubleType)((ValuePair)points.get((int)i2)).a).get(), (double)1.0E-12);
            Assertions.assertEquals((double)expectedCounts[i2], (double)((DoubleType)((ValuePair)points.get((int)i2)).b).get(), (double)1.0E-12);
        }
    }

    @Test
    public void testOneVoxel() {
        PrimitiveIterator.OfDouble sizes = DoubleStream.of(9.0, 3.0, 1.0).map(i -> -Math.log(i)).iterator();
        PrimitiveIterator.OfDouble counts = DoubleStream.of(1.0, 1.0, 1.0).map(Math::log).iterator();
        ArrayImg img = ArrayImgs.bits((long[])new long[]{9L, 9L, 9L});
        RandomAccess access = img.randomAccess();
        access.setPosition(new long[]{4L, 4L, 4L});
        ((BitType)access.get()).setOne();
        List points = (List)ops.op("topology.boxCount").input((Object)img, (Object)9L, (Object)3L, (Object)3.0, (Object)0L).outType((Nil)new Nil<List<ValuePair<DoubleType, DoubleType>>>(){}).apply();
        points.forEach(p -> {
            Assertions.assertEquals((double)((DoubleType)p.a).get(), (double)sizes.next(), (double)1.0E-12);
            Assertions.assertEquals((double)((DoubleType)p.b).get(), (double)counts.next(), (double)1.0E-12);
        });
    }

    @Test
    public void testThrowsIAEIfScalingEqualsOne() {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{9L, 9L, 9L});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.lambda$testThrowsIAEIfScalingEqualsOne$10((Img)img));
    }

    @Test
    public void testLimitTranslationsThrowsIAEIfSizeNonPositive() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BoxCount.limitTranslations((long)0L, (long)5L));
    }

    @Test
    public void testLimitTranslationsNonPositiveTranslations() {
        Assertions.assertEquals((long)1L, (long)BoxCount.limitTranslations((long)10L, (long)0L));
        Assertions.assertEquals((long)1L, (long)BoxCount.limitTranslations((long)100L, (long)-1L));
    }

    @Test
    public void testLimitTranslations() {
        Assertions.assertEquals((long)9L, (long)BoxCount.limitTranslations((long)10L, (long)9L));
        Assertions.assertEquals((long)10L, (long)BoxCount.limitTranslations((long)10L, (long)11L));
    }

    private /* synthetic */ void lambda$testThrowsIAEIfScalingEqualsOne$10(Img img) throws Throwable {
        ops.op("topology.boxCount").input((Object)img, (Object)8L, (Object)2L, (Object)1.0, (Object)0L).outType((Nil)new Nil<List<ValuePair<DoubleType, DoubleType>>>(){}).apply();
    }
}

