/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.topology.eulerCharacteristic;

import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.topology.eulerCharacteristic.TestHelper;

public class EulerCharacteristic26NFloatingTest
extends AbstractOpTest {
    @Test
    public void testConforms() throws AssertionError {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{3L, 3L});
        DoubleType result = new DoubleType();
        Assertions.assertThrows(IllegalArgumentException.class, () -> EulerCharacteristic26NFloatingTest.lambda$testConforms$0((Img)img, result));
    }

    @Test
    public void testCube() throws Exception {
        Img<BitType> img = TestHelper.drawCube(1L, 1L, 1L, 1L);
        DoubleType result = new DoubleType();
        ops.op("topology.eulerCharacteristic26NFloating").input(img).output((Object)result).compute();
        Assertions.assertEquals((double)1.0, (double)result.get(), (double)1.0E-12, (String)"Euler characteristic (\u03c7) is incorrect");
    }

    @Test
    public void testEdgeCube() throws Exception {
        Img<BitType> img = TestHelper.drawCube(1L, 1L, 1L, 0L);
        DoubleType result = new DoubleType();
        ops.op("topology.eulerCharacteristic26NFloating").input(img).output((Object)result).compute();
        Assertions.assertEquals((double)1.0, (double)result.get(), (double)1.0E-12, (String)"Euler characteristic (\u03c7) is incorrect");
    }

    @Test
    public void testHollowCube() throws Exception {
        Img<BitType> img = TestHelper.drawCube(3L, 3L, 3L, 1L);
        RandomAccess access = img.randomAccess();
        access.setPosition(new long[]{2L, 2L, 2L});
        ((BitType)access.get()).setZero();
        DoubleType result = new DoubleType();
        ops.op("topology.eulerCharacteristic26NFloating").input(img).output((Object)result).compute();
        Assertions.assertEquals((double)2.0, (double)result.get(), (double)1.0E-12, (String)"Euler characteristic (\u03c7) is incorrect");
    }

    @Test
    public void testHandleCube() throws Exception {
        Img<BitType> cube = TestHelper.drawCube(9L, 9L, 9L, 5L);
        RandomAccess access = cube.randomAccess();
        access.setPosition(9, 0);
        access.setPosition(6, 1);
        access.setPosition(4, 2);
        ((BitType)access.get()).setOne();
        access.setPosition(3, 2);
        ((BitType)access.get()).setOne();
        access.setPosition(7, 1);
        ((BitType)access.get()).setOne();
        access.setPosition(8, 1);
        ((BitType)access.get()).setOne();
        access.setPosition(4, 2);
        ((BitType)access.get()).setOne();
        DoubleType result = new DoubleType();
        ops.op("topology.eulerCharacteristic26NFloating").input(cube).output((Object)result).compute();
        Assertions.assertEquals((double)0.0, (double)result.get(), (double)1.0E-12, (String)"Euler characteristic (\u03c7) is incorrect");
    }

    private static /* synthetic */ void lambda$testConforms$0(Img img, DoubleType result) throws Throwable {
        ops.op("topology.eulerCharacteristic26NFloating").input((Object)img).output((Object)result).compute();
    }
}

