/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.topology.eulerCharacteristic;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.logic.BitType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.topology.eulerCharacteristic.Octant;

public class OctantTest {
    @Test
    public void testIsNeighborhoodEmpty() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{2L, 2L, 2L});
        Octant octant = new Octant((RandomAccessibleInterval)img);
        octant.setNeighborhood(1L, 1L, 1L);
        Assertions.assertTrue((boolean)octant.isNeighborhoodEmpty(), (String)"Neighborhood should be empty");
        img.forEach(BitType::setOne);
        octant.setNeighborhood(1L, 1L, 1L);
        Assertions.assertFalse((boolean)octant.isNeighborhoodEmpty(), (String)"Neighborhood should not be empty");
    }

    @Test
    public void testSetNeighborhood() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{3L, 3L, 3L});
        Octant octant = new Octant((RandomAccessibleInterval)img);
        RandomAccess access = img.randomAccess();
        for (int z = 0; z < 2; ++z) {
            access.setPosition(z, 2);
            for (int y = 0; y < 2; ++y) {
                access.setPosition(y, 1);
                for (int x = 0; x < 2; ++x) {
                    access.setPosition(x, 0);
                    ((BitType)access.get()).setOne();
                }
            }
        }
        octant.setNeighborhood(1L, 1L, 1L);
        Assertions.assertEquals((int)8, (int)octant.getNeighborCount(), (String)"All neighbours should be foreground");
        octant.setNeighborhood(2L, 2L, 2L);
        Assertions.assertEquals((int)1, (int)octant.getNeighborCount(), (String)"Wrong number of foreground neighbors");
    }
}

