/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.intervalView;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class IntervalViewTest
extends AbstractOpTest {
    private static final long SEED = 305419896L;

    @Test
    public void testDefaultInterval() {
        BiFunction intervalFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.intervalView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<Interval>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        Cursor il2 = Views.interval((RandomAccessible)img, (Interval)img).localizingCursor();
        RandomAccess opr = ((IntervalView)intervalFunc.apply(img, img)).randomAccess();
        while (il2.hasNext()) {
            DoubleType e = (DoubleType)il2.next();
            opr.setPosition((Localizable)il2);
            Assertions.assertEquals((double)e.get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testIntervalMinMax() {
        Functions.Arity3 intervalFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.intervalView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        Cursor il2 = Views.interval((RandomAccessible)img, (long[])new long[]{1L, 1L}, (long[])new long[]{8L, 9L}).localizingCursor();
        RandomAccess opr = ((IntervalView)intervalFunc.apply((Object)img, (Object)new long[]{1L, 1L}, (Object)new long[]{8L, 9L})).randomAccess();
        while (il2.hasNext()) {
            DoubleType e = (DoubleType)il2.next();
            opr.setPosition((Localizable)il2);
            Assertions.assertEquals((double)e.get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        }
    }
}

