/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.translateView;

import java.util.function.BiFunction;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class TranslateViewTest
extends AbstractOpTest {
    public static <T> RandomAccessible<T> deinterval(RandomAccessibleInterval<T> input) {
        return Views.extendBorder(input);
    }

    @Test
    public void testDefaultTranslate() {
        BiFunction translateFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.translateView", (Nil)new Nil<Img<DoubleType>>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<MixedTransformView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MixedTransformView il2 = Views.translate(TranslateViewTest.deinterval(img), (long[])new long[]{2L, 5L});
        MixedTransformView opr = (MixedTransformView)translateFunc.apply(img, new long[]{2L, 5L});
        for (int i = 0; i < il2.getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < il2.getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)il2.getTransformToSource().getMatrix()[i][j], (double)opr.getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testIntervalTranslate() {
        BiFunction translateFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.translateView", (Nil)new Nil<Img<DoubleType>>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{10L, 10L});
        IntervalView expected = Views.translate((RandomAccessibleInterval)img, (long[])new long[]{2L, 5L});
        IntervalView actual = (IntervalView)translateFunc.apply(img, new long[]{2L, 5L});
        for (int i = 0; i < ((MixedTransformView)expected.getSource()).getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < ((MixedTransformView)expected.getSource()).getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)((MixedTransformView)expected.getSource()).getTransformToSource().getMatrix()[i][j], (double)((MixedTransformView)actual.getSource()).getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
        Assertions.assertTrue((boolean)Intervals.equals((Interval)expected, (Interval)actual));
    }
}

