/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.types;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsRandomValueFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class TypeExtractorTests
extends AbstractOpTest {
    @Test
    public void testOutOfBoundsConstantValueFactoryTypeExtractors() {
        OutOfBoundsConstantValueFactory oobf = new OutOfBoundsConstantValueFactory((Object)new UnsignedByteType(5));
        Type objType = ops.genericType((Object)oobf);
        Assertions.assertInstanceOf(ParameterizedType.class, (Object)objType);
        ParameterizedType pType = (ParameterizedType)objType;
        Assertions.assertEquals(OutOfBoundsConstantValueFactory.class, (Object)pType.getRawType());
        Assertions.assertEquals(UnsignedByteType.class, (Object)pType.getActualTypeArguments()[0]);
        ParameterizedType secondArgType = (ParameterizedType)pType.getActualTypeArguments()[1];
        Assertions.assertEquals(RandomAccessibleInterval.class, (Object)secondArgType.getRawType());
        Assertions.assertEquals(UnsignedByteType.class, (Object)secondArgType.getActualTypeArguments()[0]);
    }

    @Test
    public void testOutOfBoundsRandomValueFactoryTypeExtractors() {
        OutOfBoundsRandomValueFactory oobf = new OutOfBoundsRandomValueFactory((RealType)new UnsignedByteType(7), 7.0, 7.0);
        Type objType = ops.genericType((Object)oobf);
        Assertions.assertInstanceOf(ParameterizedType.class, (Object)objType);
        ParameterizedType pType = (ParameterizedType)objType;
        Assertions.assertEquals(OutOfBoundsRandomValueFactory.class, (Object)pType.getRawType());
        Assertions.assertEquals(UnsignedByteType.class, (Object)pType.getActualTypeArguments()[0]);
        ParameterizedType secondArgType = (ParameterizedType)pType.getActualTypeArguments()[1];
        Assertions.assertEquals(RandomAccessibleInterval.class, (Object)secondArgType.getRawType());
        Assertions.assertEquals(UnsignedByteType.class, (Object)secondArgType.getActualTypeArguments()[0]);
    }

    @Test
    public void testRAITypeExtractor() {
        ArrayImg data = ArrayImgs.doubles((long[])new long[]{20L, 20L});
        Type objType = ops.genericType((Object)data);
        Assertions.assertInstanceOf(ParameterizedType.class, (Object)objType);
        ParameterizedType pType = (ParameterizedType)objType;
        Assertions.assertEquals(ArrayImg.class, (Object)pType.getRawType());
        Assertions.assertArrayEquals((Object[])new Type[]{DoubleType.class, DoubleArray.class}, (Object[])pType.getActualTypeArguments());
    }

    @Test
    public void testHistogram1dTypeExtractor() {
        ArrayImg data = ArrayImgs.doubles((long[])new long[]{20L, 20L});
        Histogram1d doubles = (Histogram1d)ops.op("image.histogram").input((Object)data).outType((Nil)new Nil<Histogram1d<DoubleType>>(){}).apply();
        Type objType = ops.genericType((Object)doubles);
        Assertions.assertInstanceOf(ParameterizedType.class, (Object)objType);
        ParameterizedType pType = (ParameterizedType)objType;
        Assertions.assertEquals(Histogram1d.class, (Object)pType.getRawType());
        Assertions.assertArrayEquals((Object[])new Type[]{DoubleType.class}, (Object[])pType.getActualTypeArguments());
    }
}

