/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.types.adapt;

import net.imglib2.Cursor;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;

public class LiftNeighborhoodComputersToRAITest
extends AbstractOpTest {
    public final Computers.Arity1<Neighborhood<UnsignedByteType>, UnsignedByteType> testOp = (in, out) -> {
        Cursor cursor = in.cursor();
        long sum = 0L;
        while (cursor.hasNext()) {
            sum += (long)((UnsignedByteType)cursor.next()).get();
        }
        out.setInteger(sum);
    };

    @Test
    public void testLiftArity1() {
        RectangleShape shape = new RectangleShape(1, false);
        ArrayImg<UnsignedByteType, ByteArray> inImg = TestImgGeneration.unsignedByteArray(true, 10L, 10L);
        ArrayImg actual = ArrayImgs.unsignedBytes((long[])new long[]{10L, 10L});
        ops.op("test.liftImg").input(inImg, (Object)shape).output((Object)actual).compute();
        ExtendedRandomAccessibleInterval extended = Views.extend(inImg, (OutOfBoundsFactory)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
        RectangleShape.NeighborhoodsAccessible neighborhoods = shape.neighborhoodsRandomAccessibleSafe((RandomAccessible)extended);
        IntervalView intervaled = Views.interval((RandomAccessible)neighborhoods, inImg);
        ArrayImg expected = ArrayImgs.unsignedBytes((long[])new long[]{10L, 10L});
        ArrayCursor cursor = inImg.cursor();
        RandomAccess neighborhoodRA = intervaled.randomAccess();
        ArrayRandomAccess actualRA = actual.randomAccess();
        ArrayRandomAccess expectedRA = expected.randomAccess();
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize((Positionable)neighborhoodRA);
            cursor.localize((Positionable)actualRA);
            cursor.localize((Positionable)expectedRA);
            this.testOp.compute((Object)((Neighborhood)neighborhoodRA.get()), (Object)((UnsignedByteType)expectedRA.get()));
            Assertions.assertEquals((int)((UnsignedByteType)actualRA.get()).get(), (int)((UnsignedByteType)expectedRA.get()).get());
        }
    }

    @Test
    public void testLiftArity1WithOOBF() {
        RectangleShape shape = new RectangleShape(1, false);
        OutOfBoundsConstantValueFactory oobf = new OutOfBoundsConstantValueFactory((Object)new UnsignedByteType(0));
        ArrayImg<UnsignedByteType, ByteArray> inImg = TestImgGeneration.unsignedByteArray(true, 10L, 10L);
        ArrayImg actual = ArrayImgs.unsignedBytes((long[])new long[]{10L, 10L});
        ops.op("test.liftImg").input(inImg, (Object)shape, (Object)oobf).output((Object)actual).compute();
        ExtendedRandomAccessibleInterval extended = Views.extend(inImg, (OutOfBoundsFactory)oobf);
        RectangleShape.NeighborhoodsAccessible neighborhoods = shape.neighborhoodsRandomAccessibleSafe((RandomAccessible)extended);
        IntervalView intervaled = Views.interval((RandomAccessible)neighborhoods, inImg);
        ArrayImg expected = ArrayImgs.unsignedBytes((long[])new long[]{10L, 10L});
        ArrayCursor cursor = inImg.cursor();
        RandomAccess neighborhoodRA = intervaled.randomAccess();
        ArrayRandomAccess actualRA = actual.randomAccess();
        ArrayRandomAccess expectedRA = expected.randomAccess();
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize((Positionable)neighborhoodRA);
            cursor.localize((Positionable)actualRA);
            cursor.localize((Positionable)expectedRA);
            this.testOp.compute((Object)((Neighborhood)neighborhoodRA.get()), (Object)((UnsignedByteType)expectedRA.get()));
            Assertions.assertEquals((int)((UnsignedByteType)actualRA.get()).get(), (int)((UnsignedByteType)expectedRA.get()).get());
        }
    }
}

