/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.util;

import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.util.TestImgGeneration;

public class TestImgGenerationTest {
    @Test
    public void testVerifyImages() {
        this.ensureNotEmpty(TestImgGeneration.byteArray(true, 10L, 10L), (NativeType)new ByteType());
        this.ensureNotEmpty(TestImgGeneration.unsignedByteArray(true, 10L, 10L), (NativeType)new UnsignedByteType());
        this.ensureNotEmpty(TestImgGeneration.intArray(true, 10L, 10L), (NativeType)new IntType());
        this.ensureNotEmpty(TestImgGeneration.unsignedIntArray(true, 10L, 10L), (NativeType)new UnsignedIntType());
        this.ensureNotEmpty(TestImgGeneration.floatArray(true, 10L, 10L), (NativeType)new FloatType());
        this.ensureNotEmpty(TestImgGeneration.doubleArray(true, 10L, 10L), (NativeType)new DoubleType());
        this.ensureNotEmpty(TestImgGeneration.bitArray(true, 10L, 10L), (NativeType)new BitType());
        this.ensureNotEmpty(TestImgGeneration.longArray(true, 10L, 10L), (NativeType)new LongType());
        this.ensureNotEmpty(TestImgGeneration.unsignedLongArray(true, 10L, 10L), (NativeType)new UnsignedLongType());
        this.ensureNotEmpty(TestImgGeneration.shortArray(true, 10L, 10L), (NativeType)new ShortType());
        this.ensureNotEmpty(TestImgGeneration.unsignedShortArray(true, 10L, 10L), (NativeType)new UnsignedShortType());
        this.ensureNotEmpty(TestImgGeneration.unsigned2BitArray(true, 10L, 10L), (NativeType)new Unsigned2BitType());
        this.ensureNotEmpty(TestImgGeneration.unsigned4BitArray(true, 10L, 10L), (NativeType)new Unsigned4BitType());
        this.ensureNotEmpty(TestImgGeneration.unsigned12BitArray(true, 10L, 10L), (NativeType)new Unsigned12BitType());
        this.ensureNotEmpty(TestImgGeneration.unsigned128BitArray(true, 10L, 10L), (NativeType)new Unsigned128BitType());
    }

    private void ensureNotEmpty(ArrayImg img, NativeType nt) {
        ArrayCursor cursor = img.cursor();
        boolean foundNonZero = false;
        while (cursor.hasNext()) {
            foundNonZero = !cursor.next().equals(nt) || foundNonZero;
        }
        Assertions.assertTrue((boolean)foundNonZero, (String)("Randomly generated " + nt.getClass() + " array contains all 0's"));
    }
}

