/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.tamura2d;

import java.util.function.Function;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultContrastFeature<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<IterableInterval<I>, O> {
    @OpDependency(name="stats.moment4AboutMean")
    private Function<Iterable<I>, O> m4Op;
    @OpDependency(name="stats.variance")
    private Function<Iterable<I>, O> varOp;
    @OpDependency(name="stats.stdDev")
    private Function<Iterable<I>, O> stdOp;

    public void compute(IterableInterval<I> input, O output) {
        if (input.numDimensions() != 2) {
            throw new IllegalArgumentException("Only 2 dimensional images allowed!");
        }
        double m4 = ((RealType)this.m4Op.apply((Iterable<I>)input)).getRealDouble();
        double var = ((RealType)this.varOp.apply((Iterable<I>)input)).getRealDouble();
        double std = ((RealType)this.stdOp.apply((Iterable<I>)input)).getRealDouble();
        double l4 = m4 / (var * var);
        double fCon = std / Math.pow(l4, 0.25);
        output.setReal(fCon);
    }
}

