/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom3d;

import java.util.function.Function;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.commons.math3.util.MathArrays;

public class DefaultVolumeMesh
implements Function<Mesh, DoubleType> {
    @Override
    public DoubleType apply(Mesh input) {
        double volume = 0.0;
        for (Triangle triangle : input.triangles()) {
            volume += this.signedVolumeOfTriangle(triangle.v0x(), triangle.v0y(), triangle.v0z(), triangle.v1x(), triangle.v1y(), triangle.v1z(), triangle.v2x(), triangle.v2y(), triangle.v2z());
        }
        return new DoubleType(Math.abs(volume));
    }

    private double signedVolumeOfTriangle(double p0x, double p0y, double p0z, double p1x, double p1y, double p1z, double p2x, double p2y, double p2z) {
        double cpx = MathArrays.linearCombination((double)p1y, (double)p2z, (double)(-p1z), (double)p2y);
        double cpy = MathArrays.linearCombination((double)p1z, (double)p2x, (double)(-p1x), (double)p2z);
        double cpz = MathArrays.linearCombination((double)p1x, (double)p2y, (double)(-p1y), (double)p2x);
        return MathArrays.linearCombination((double)p0x, (double)cpx, (double)p0y, (double)cpy, (double)p0z, (double)cpz) / 6.0;
    }
}

