/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.cooccurrenceMatrix;

import java.util.Arrays;
import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;

public class CooccurrenceMatrix2D {
    public static final <T extends RealType<T>> double[][] apply(RandomAccessibleInterval<T> input, Integer nrGreyLevels, Integer distance, Function<RandomAccessibleInterval<T>, Pair<T, T>> minmax, MatrixOrientation orientation) {
        double[][] output = new double[nrGreyLevels.intValue()][nrGreyLevels.intValue()];
        Pair<T, T> minMax = minmax.apply(input);
        double localMin = ((RealType)minMax.getA()).getRealDouble();
        double localMax = ((RealType)minMax.getB()).getRealDouble();
        int[][] pixels = new int[(int)input.dimension(1)][(int)input.dimension(0)];
        for (int i = 0; i < pixels.length; ++i) {
            Arrays.fill(pixels[i], Integer.MAX_VALUE);
        }
        int minimumX = (int)input.min(0);
        int minimumY = (int)input.min(1);
        double diff = localMax - localMin;
        LoopBuilder.setImages(input, (RandomAccessibleInterval)Intervals.positions(input)).multiThreaded().forEachPixel((pixel, pos) -> {
            int bin = (int)((pixel.getRealDouble() - localMin) / diff * (double)nrGreyLevels.intValue());
            pixels[pos.getIntPosition((int)1) - minimumY][pos.getIntPosition((int)0) - minimumX] = bin < nrGreyLevels - 1 ? bin : nrGreyLevels - 1;
        });
        int nrPairs = 0;
        int orientationAtX = orientation.getValueAtDim(0) * distance;
        int orientationAtY = orientation.getValueAtDim(1) * distance;
        for (int y = 0; y < pixels.length; ++y) {
            for (int x = 0; x < pixels[y].length; ++x) {
                if (pixels[y][x] == Integer.MAX_VALUE) continue;
                int sx = x + orientationAtX;
                int sy = y + orientationAtY;
                if (sx < 0 || sy < 0 || sy >= pixels.length || sx >= pixels[sy].length || pixels[sy][sx] == Integer.MAX_VALUE) continue;
                double[] dArray = output[pixels[y][x]];
                int n = pixels[sy][sx];
                dArray[n] = dArray[n] + 1.0;
                ++nrPairs;
            }
        }
        if (nrPairs > 0) {
            double divisor = 1.0 / (double)nrPairs;
            for (int row = 0; row < output.length; ++row) {
                int col = 0;
                while (col < output[row].length) {
                    double[] dArray = output[row];
                    int n = col++;
                    dArray[n] = dArray[n] * divisor;
                }
            }
        }
        return output;
    }
}

