/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import java.util.ArrayList;
import java.util.Arrays;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;
import org.scijava.concurrent.Parallelization;
import org.scijava.ops.image.image.distancetransform.InitPhaseCal;
import org.scijava.ops.image.image.distancetransform.NextPhaseCal;

public final class DefaultDistanceTransformCalibration {
    private DefaultDistanceTransformCalibration() {
    }

    public static <B extends BooleanType<B>, T extends RealType<T>> void compute(RandomAccessibleInterval<B> in, double[] calibration, RandomAccessibleInterval<T> out) {
        int[] dimensSizes = new int[in.numDimensions()];
        int[] positions = new int[in.numDimensions()];
        int numPoints = 1;
        for (int i = 0; i < in.numDimensions(); ++i) {
            numPoints = (int)((long)numPoints * in.dimension(i));
            dimensSizes[i] = (int)in.dimension(i);
            positions[i] = 0;
        }
        double[] actualValues = new double[numPoints];
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        int index = dimensSizes.length - 1;
        list.add(new InitPhaseCal(actualValues, in, dimensSizes, (int[])positions.clone(), calibration));
        while (index > 0) {
            if (positions[index] < dimensSizes[index] - 1) {
                int n = index;
                positions[n] = positions[n] + 1;
                index = positions.length - 1;
                list.add(new InitPhaseCal(actualValues, in, dimensSizes, (int[])positions.clone(), calibration));
                continue;
            }
            positions[index] = 0;
            --index;
        }
        Parallelization.getTaskExecutor().runAll(list);
        list.clear();
        for (int i = 0; i < actualValues.length; ++i) {
            int n = i;
            actualValues[n] = actualValues[n] * actualValues[i];
        }
        for (int actualDimension = 1; actualDimension < in.numDimensions(); ++actualDimension) {
            Arrays.fill(positions, 0);
            positions[actualDimension] = -1;
            index = positions.length - 1;
            list.add(new NextPhaseCal(actualValues, dimensSizes, (int[])positions.clone(), actualDimension, calibration));
            while (index >= 0) {
                if (positions[index] == -1) {
                    --index;
                    continue;
                }
                if (positions[index] < dimensSizes[index] - 1) {
                    int n = index;
                    positions[n] = positions[n] + 1;
                    index = positions.length - 1;
                    list.add(new NextPhaseCal(actualValues, dimensSizes, (int[])positions.clone(), actualDimension, calibration));
                    continue;
                }
                positions[index] = 0;
                --index;
            }
            Parallelization.getTaskExecutor().runAll(list);
            list.clear();
        }
        Arrays.fill(positions, 0);
        RandomAccess raOut = out.randomAccess();
        raOut.setPosition(positions);
        ((RealType)raOut.get()).setReal(Math.sqrt(actualValues[IntervalIndexer.positionToIndex((int[])positions, (int[])dimensSizes)]));
        index = dimensSizes.length - 1;
        while (index >= 0) {
            if (positions[index] < dimensSizes[index] - 1) {
                int n = index;
                positions[n] = positions[n] + 1;
                index = positions.length - 1;
                raOut.setPosition(positions);
                ((RealType)raOut.get()).setReal(Math.sqrt(actualValues[IntervalIndexer.positionToIndex((int[])positions, (int[])dimensSizes)]));
                continue;
            }
            positions[index] = 0;
            --index;
        }
    }
}

