/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.math;

import java.util.Objects;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import org.scijava.common3.Types;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;

public class BinaryRealTypeMath<I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> {
    public final Computers.Arity2<I1, I2, O> adder = (input1, input2, output) -> output.setReal(input1.getRealDouble() + input2.getRealDouble());
    public final Computers.Arity2<I1, I2, O> ander = (input1, input2, output) -> output.setReal((float)((long)input1.getRealDouble() & (long)input2.getRealDouble()));
    public final Computers.Arity2<I1, I2, O> multiplier = (input1, input2, output) -> output.setReal(input1.getRealDouble() * input2.getRealDouble());
    public final Computers.Arity2<I1, I2, O> orer = (input1, input2, output) -> output.setReal((float)((long)input1.getRealDouble() | (long)input2.getRealDouble()));
    public final Computers.Arity2<I1, I2, O> subtracter = (input1, input2, output) -> output.setReal(input1.getRealDouble() - input2.getRealDouble());
    public final Computers.Arity2<I1, I2, O> xorer = (input1, input2, output) -> output.setReal((float)((long)input1.getRealDouble() ^ (long)input2.getRealDouble()));
    public final Computers.Arity2<I1, I2, O> power = (input1, input2, output) -> output.setReal(Math.pow(input1.getRealDouble(), input2.getRealDouble()));
    public final Computers.Arity2<I1, I2, O> moder = (input1, input2, output) -> output.setReal(input1.getRealDouble() % input2.getRealDouble());

    public static <T1 extends RealType<T1>, T2 extends RealType<T2>, O extends RealType<O>> void divider(T1 input1, T2 input2, @Nullable Double dbzVal, O output) {
        if (Objects.nonNull(dbzVal) && input2.getRealDouble() == 0.0) {
            output.setReal(dbzVal.doubleValue());
        } else {
            double result = input1.getRealDouble() / input2.getRealDouble();
            if (Types.isAssignable(output.getClass(), IntegerType.class)) {
                output.setReal((float)((int)result));
            } else {
                output.setReal(result);
            }
        }
    }
}

