/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.math;

import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;

public final class UnaryRealTypeMath<I extends RealType<I>, O extends RealType<O>> {
    public final Computers.Arity1<I, O> absoluteValue = (input, output) -> output.setReal(Math.abs(input.getRealDouble()));
    public final Computers.Arity1<I, O> arccos = (input, output) -> output.setReal(Math.acos(input.getRealDouble()));
    public final Computers.Arity1<I, O> arccosh = (input, output) -> {
        double xt = input.getRealDouble();
        double delta = Math.sqrt(xt * xt - 1.0);
        if (xt <= -1.0) {
            delta = -delta;
        }
        output.setReal(Math.log(xt + delta));
    };
    public final Computers.Arity1<I, O> arccot = (input, output) -> {
        double value = Math.atan(1.0 / input.getRealDouble());
        if (input.getRealDouble() < 0.0) {
            value += Math.PI;
        }
        output.setReal(value);
    };
    public final Computers.Arity1<I, O> arccoth = (input, output) -> {
        double xt = input.getRealDouble();
        output.setReal(0.5 * Math.log((xt + 1.0) / (xt - 1.0)));
    };
    public final Computers.Arity1<I, O> arccsc = (input, output) -> {
        double xt = input.getRealDouble();
        if (xt > -1.0 && xt < 1.0) {
            throw new IllegalArgumentException("arccsc(x) : x out of range");
        }
        if (xt == -1.0) {
            output.setReal(-1.5707963267948966);
        } else if (xt == 1.0) {
            output.setReal(1.5707963267948966);
        } else {
            DoubleType tmp = new DoubleType();
            tmp.setReal(1.0 / xt);
            DoubleType angle = new DoubleType();
            angle.setReal(Math.asin(tmp.getRealDouble()));
            output.setReal(angle.getRealDouble());
        }
    };
    public final Computers.Arity1<I, O> arccsch = (input, output) -> {
        double xt = input.getRealDouble();
        double delta = Math.sqrt(1.0 + 1.0 / (xt * xt));
        output.setReal(Math.log(1.0 / xt + delta));
    };
    public final Computers.Arity1<I, O> arcsec = (input, output) -> {
        double xt = input.getRealDouble();
        if (xt > -1.0 && xt < 1.0) {
            throw new IllegalArgumentException("arcsec(x) : x out of range");
        }
        if (xt == -1.0) {
            output.setReal(Math.PI);
        } else if (xt == 1.0) {
            output.setReal(0.0f);
        } else {
            DoubleType tmp = new DoubleType();
            tmp.setReal(Math.sqrt(xt * xt - 1.0) / xt);
            DoubleType angle = new DoubleType();
            angle.setReal(Math.asin(tmp.getRealDouble()));
            double value = angle.getRealDouble();
            if (xt < -1.0) {
                value += Math.PI;
            }
            output.setReal(value);
        }
    };
    public final Computers.Arity1<I, O> arcsech = (input, output) -> {
        double xt = input.getRealDouble();
        double numer = 1.0 + Math.sqrt(1.0 - xt * xt);
        output.setReal(Math.log(numer / xt));
    };
    public final Computers.Arity1<I, O> arcsin = (input, output) -> output.setReal(Math.asin(input.getRealDouble()));
    public final Computers.Arity1<I, O> arcsinh = (input, output) -> {
        double xt = input.getRealDouble();
        double delta = Math.sqrt(xt * xt + 1.0);
        output.setReal(Math.log(xt + delta));
    };
    public final Computers.Arity1<I, O> arctan = (input, output) -> output.setReal(Math.atan(input.getRealDouble()));
    public final Computers.Arity1<I, O> arctanh = (input, output) -> {
        double xt = input.getRealDouble();
        output.setReal(0.5 * Math.log((1.0 + xt) / (1.0 - xt)));
    };
    public final Computers.Arity1<I, O> ceil = (input, output) -> output.setReal(Math.ceil(input.getRealDouble()));
    public final Computers.Arity1<I, O> cos = (input, output) -> output.setReal(Math.cos(input.getRealDouble()));
    public final Computers.Arity1<I, O> cosh = (input, output) -> output.setReal(Math.cosh(input.getRealDouble()));
    public final Computers.Arity1<I, O> cot = (input, output) -> output.setReal(1.0 / Math.tan(input.getRealDouble()));
    public final Computers.Arity1<I, O> coth = (input, output) -> output.setReal(1.0 / Math.tanh(input.getRealDouble()));
    public final Computers.Arity1<I, O> csc = (input, output) -> output.setReal(1.0 / Math.sin(input.getRealDouble()));
    public final Computers.Arity1<I, O> csch = (input, output) -> output.setReal(1.0 / Math.sinh(input.getRealDouble()));
    public final Computers.Arity1<I, O> cubeRoot = (input, output) -> output.setReal(Math.cbrt(input.getRealDouble()));
    public final Computers.Arity1<I, O> exp = (input, output) -> output.setReal(Math.exp(input.getRealDouble()));
    public final Computers.Arity1<I, O> expMinusOne = (input, output) -> output.setReal(Math.exp(input.getRealDouble()) - 1.0);
    public final Computers.Arity1<I, O> floor = (input, output) -> output.setReal(Math.floor(input.getRealDouble()));
    public final Computers.Arity2<I, Double, O> gamma = (input, constant, output) -> {
        double inputVal = input.getRealDouble();
        if (inputVal <= 0.0) {
            output.setReal(0.0f);
        } else {
            output.setReal(Math.exp(constant * Math.log(inputVal)));
        }
    };
    public final Computers.Arity3<I, Double, Double, O> invert = (input, specifiedMin, specifiedMax, output) -> output.setReal(specifiedMax - (input.getRealDouble() - specifiedMin));
    public final Computers.Arity1<I, O> log = (input, output) -> output.setReal(Math.log(input.getRealDouble()));
    public final Computers.Arity1<I, O> log10 = (input, output) -> output.setReal(Math.log10(input.getRealDouble()));
    public final Computers.Arity1<I, O> log2 = (input, output) -> output.setReal(Math.log(input.getRealDouble()) / Math.log(2.0));
    public final Computers.Arity1<I, O> logOnePlusX = (input, output) -> output.setReal(Math.log1p(input.getRealDouble()));
    public final Computers.Arity2<I, Double, O> max = (input, constant, output) -> {
        double value = input.getRealDouble();
        if (value < constant) {
            output.setReal(value);
        } else {
            output.setReal(constant.doubleValue());
        }
    };
    public final Computers.Arity2<I, Double, O> min = (input, constant, output) -> {
        double value = input.getRealDouble();
        if (value > constant) {
            output.setReal(value);
        } else {
            output.setReal(constant.doubleValue());
        }
    };
    public final Computers.Arity1<I, O> nearestInt = (input, output) -> output.setReal(Math.rint(input.getRealDouble()));
    public final Computers.Arity1<I, O> negate = (input, output) -> output.setReal(-input.getRealDouble());
    public final Computers.Arity2<I, Double, O> power = (input, constant, output) -> output.setReal(Math.pow(input.getRealDouble(), constant));
    public final Computers.Arity2<I, Integer, I> intPower = (input, constant, output) -> {
        output.setOne();
        for (int i = 0; i < constant; ++i) {
            output.mul(input);
        }
    };
    public final Computers.Arity2<I, Double, O> reciprocal = (input, dbzVal, output) -> {
        double inputVal = input.getRealDouble();
        if (inputVal == 0.0) {
            output.setReal(dbzVal.doubleValue());
        } else {
            output.setReal(1.0 / inputVal);
        }
    };
    public final Computers.Arity1<I, O> round = (input, output) -> output.setReal((double)Math.round(input.getRealDouble()));
    public final Computers.Arity1<I, O> sec = (input, output) -> output.setReal(1.0 / Math.cos(input.getRealDouble()));
    public final Computers.Arity1<I, O> sech = (input, output) -> output.setReal(1.0 / Math.cosh(input.getRealDouble()));
    public final Computers.Arity1<I, O> signum = (input, output) -> output.setReal(Math.signum(input.getRealDouble()));
    public final Computers.Arity1<I, O> sin = (input, output) -> output.setReal(Math.sin(input.getRealDouble()));
    public final Computers.Arity1<I, O> sinc = (input, output) -> {
        double x = input.getRealDouble();
        double value = x == 0.0 ? 1.0 : Math.sin(x) / x;
        output.setReal(value);
    };
    public final Computers.Arity1<I, O> sincPi = (input, output) -> {
        double x = input.getRealDouble();
        double value = x == 0.0 ? 1.0 : Math.sin(Math.PI * x) / (Math.PI * x);
        output.setReal(value);
    };
    public final Computers.Arity1<I, O> sinh = (input, output) -> output.setReal(Math.sinh(input.getRealDouble()));
    public final Computers.Arity1<I, O> square = (input, output) -> output.setReal(input.getRealDouble() * input.getRealDouble());
    public final Computers.Arity1<I, O> sqrt = (input, output) -> output.setReal(Math.sqrt(input.getRealDouble()));
    public final Computers.Arity1<I, O> step = (input, output) -> {
        if (input.getRealDouble() < 0.0) {
            output.setZero();
        } else {
            output.setOne();
        }
    };
    public final Computers.Arity1<I, O> tan = (input, output) -> output.setReal(Math.tan(input.getRealDouble()));
    public final Computers.Arity1<I, O> tanh = (input, output) -> output.setReal(Math.tanh(input.getRealDouble()));
    public final Computers.Arity1<I, O> ulp = (input, output) -> output.setReal(Math.ulp(input.getRealDouble()));
}

