/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public final class ApplyThresholdMethodLocal {
    private ApplyThresholdMethodLocal() {
    }

    private static abstract class AbstractApplyLocalHistogramBasedThreshold<T extends RealType<T>>
    implements Computers.Arity3<RandomAccessibleInterval<T>, Shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<BitType>> {
        @OpDependency(name="image.histogram")
        private Function<Iterable<T>, Histogram1d<T>> createHistogramOp;
        @OpDependency(name="threshold.apply")
        private Computers.Arity2<Comparable<? super T>, T, BitType> applyThresholdOp;
        @OpDependency(name="filter.applyCenterAware")
        private Computers.Arity4<RandomAccessibleInterval<T>, Computers.Arity2<Iterable<T>, T, BitType>, Shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<BitType>> applyFilterOp;
        private Computers.Arity2<Iterable<T>, T, BitType> thresholdOp;

        private AbstractApplyLocalHistogramBasedThreshold() {
        }

        public void compute(RandomAccessibleInterval<T> input, Shape inputNeighborhoodShape, @Nullable OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, RandomAccessibleInterval<BitType> output) {
            if (outOfBoundsFactory == null) {
                outOfBoundsFactory = new OutOfBoundsBorderFactory();
            }
            if (this.thresholdOp == null) {
                this.thresholdOp = this.getThresholdOp();
            }
            this.applyFilterOp.compute(input, this.thresholdOp, (Object)inputNeighborhoodShape, (Object)outOfBoundsFactory, output);
        }

        private Computers.Arity2<Iterable<T>, T, BitType> getThresholdOp() {
            final Computers.Arity1<Histogram1d<T>, T> computeThresholdOp = this.getComputeThresholdOp();
            return new Computers.Arity2<Iterable<T>, T, BitType>(){

                public void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, BitType output) {
                    Histogram1d histogram = createHistogramOp.apply(inputNeighborhood);
                    RealType threshold = (RealType)((RealType)inputNeighborhood.iterator().next()).createVariable();
                    computeThresholdOp.compute(histogram, (Object)threshold);
                    applyThresholdOp.compute(inputCenterPixel, (Object)threshold, (Object)output);
                }
            };
        }

        protected abstract Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp();
    }

    public static class LocalYen<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.yen")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalTriangle<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.triangle")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalShanbhag<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.shanbhag")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalRosin<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.rosin")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalRenyiEntropy<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.renyiEntropy")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalPercentile<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.percentile")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalOtsu<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.otsu")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalMoments<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.moments")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalMinimum<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.minimum")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalMinError<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.minError")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalHistogramBasedMean<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.mean")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalMaxLikelihood<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.maxLikelihood")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalMaxEntropy<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.maxEntropy")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalLi<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.li")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalIsoData<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.isoData")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalIntermodes<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.intermodes")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalIJ1<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.ij1")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }

    public static class LocalHuang<T extends RealType<T>>
    extends AbstractApplyLocalHistogramBasedThreshold<T> {
        @OpDependency(name="threshold.huang")
        private Computers.Arity1<Histogram1d<T>, T> computeThresholdOp;

        @Override
        protected Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp() {
            return this.computeThresholdOp;
        }
    }
}

