/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.minError;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;
import org.scijava.ops.image.threshold.Thresholds;
import org.scijava.ops.image.threshold.mean.ComputeMeanThreshold;
import org.scijava.ops.spi.OpExecutionException;

public class ComputeMinErrorThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputeMinErrorThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        int threshold = (int)ComputeMeanThreshold.computeBin(histogram);
        int Tprev = -2;
        while (threshold != Tprev) {
            double w2;
            double w0;
            double tau2;
            double mu = Thresholds.B(histogram, threshold) / Thresholds.A(histogram, threshold);
            double nu = (Thresholds.B(histogram, histogram.length - 1) - Thresholds.B(histogram, threshold)) / (Thresholds.A(histogram, histogram.length - 1) - Thresholds.A(histogram, threshold));
            double p = Thresholds.A(histogram, threshold) / Thresholds.A(histogram, histogram.length - 1);
            double q = (Thresholds.A(histogram, histogram.length - 1) - Thresholds.A(histogram, threshold)) / Thresholds.A(histogram, histogram.length - 1);
            double sigma2 = Thresholds.C(histogram, threshold) / Thresholds.A(histogram, threshold) - mu * mu;
            double w1 = mu / sigma2 - nu / (tau2 = (Thresholds.C(histogram, histogram.length - 1) - Thresholds.C(histogram, threshold)) / (Thresholds.A(histogram, histogram.length - 1) - Thresholds.A(histogram, threshold)) - nu * nu);
            double sqterm = w1 * w1 - (w0 = 1.0 / sigma2 - 1.0 / tau2) * (w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log10(sigma2 * (q * q) / (tau2 * (p * p))));
            if (sqterm < 0.0) {
                throw new OpExecutionException("MinError(I): not converging. Try 'Ignore black/white' options");
            }
            Tprev = threshold;
            double temp = (w1 + Math.sqrt(sqterm)) / w0;
            if (Double.isNaN(temp)) {
                threshold = Tprev;
            }
            threshold = (int)Math.floor(temp);
        }
        return threshold;
    }
}

