/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.topology.eulerCharacteristic;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.image.topology.eulerCharacteristic.Octant;

public class EulerCharacteristic26NFloating<B extends BooleanType<B>>
implements Computers.Arity1<RandomAccessibleInterval<B>, DoubleType> {
    private static final int[] EULER_LUT = new int[256];

    public void compute(RandomAccessibleInterval<B> interval, DoubleType output) {
        if (interval.numDimensions() != 3) {
            throw new IllegalArgumentException("Input must have 3 dimensions!");
        }
        Octant<B> octant = new Octant<B>(interval);
        int sumDeltaEuler = 0;
        int z = 0;
        while ((long)z <= interval.dimension(2)) {
            int y = 0;
            while ((long)y <= interval.dimension(1)) {
                int x = 0;
                while ((long)x <= interval.dimension(0)) {
                    octant.setNeighborhood(x, y, z);
                    sumDeltaEuler += EulerCharacteristic26NFloating.getDeltaEuler(octant);
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        output.set((double)sumDeltaEuler / 8.0);
    }

    private static int getDeltaEuler(Octant octant) {
        if (octant.isNeighborhoodEmpty()) {
            return 0;
        }
        int index = 1;
        if (octant.isNeighborForeground(8)) {
            if (octant.isNeighborForeground(1)) {
                index |= 0x80;
            }
            if (octant.isNeighborForeground(2)) {
                index |= 0x40;
            }
            if (octant.isNeighborForeground(3)) {
                index |= 0x20;
            }
            if (octant.isNeighborForeground(4)) {
                index |= 0x10;
            }
            if (octant.isNeighborForeground(5)) {
                index |= 8;
            }
            if (octant.isNeighborForeground(6)) {
                index |= 4;
            }
            if (octant.isNeighborForeground(7)) {
                index |= 2;
            }
        } else if (octant.isNeighborForeground(7)) {
            if (octant.isNeighborForeground(2)) {
                index |= 0x80;
            }
            if (octant.isNeighborForeground(4)) {
                index |= 0x40;
            }
            if (octant.isNeighborForeground(1)) {
                index |= 0x20;
            }
            if (octant.isNeighborForeground(3)) {
                index |= 0x10;
            }
            if (octant.isNeighborForeground(6)) {
                index |= 8;
            }
            if (octant.isNeighborForeground(5)) {
                index |= 2;
            }
        } else if (octant.isNeighborForeground(6)) {
            if (octant.isNeighborForeground(3)) {
                index |= 0x80;
            }
            if (octant.isNeighborForeground(1)) {
                index |= 0x40;
            }
            if (octant.isNeighborForeground(4)) {
                index |= 0x20;
            }
            if (octant.isNeighborForeground(2)) {
                index |= 0x10;
            }
            if (octant.isNeighborForeground(5)) {
                index |= 4;
            }
        } else if (octant.isNeighborForeground(5)) {
            if (octant.isNeighborForeground(4)) {
                index |= 0x80;
            }
            if (octant.isNeighborForeground(3)) {
                index |= 0x40;
            }
            if (octant.isNeighborForeground(2)) {
                index |= 0x20;
            }
            if (octant.isNeighborForeground(1)) {
                index |= 0x10;
            }
        } else if (octant.isNeighborForeground(4)) {
            if (octant.isNeighborForeground(1)) {
                index |= 8;
            }
            if (octant.isNeighborForeground(3)) {
                index |= 4;
            }
            if (octant.isNeighborForeground(2)) {
                index |= 2;
            }
        } else if (octant.isNeighborForeground(3)) {
            if (octant.isNeighborForeground(2)) {
                index |= 8;
            }
            if (octant.isNeighborForeground(1)) {
                index |= 4;
            }
        } else if (octant.isNeighborForeground(2) && octant.isNeighborForeground(1)) {
            index |= 2;
        }
        return EULER_LUT[index];
    }

    static {
        EulerCharacteristic26NFloating.EULER_LUT[1] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[3] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[5] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[7] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[9] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[11] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[13] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[15] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[17] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[19] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[21] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[23] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[25] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[27] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[29] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[31] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[33] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[35] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[37] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[39] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[41] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[43] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[45] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[47] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[49] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[51] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[53] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[55] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[57] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[59] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[61] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[63] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[65] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[67] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[69] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[71] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[73] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[75] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[77] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[79] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[81] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[83] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[85] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[87] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[89] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[91] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[93] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[95] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[97] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[99] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[101] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[103] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[105] = 4;
        EulerCharacteristic26NFloating.EULER_LUT[107] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[109] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[111] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[113] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[115] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[117] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[119] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[121] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[123] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[125] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[127] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[129] = -6;
        EulerCharacteristic26NFloating.EULER_LUT[131] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[133] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[135] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[137] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[139] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[141] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[143] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[145] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[147] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[149] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[151] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[153] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[155] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[157] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[159] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[161] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[163] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[165] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[167] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[169] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[171] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[173] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[175] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[177] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[179] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[181] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[183] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[185] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[187] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[189] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[191] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[193] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[195] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[197] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[199] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[201] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[203] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[205] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[207] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[209] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[211] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[213] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[215] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[217] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[219] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[221] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[223] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[225] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[227] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[229] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[231] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[233] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[235] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[237] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[239] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[241] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[243] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[245] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[247] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[249] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[251] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[253] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[255] = 0;
    }
}

