/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.SetType;
import visad.TrajectoryManager;
import visad.Tri;
import visad.Unit;
import visad.VisADException;

public class GriddedLatLonSet
extends Gridded2DSet {
    int LengthX;
    int LengthY;
    int TrackLen;
    int latI;
    int lonI;
    float LowX;
    float HiX;
    float LowY;
    float HiY;
    float[] lons;
    float[] lats;
    float[][] mySamples;
    GriddedLatLonSet[] granules;
    int[] yStart;
    int[] lgxy;
    public static int[] UL = new int[]{-1, 1};
    public static int[] UR = new int[]{1, 1};
    public static int[] DL = new int[]{-1, -1};
    public static int[] DR = new int[]{1, -1};
    public static int[] UU = new int[]{0, 1};
    public static int[] DD = new int[]{0, -1};
    public static int[] LL = new int[]{-1, 0};
    public static int[] RR = new int[]{1, 0};
    public static int[] CC = new int[]{0, 0};

    public GriddedLatLonSet(MathType type, float[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, samples, lengthX, lengthY, null, null, null, false, false);
    }

    public GriddedLatLonSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, true, true);
    }

    public GriddedLatLonSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, copy, true);
    }

    public GriddedLatLonSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, boolean test) throws VisADException {
        super(type, samples, lengthX, lengthY, coord_sys, units, errors, copy, test);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.TrackLen = this.LengthY = this.Lengths[1];
        this.lgxy = new int[]{-1, -1};
        if (!type.equals(RealTupleType.LatitudeLongitudeTuple) && !type.equals(RealTupleType.SpatialEarth2DTuple)) {
            throw new VisADException("type must 2D with Latitude and Longitude");
        }
        MathType type0 = ((SetType)this.getType()).getDomain().getComponent(0);
        this.latI = RealType.Latitude.equals(type0) ? 0 : 1;
        this.lonI = this.latI == 0 ? 1 : 0;
        this.mySamples = this.getMySamples();
        this.lons = this.mySamples[this.lonI];
        this.lats = this.mySamples[this.latI];
        double accum = 0.0;
        for (int k = 0; k < this.TrackLen - 1; ++k) {
            int idx0 = k * this.LengthX;
            int idx1 = (k + 1) * this.LengthX;
            float lonA = this.lons[idx1];
            float latA = this.lats[idx1];
            float lonB = this.lons[idx0];
            float latB = this.lats[idx0];
            if (Float.isNaN(latA) || Float.isNaN(latB) || !(Math.abs(latA) <= 90.0f) || !(Math.abs(latB) <= 90.0f)) continue;
            double angle = GriddedLatLonSet.greatCircleAngle(this.lons[idx1], this.lats[idx1], this.lons[idx0], this.lats[idx0]);
            accum += angle;
        }
        if (accum > 4.71238898038469) {
            this.granules = new GriddedLatLonSet[2];
            this.yStart = new int[2];
            this.yStart[0] = 0;
            this.yStart[1] = this.TrackLen / 2;
            int TrackLen0 = this.TrackLen / 2;
            int TrackLen1 = this.TrackLen - TrackLen0;
            float[] lons0 = new float[this.LengthX * TrackLen0];
            float[] lats0 = new float[this.LengthX * TrackLen0];
            System.arraycopy(this.lons, 0, lons0, 0, lons0.length);
            System.arraycopy(this.lats, 0, lats0, 0, lats0.length);
            float[] lons1 = new float[this.LengthX * TrackLen1];
            float[] lats1 = new float[this.LengthX * TrackLen1];
            System.arraycopy(this.lons, lons0.length, lons1, 0, lons1.length);
            System.arraycopy(this.lats, lats0.length, lats1, 0, lats1.length);
            this.granules[0] = new GriddedLatLonSet(type, new float[][]{lons0, lats0}, this.LengthX, TrackLen0, coord_sys, units, errors, copy, test);
            this.granules[1] = new GriddedLatLonSet(type, new float[][]{lons1, lats1}, this.LengthX, TrackLen1, coord_sys, units, errors, copy, test);
        }
    }

    @Override
    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Gridded2DSet.gridToValue: grid dimension " + grid.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.gridToValue: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int length = Math.min(grid[0].length, grid[1].length);
        float[][] value = new float[2][length];
        for (int i = 0; i < length; ++i) {
            int j;
            float gx = grid[0][i];
            float gy = grid[1][i];
            if ((double)gx < -0.5 || (double)gy < -0.5 || (double)gx > (double)this.LengthX - 0.5 || (double)gy > (double)this.TrackLen - 0.5) {
                value[1][i] = Float.NaN;
                value[0][i] = Float.NaN;
                continue;
            }
            if (this.Length == 1) {
                value[0][i] = this.mySamples[0][0];
                value[1][i] = this.mySamples[1][0];
                continue;
            }
            int igx = (int)gx;
            int igy = (int)gy;
            if (igx < 0) {
                igx = 0;
            }
            if (igx > this.LengthX - 2) {
                igx = this.LengthX - 2;
            }
            if (igy < 0) {
                igy = 0;
            }
            if (igy > this.TrackLen - 2) {
                igy = this.TrackLen - 2;
            }
            int idx = igy * this.LengthX + igx;
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            float lon = this.mySamples[this.lonI][idx];
            if (lon < min) {
                min = lon;
            }
            if (lon > max) {
                max = lon;
            }
            if (gx + 1.0f < (float)this.LengthX) {
                lon = this.mySamples[this.lonI][idx + 1];
                if (lon < min) {
                    min = lon;
                }
                if (lon > max) {
                    max = lon;
                }
            }
            if (gy + 1.0f < (float)this.TrackLen) {
                lon = this.mySamples[this.lonI][idx + this.LengthX];
                if (lon < min) {
                    min = lon;
                }
                if (lon > max) {
                    max = lon;
                }
            }
            if (gx + 1.0f < (float)this.LengthX && gy + 1.0f < (float)this.TrackLen) {
                lon = this.mySamples[this.lonI][idx + this.LengthX + 1];
                if (lon < min) {
                    min = lon;
                }
                if (lon > max) {
                    max = lon;
                }
            }
            if (max - min > 300.0f) {
                gx = (float)Math.floor((double)gx + 0.5);
                gy = (float)Math.floor((double)gy + 0.5);
            }
            int[][] s = new int[][]{{this.LengthX * igy + igx, this.LengthX * (igy + 1) + igx}, {this.LengthX * igy + igx + 1, this.LengthX * (igy + 1) + igx + 1}};
            if (gx + gy - (float)igx - (float)igy - 1.0f <= 0.0f) {
                for (j = 0; j < 2; ++j) {
                    value[j][i] = this.mySamples[j][s[0][0]] + (gx - (float)igx) * (this.mySamples[j][s[1][0]] - this.mySamples[j][s[0][0]]) + (gy - (float)igy) * (this.mySamples[j][s[0][1]] - this.mySamples[j][s[0][0]]);
                }
                continue;
            }
            for (j = 0; j < 2; ++j) {
                value[j][i] = this.mySamples[j][s[1][1]] + ((float)(1 + igx) - gx) * (this.mySamples[j][s[0][1]] - this.mySamples[j][s[1][1]]) + ((float)(1 + igy) - gy) * (this.mySamples[j][s[1][0]] - this.mySamples[j][s[1][1]]);
            }
        }
        return value;
    }

    @Override
    public float[][] valueToGrid(float[][] value) throws VisADException {
        return this.valueToGrid(value, null);
    }

    @Override
    public synchronized float[][] valueToGrid(float[][] value, int[] guess) throws VisADException {
        if (this.granules != null) {
            float[][] grid = this.granules[0].valueToGrid(value, guess);
            if (Float.isNaN(grid[0][0])) {
                grid = this.granules[1].valueToGrid(value, guess);
                float[] fArray = grid[1];
                fArray[0] = fArray[0] + (float)this.yStart[1];
            }
            return grid;
        }
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        if (guess != null && guess.length != 2) {
            throw new SetException("Gridded2DSet.valueToGrid: guess length " + guess.length + " must equal 2");
        }
        int length = Math.min(value[0].length, value[1].length);
        float[][] grid = new float[this.ManifoldDimension][length];
        int gx = (this.LengthX - 1) / 2;
        int gy = (this.TrackLen - 1) / 2;
        if (guess != null && guess[0] >= 0 && guess[1] >= 0) {
            gx = guess[0];
            gy = guess[1];
        } else if (this.lgxy[0] != -1 && this.lgxy[1] != -1) {
            gx = this.lgxy[0];
            gy = this.lgxy[1];
        } else {
            int[] gg = this.findValid(gx, gy);
            if (gg != null) {
                gx = gg[0];
                gy = gg[1];
            }
        }
        int idx = gy * this.LengthX + gx;
        if (Float.isNaN(this.lons[idx]) || Float.isNaN(this.lats[idx]) || Math.abs(this.lats[idx]) > 90.0f) {
            throw new VisADException("initial grid box guess cannot be invalid or missing");
        }
        block0: for (int i = 0; i < length; ++i) {
            if (this.Length == 1) {
                if (Float.isNaN(value[0][i]) || Float.isNaN(value[1][i])) {
                    grid[1][i] = Float.NaN;
                    grid[0][i] = Float.NaN;
                    continue;
                }
                grid[0][i] = 0.0f;
                grid[1][i] = 0.0f;
                continue;
            }
            if (i != 0 && grid[0][i - 1] != grid[0][i - 1] && this.lgxy[0] != -1 && this.lgxy[1] != -1) {
                gx = this.lgxy[0];
                gy = this.lgxy[1];
            }
            grid[1][i] = Float.NaN;
            grid[0][i] = Float.NaN;
            int igx = 0;
            int igy = 0;
            int last_igx = 0;
            int last_igy = 0;
            for (int itnum = 0; itnum < 2 * (this.LengthX + this.TrackLen); ++itnum) {
                Tri tri;
                float angle;
                float lon;
                float lat;
                float targetLon = value[this.lonI][i];
                float targetLat = value[this.latI][i];
                float glon = this.lons[gy * this.LengthX + gx];
                float glat = this.lats[gy * this.LengthX + gx];
                float angleToTarget = (float)GriddedLatLonSet.greatCircleAngle(targetLon, targetLat, glon, glat);
                igx = 0;
                igy = 0;
                idx = (gy + 1) * this.LengthX + gx;
                if (gy + 1 < this.TrackLen) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = 0;
                        igy = 1;
                    }
                }
                idx = (gy - 1) * this.LengthX + gx;
                if (gy - 1 >= 0) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = 0;
                        igy = -1;
                    }
                }
                idx = gy * this.LengthX + gx + 1;
                if (gx + 1 < this.LengthX) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = 1;
                        igy = 0;
                    }
                }
                idx = gy * this.LengthX + gx - 1;
                if (gx - 1 >= 0) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = -1;
                        igy = 0;
                    }
                }
                idx = (gy + 1) * this.LengthX + gx - 1;
                if (gy + 1 < this.TrackLen && gx - 1 >= 0) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = -1;
                        igy = 1;
                    }
                }
                idx = (gy + 1) * this.LengthX + gx + 1;
                if (gx + 1 < this.LengthX && gy + 1 < this.TrackLen) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = 1;
                        igy = 1;
                    }
                }
                idx = (gy - 1) * this.LengthX + gx - 1;
                if (gy - 1 >= 0 && gx - 1 >= 0) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = -1;
                        igy = -1;
                    }
                }
                idx = (gy - 1) * this.LengthX + gx + 1;
                if (gy - 1 >= 0 && gx + 1 < this.LengthX) {
                    lat = this.lats[idx];
                    lon = this.lons[idx];
                    if (Math.abs(lat) > 90.0f) {
                        gx += last_igx;
                        gy += last_igy;
                        continue;
                    }
                    angle = (float)GriddedLatLonSet.greatCircleAngle(lon, lat, targetLon, targetLat);
                    if (angle < angleToTarget) {
                        angleToTarget = angle;
                        igx = 1;
                        igy = -1;
                    }
                }
                gx += igx;
                gy += igy;
                last_igx = igx;
                last_igy = igy;
                if (igx != 0 || igy != 0) continue;
                boolean offGrid = false;
                int[] gg = new int[]{gx, gy};
                float[] tt = GriddedLatLonSet.toXYZ(new float[]{targetLat, targetLon, 1.0f});
                if (gx == 0 && gy == 0) {
                    offGrid = !this.insideTriangle(gg, CC, UU, RR, tt);
                } else if (gx == 0 && gy == this.TrackLen - 1) {
                    offGrid = !this.insideTriangle(gg, CC, DD, RR, tt);
                } else if (gx == this.LengthX - 1 && gy == 0) {
                    offGrid = !this.insideTriangle(gg, CC, UU, LL, tt);
                } else if (gx == this.LengthX - 1 && gy == this.TrackLen - 1) {
                    offGrid = !this.insideTriangle(gg, CC, LL, DD, tt);
                } else if (gy == 0) {
                    offGrid = !this.insideTriangle(gg, LL, UU, RR, tt);
                } else if (gy == this.TrackLen - 1) {
                    offGrid = !this.insideTriangle(gg, LL, DD, RR, tt);
                } else if (gx == 0) {
                    offGrid = !this.insideTriangle(gg, UU, RR, DD, tt);
                } else if (gx == this.LengthX - 1) {
                    boolean bl = offGrid = !this.insideTriangle(gg, UU, LL, DD, tt);
                }
                if (offGrid || (tri = this.whichTriangle(gg, tt)) == null) continue block0;
                float[] gxy = tri.reverseInterpolate(new float[]{value[this.lonI][i], value[this.latI][i]});
                grid[0][i] = gxy[0];
                grid[1][i] = gxy[1];
                this.lgxy[0] = gx;
                this.lgxy[1] = gy;
                continue block0;
            }
        }
        if (guess != null) {
            guess[0] = gx;
            guess[1] = gy;
        }
        return grid;
    }

    private int[] findValid(int gx, int gy) {
        for (int cnt = 0; cnt < Math.min(this.LengthX, this.TrackLen) / 2 - 2; ++cnt) {
            int idx = (gy + cnt) * this.LengthX + gx;
            if (Math.abs(this.lats[idx]) <= 90.0f) {
                return new int[]{gx, gy + cnt};
            }
            idx = (gy - cnt) * this.LengthX + gx;
            if (Math.abs(this.lats[idx]) <= 90.0f) {
                return new int[]{gx, gy - cnt};
            }
            idx = gy * this.LengthX + (gx + cnt);
            if (Math.abs(this.lats[idx]) <= 90.0f) {
                return new int[]{gx + cnt, gy};
            }
            idx = gy * this.LengthX + (gx - cnt);
            if (!(Math.abs(this.lats[idx]) <= 90.0f)) continue;
            return new int[]{gx - cnt, gy};
        }
        return null;
    }

    public static float[] toXYZ(float[] latlonrad) {
        float[] value = new float[3];
        float coslat = (float)Math.cos(Math.PI / 180 * (double)latlonrad[0]);
        float sinlat = (float)Math.sin(Math.PI / 180 * (double)latlonrad[0]);
        float coslon = (float)Math.cos(Math.PI / 180 * (double)latlonrad[1]);
        float sinlon = (float)Math.sin(Math.PI / 180 * (double)latlonrad[1]);
        value[0] = latlonrad[2] * coslon * coslat;
        value[1] = latlonrad[2] * sinlon * coslat;
        value[2] = latlonrad[2] * sinlat;
        return value;
    }

    public static double greatCircleAngle(double lonA, double latA, double lonB, double latB) {
        double degToRad = Math.PI / 180;
        double S = Math.sin(((latA *= degToRad) - (latB *= degToRad)) / 2.0);
        double Spow2 = S * S;
        double T = Math.sin(((lonA *= degToRad) - (lonB *= degToRad)) / 2.0);
        double Tpow2 = T * T;
        double arc = 2.0 * Math.asin(Math.sqrt(Spow2 + Math.cos(latA) * Math.cos(latB) * Tpow2));
        arc = Math.abs(arc);
        return arc;
    }

    public static boolean insideTriangle(float[] v0, float[] v1, float[] v2, float[] pt) {
        boolean test2;
        float[] triNorm = TrajectoryManager.AxB(new float[]{v1[0] - v0[0], v1[1] - v0[1], v1[2] - v0[2]}, new float[]{v2[0] - v0[0], v2[1] - v0[1], v2[2] - v0[2]}, true);
        double[] coeffs = TrajectoryManager.getPlaneCoeffsFromNormalAndPoint(new double[]{triNorm[0], triNorm[1], triNorm[2]}, new double[]{v0[0], v0[1], v0[2]});
        float mag = TrajectoryManager.vecMag(pt);
        double[] uvec = new double[]{pt[0] / mag, pt[1] / mag, pt[2] / mag};
        double[] p = TrajectoryManager.getLinePlaneIntersect(coeffs, uvec, new double[]{0.0, 0.0, 0.0});
        float[] ab = new float[]{v1[0] - v0[0], v1[1] - v0[1], v1[2] - v0[2]};
        float[] bc = new float[]{v2[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]};
        float[] ca = new float[]{v0[0] - v2[0], v0[1] - v2[1], v0[2] - v2[2]};
        float[] pa = new float[]{pt[0] - v0[0], pt[1] - v0[1], pt[2] - v0[2]};
        float[] pb = new float[]{pt[0] - v1[0], pt[1] - v1[1], pt[2] - v1[2]};
        float[] pc = new float[]{pt[0] - v2[0], pt[1] - v2[1], pt[2] - v2[2]};
        boolean test0 = TrajectoryManager.AdotB(TrajectoryManager.AxB(pa, ab), triNorm) > 0.0f;
        boolean test1 = TrajectoryManager.AdotB(TrajectoryManager.AxB(pb, bc), triNorm) > 0.0f;
        boolean bl = test2 = TrajectoryManager.AdotB(TrajectoryManager.AxB(pc, ca), triNorm) > 0.0f;
        return test0 && test1 && test2 || !test0 && !test1 && !test2;
    }

    public boolean insideTriangle(int[] gg, int[] v0, int[] v1, int[] v2, float[] pt) {
        int gx = gg[0] + v0[0];
        int gy = gg[1] + v0[1];
        if (gx < 0 || gx > this.LengthX - 1 || gy < 0 || gy > this.TrackLen - 1) {
            return false;
        }
        int idx0 = gy * this.LengthX + gx;
        gx = gg[0] + v1[0];
        gy = gg[1] + v1[1];
        if (gx < 0 || gx > this.LengthX - 1 || gy < 0 || gy > this.TrackLen - 1) {
            return false;
        }
        int idx1 = gy * this.LengthX + gx;
        gx = gg[0] + v2[0];
        gy = gg[1] + v2[1];
        if (gx < 0 || gx > this.LengthX - 1 || gy < 0 || gy > this.TrackLen - 1) {
            return false;
        }
        int idx2 = gy * this.LengthX + gx;
        float[] aa = GriddedLatLonSet.toXYZ(new float[]{this.lats[idx0], this.lons[idx0], 1.0f});
        float[] bb = GriddedLatLonSet.toXYZ(new float[]{this.lats[idx1], this.lons[idx1], 1.0f});
        float[] cc = GriddedLatLonSet.toXYZ(new float[]{this.lats[idx2], this.lons[idx2], 1.0f});
        return GriddedLatLonSet.insideTriangle(aa, bb, cc, pt);
    }

    public Tri whichTriangle(int[] gg, float[] pt) {
        Tri tri = null;
        float[] v0 = new float[2];
        float[] v1 = new float[2];
        float[] v2 = new float[2];
        float[] v3 = new float[2];
        int[] ngg = new int[2];
        if (this.insideTriangle(gg, CC, UU, RR, pt)) {
            int idx = gg[1] * this.LengthX + gg[0];
            v0[0] = this.lons[idx];
            v0[1] = this.lats[idx];
            idx = (gg[1] + RR[1]) * this.LengthX + (gg[0] + RR[0]);
            v1[0] = this.lons[idx];
            v1[1] = this.lats[idx];
            idx = (gg[1] + UU[1]) * this.LengthX + (gg[0] + UU[0]);
            v2[0] = this.lons[idx];
            v2[1] = this.lats[idx];
            tri = new Tri(gg, v0, v1, v2, null, true);
        } else if (this.insideTriangle(new int[]{gg[0] - 1, gg[1] - 1}, UU, UR, RR, pt)) {
            int gx = gg[0] - 1;
            int gy = gg[1] - 1;
            int idx = (gy + RR[1]) * this.LengthX + (gx + RR[0]);
            v1[0] = this.lons[idx];
            v1[1] = this.lats[idx];
            idx = (gy + UU[1]) * this.LengthX + (gx + UU[0]);
            v2[0] = this.lons[idx];
            v2[1] = this.lats[idx];
            idx = (gy + UR[1]) * this.LengthX + (gx + UR[0]);
            v3[0] = this.lons[idx];
            v3[1] = this.lats[idx];
            ngg[0] = gx;
            ngg[1] = gy;
            tri = new Tri(ngg, null, v1, v2, v3, false);
        } else if (this.insideTriangle(new int[]{gg[0], gg[1] - 1}, CC, UU, RR, pt)) {
            int gx = gg[0];
            int gy = gg[1] - 1;
            int idx = (gy + CC[1]) * this.LengthX + (gx + CC[0]);
            v0[0] = this.lons[idx];
            v0[1] = this.lats[idx];
            idx = (gy + RR[1]) * this.LengthX + (gx + RR[0]);
            v1[0] = this.lons[idx];
            v1[1] = this.lats[idx];
            idx = (gy + UU[1]) * this.LengthX + (gx + UU[0]);
            v2[0] = this.lons[idx];
            v2[1] = this.lats[idx];
            ngg[0] = gx;
            ngg[1] = gy;
            tri = new Tri(ngg, v0, v1, v2, null, true);
        } else if (this.insideTriangle(new int[]{gg[0], gg[1] - 1}, UU, UR, RR, pt)) {
            int gx = gg[0];
            int gy = gg[1] - 1;
            int idx = (gy + RR[1]) * this.LengthX + (gx + RR[0]);
            v1[0] = this.lons[idx];
            v1[1] = this.lats[idx];
            idx = (gy + UU[1]) * this.LengthX + (gx + UU[0]);
            v2[0] = this.lons[idx];
            v2[1] = this.lats[idx];
            idx = (gy + UR[1]) * this.LengthX + (gx + UR[0]);
            v3[0] = this.lons[idx];
            v3[1] = this.lats[idx];
            ngg[0] = gx;
            ngg[1] = gy;
            tri = new Tri(ngg, null, v1, v2, v3, false);
        } else if (this.insideTriangle(new int[]{gg[0] - 1, gg[1]}, CC, UU, RR, pt)) {
            int gx = gg[0] - 1;
            int gy = gg[1];
            int idx = (gy + CC[1]) * this.LengthX + (gx + CC[0]);
            v0[0] = this.lons[idx];
            v0[1] = this.lats[idx];
            idx = (gy + RR[1]) * this.LengthX + (gx + RR[0]);
            v1[0] = this.lons[idx];
            v1[1] = this.lats[idx];
            idx = (gy + UU[1]) * this.LengthX + (gx + UU[0]);
            v2[0] = this.lons[idx];
            v2[1] = this.lats[idx];
            ngg[0] = gx;
            ngg[1] = gy;
            tri = new Tri(ngg, v0, v1, v2, null, true);
        } else if (this.insideTriangle(new int[]{gg[0] - 1, gg[1]}, UU, UR, RR, pt)) {
            int gx = gg[0] - 1;
            int gy = gg[1];
            int idx = (gy + RR[1]) * this.LengthX + (gx + RR[0]);
            v1[0] = this.lons[idx];
            v1[1] = this.lats[idx];
            idx = (gy + UU[1]) * this.LengthX + (gx + UU[0]);
            v2[0] = this.lons[idx];
            v2[1] = this.lats[idx];
            idx = (gy + UR[1]) * this.LengthX + (gx + UR[0]);
            v3[0] = this.lons[idx];
            v3[1] = this.lats[idx];
            ngg[0] = gx;
            ngg[1] = gy;
            tri = new Tri(ngg, null, v1, v2, v3, false);
        }
        return tri;
    }
}

