/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.QuickSort;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class Irregular1DSet
extends IrregularSet {
    float LowX;
    float HiX;
    Gridded1DSet SortedSet;

    public Irregular1DSet(MathType type, float[][] samples) throws VisADException {
        this(type, samples, null, null, null, true);
    }

    public Irregular1DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, coord_sys, units, errors, true);
    }

    public Irregular1DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, samples, samples.length, coord_sys, units, errors, null, copy);
        int i;
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        float[][] sortedSamples = new float[1][this.Length];
        float[][] mySamples = this.getMySamples();
        for (i = 0; i < this.Length; ++i) {
            sortedSamples[0][i] = mySamples[0][i];
        }
        this.newToOld = QuickSort.sort(sortedSamples[0]);
        this.oldToNew = new int[this.Length];
        for (i = 0; i < this.Length; ++i) {
            this.oldToNew[this.newToOld[i]] = i;
        }
        this.SortedSet = new Gridded1DSet(type, sortedSamples, this.Length, coord_sys, units, errors, false);
    }

    @Override
    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        if (samples.length == 3) {
            return new Irregular3DSet((MathType)type, samples, this.newToOld, this.oldToNew, null, null, null, false);
        }
        if (samples.length == 2) {
            return new Irregular2DSet((MathType)type, samples, this.newToOld, this.oldToNew, null, null, null, false);
        }
        if (samples.length == 1) {
            return new Irregular1DSet((MathType)type, samples, null, null, null, false);
        }
        throw new SetException("Irregular1DSet.makeSpatial: bad samples length");
    }

    @Override
    public float[][] indexToValue(int[] index) throws VisADException {
        int[] newIndex = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            newIndex[i] = 0 <= index[i] && index[i] < this.Length ? this.oldToNew[index[i]] : -1;
        }
        float[][] value = this.SortedSet.indexToValue(newIndex);
        return value;
    }

    @Override
    public int[] valueToIndex(float[][] value) throws VisADException {
        int[] index = this.SortedSet.valueToIndex(value);
        int[] newIndex = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            newIndex[i] = index[i] == -1 ? -1 : this.newToOld[index[i]];
        }
        return newIndex;
    }

    @Override
    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        this.SortedSet.valueToInterp(value, indices, weights);
        for (int j = 0; j < indices.length; ++j) {
            if (indices[j] == null) continue;
            int[] newIndex = new int[indices[j].length];
            for (int i = 0; i < indices[j].length; ++i) {
                newIndex[i] = this.newToOld[indices[j][i]];
            }
            indices[j] = newIndex;
        }
    }

    public float getLowX() {
        return this.LowX;
    }

    public float getHiX() {
        return this.HiX;
    }

    @Override
    public Object cloneButType(MathType type) throws VisADException {
        return new Irregular1DSet(type, this.getMySamples(), this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] argv) throws VisADException {
        int i;
        float[][] samp = new float[][]{{130.0f, 55.0f, 37.0f, 28.0f, 61.0f, 40.0f, 104.0f, 52.0f, 65.0f, 12.0f}};
        int length = samp[0].length;
        int[] index = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            index[i2] = i2;
        }
        RealType test1 = RealType.getRealType("x");
        RealType[] t_array = new RealType[]{test1};
        RealTupleType t_tuple = new RealTupleType(t_array);
        Irregular1DSet iSet1D = new Irregular1DSet((MathType)t_tuple, samp);
        System.out.println("Samples (indexToValue test):");
        float[][] value = iSet1D.indexToValue(index);
        for (i = 0; i < iSet1D.Length; ++i) {
            System.out.println("#" + i + ":\t" + value[0][i]);
        }
        for (i = 0; i < iSet1D.Length; ++i) {
            System.out.println("#" + i + ":\t" + iSet1D.oldToNew[i] + " " + iSet1D.newToOld[i]);
        }
        System.out.println("\nvalueToIndex test:");
        float[][] value2 = new float[][]{{10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 80.0f, 90.0f, 100.0f, 110.0f, 120.0f, 130.0f}};
        int[] index2 = iSet1D.valueToIndex(value2);
        for (int i3 = 0; i3 < index2.length; ++i3) {
            System.out.println(value2[0][i3] + "\t--> " + index2[i3]);
        }
        System.out.println("\nvalueToInterp test:");
        int[][] indices = new int[value2[0].length][];
        float[][] weights = new float[value2[0].length][];
        iSet1D.valueToInterp(value2, indices, weights);
        for (int i4 = 0; i4 < value2[0].length; ++i4) {
            System.out.print(value2[0][i4] + "\t--> [" + indices[i4][0]);
            for (int j = 1; j < indices[i4].length; ++j) {
                System.out.print(", " + indices[i4][j]);
            }
            System.out.print("]\tweight total: ");
            float total = 0.0f;
            for (int j = 0; j < weights[i4].length; ++j) {
                total += weights[i4][j];
            }
            System.out.println(total);
        }
    }
}

