/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Irregular1DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADTriangleStripArray;

public class UnionSet
extends SampledSet {
    private static final long serialVersionUID = 1L;
    SampledSet[] Sets;

    public UnionSet(MathType type, SampledSet[] sets) throws VisADException {
        this(type, sets, null, null, null, true);
    }

    private UnionSet(MathType type, SampledSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, sets, coord_sys, units, errors, true);
    }

    public UnionSet(MathType type, SampledSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, UnionSet.find_manifold_dim(sets), sets[0].getCoordinateSystem(), sets[0].getSetUnits(), null);
        int i;
        this.DomainDimension = sets[0].DomainDimension;
        if (copy) {
            this.Sets = new SampledSet[sets.length];
            for (i = 0; i < sets.length; ++i) {
                this.Sets[i] = (SampledSet)sets[i].clone();
            }
        } else {
            this.Sets = sets;
        }
        this.Length = 0;
        for (i = 0; i < sets.length; ++i) {
            this.Length += this.Sets[i].Length;
        }
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
        for (i = 0; i < this.DomainDimension; ++i) {
            this.Low[i] = this.Sets[0].Low[i];
            this.Hi[i] = this.Sets[0].Hi[i];
            for (int j = 1; j < sets.length; ++j) {
                if (sets[j].Low[i] < this.Low[i]) {
                    this.Low[i] = sets[j].Low[i];
                }
                if (!(sets[j].Hi[i] > this.Hi[i])) continue;
                this.Hi[i] = sets[j].Hi[i];
            }
        }
    }

    private static int find_manifold_dim(SampledSet[] sets) throws VisADException {
        if (sets == null || sets.length == 0 || sets[0] == null) {
            throw new SetException("UnionSet: Sets cannot be missing");
        }
        if (sets.length < 2) {
            return sets[0].ManifoldDimension;
        }
        int dim = sets[0].DomainDimension;
        int mdim = sets[0].ManifoldDimension;
        CoordinateSystem cs0 = sets[0].getCoordinateSystem();
        Unit[] units0 = sets[0].getSetUnits();
        for (int i = 1; i < sets.length; ++i) {
            if (sets[i] == null) {
                throw new SetException("UnionSet: Sets cannot be missing");
            }
            if (sets[i].DomainDimension != dim) {
                throw new SetException("UnionSet: set #" + i + " Domain dimension is " + sets[i].DomainDimension + ", not " + dim);
            }
            if (sets[i].ManifoldDimension != mdim) {
                throw new SetException("UnionSet: set #" + i + " Manifold dimension is " + sets[i].ManifoldDimension + ", not " + mdim);
            }
            CoordinateSystem cs = sets[i].getCoordinateSystem();
            if (!(cs0 == null && cs == null || cs0 != null && cs != null && cs0.equals(cs))) {
                throw new CoordinateSystemException("UnionSet: Coordinate system #" + i + " (" + (cs == null ? null : cs.getReference()) + " must match #0 " + (cs0 == null ? null : cs0.getReference()));
            }
            Unit[] units = sets[i].getSetUnits();
            if (units0 == null && units == null) continue;
            if (units0 == null || units == null || units0.length != units.length) {
                throw new SetException("UnionSet: Expected " + (units0 == null ? "null" : Integer.toString(units0.length)) + " units for set " + i + ", not " + (units == null ? "null" : Integer.toString(units.length)));
            }
            for (int j = 0; j < units0.length; ++j) {
                if (units0[j] == null && units[j] == null || units0[j] != null && units[j] != null && units0[j].equals(units[j])) continue;
                throw new SetException("UnionSet: Expected set " + i + ", element " + j + " units to be " + units0[j] + " not " + units[j]);
            }
        }
        return mdim;
    }

    public SampledSet[] getSets() {
        return (SampledSet[])this.Sets.clone();
    }

    public UnionSet(SampledSet[] sets) throws VisADException {
        this(sets[0].getType(), sets, null, null, null, true);
    }

    public SampledSet product() throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (this.Sets[i] instanceof GriddedSet || this.Sets[i] instanceof IrregularSet) {
                sets[i] = this.Sets[i];
            } else if (this.Sets[i] instanceof ProductSet) {
                sets[i] = ((ProductSet)this.Sets[i]).product();
            } else if (this.Sets[i] instanceof UnionSet) {
                sets[i] = ((UnionSet)this.Sets[i]).product();
            } else {
                throw new UnimplementedException("UnionSet.product: " + this.Sets[i].getClass());
            }
            if (sets[i] instanceof UnionSet) {
                count += ((UnionSet)sets[i]).Sets.length;
                continue;
            }
            ++count;
        }
        SampledSet[] summands = new SampledSet[count];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (sets[i] instanceof UnionSet) {
                for (int j = 0; j < ((UnionSet)sets[i]).Sets.length; ++j) {
                    summands[k++] = ((UnionSet)sets[i]).Sets[j];
                }
                continue;
            }
            summands[k++] = sets[i];
        }
        return new UnionSet(this.getType(), summands);
    }

    public SampledSet product(SampledSet set) throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        boolean union_of_union = false;
        for (int i = 0; i < n; ++i) {
            if (this.Sets[i] instanceof ProductSet) {
                sets[i] = ((ProductSet)this.Sets[i]).product(set);
                continue;
            }
            if (set instanceof ProductSet) {
                sets[i] = ((ProductSet)set).inverseProduct(this.Sets[i]);
                continue;
            }
            if (set instanceof UnionSet) {
                sets[i] = ((UnionSet)set).inverseProduct(this.Sets[i]);
                union_of_union = true;
                continue;
            }
            sets[i] = new ProductSet(new SampledSet[]{this.Sets[i], set});
        }
        SampledSet union = new UnionSet(sets);
        if (union_of_union) {
            union = union.product();
        }
        return union;
    }

    public SampledSet inverseProduct(SampledSet set) throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        boolean union_of_union = false;
        for (int i = 0; i < n; ++i) {
            if (this.Sets[i] instanceof ProductSet) {
                sets[i] = ((ProductSet)this.Sets[i]).inverseProduct(set);
                continue;
            }
            if (set instanceof ProductSet) {
                sets[i] = ((ProductSet)set).product(this.Sets[i]);
                continue;
            }
            if (set instanceof UnionSet) {
                sets[i] = ((UnionSet)set).product(this.Sets[i]);
                union_of_union = true;
                continue;
            }
            sets[i] = new ProductSet(new SampledSet[]{set, this.Sets[i]});
        }
        SampledSet union = new UnionSet(sets);
        if (union_of_union) {
            union = union.product();
        }
        return union;
    }

    @Override
    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        int n = this.Sets.length;
        int dim = samples.length;
        SampledSet[] sets = new SampledSet[n];
        int base = 0;
        for (int i = 0; i < n; ++i) {
            int len = this.Sets[i].Length;
            float[][] s = new float[dim][len];
            for (int j = 0; j < dim; ++j) {
                for (int k = 0; k < len; ++k) {
                    s[j][k] = samples[j][base + k];
                }
            }
            sets[i] = (SampledSet)this.Sets[i].makeSpatial(type, s);
            base += len;
        }
        UnionSet set = new UnionSet((MathType)((SetType)sets[0].getType()), sets);
        return set;
    }

    @Override
    public void cram_missing(boolean[] range_select) {
        int rl = range_select.length;
        int n = this.Sets.length;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            int len = 0;
            try {
                len = this.Sets[i].getLength();
            }
            catch (VisADException e) {
                return;
            }
            if (k + len > rl) {
                return;
            }
            boolean[] ri = new boolean[len];
            System.arraycopy(range_select, k, ri, 0, len);
            this.Sets[i].cram_missing(ri);
            k += len;
        }
    }

    @Override
    public VisADGeometryArray make2DGeometry(byte[][] color_values, boolean indexed) throws VisADException {
        int dim;
        if (this.DomainDimension != 3) {
            throw new SetException("UnionSet.make2DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new SetException("UnionSet.make2DGeometry: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int n2 = dim = color_values != null ? color_values.length : 0;
        if (indexed) {
            VisADIndexedTriangleStripArray[] arrays = new VisADIndexedTriangleStripArray[n];
            int base = 0;
            for (int i = 0; i < n; ++i) {
                VisADGeometryArray array;
                int len = this.Sets[i].Length;
                byte[][] c = null;
                if (color_values != null) {
                    c = new byte[dim][len];
                    for (int j = 0; j < dim; ++j) {
                        for (int k = 0; k < len; ++k) {
                            c[j][k] = color_values[j][base + k];
                        }
                    }
                }
                arrays[i] = (array = this.Sets[i].make2DGeometry(c, indexed)) instanceof VisADIndexedTriangleStripArray ? (VisADIndexedTriangleStripArray)array : null;
                base += len;
            }
            return VisADIndexedTriangleStripArray.merge(arrays);
        }
        VisADTriangleStripArray[] arrays = new VisADTriangleStripArray[n];
        int base = 0;
        for (int i = 0; i < n; ++i) {
            VisADGeometryArray array;
            int len = this.Sets[i].Length;
            byte[][] c = null;
            if (color_values != null) {
                c = new byte[dim][len];
                for (int j = 0; j < dim; ++j) {
                    for (int k = 0; k < len; ++k) {
                        c[j][k] = color_values[j][base + k];
                    }
                }
            }
            arrays[i] = (array = this.Sets[i].make2DGeometry(c, indexed)) instanceof VisADTriangleStripArray ? (VisADTriangleStripArray)array : null;
            base += len;
        }
        return VisADTriangleStripArray.merge(arrays);
    }

    @Override
    public VisADGeometryArray make1DGeometry(byte[][] color_values) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("UnionSet.make1DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 1) {
            throw new SetException("UnionSet.make1DGeometry: ManifoldDimension must be 1, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int dim = color_values != null ? color_values.length : 0;
        VisADLineStripArray[] arrays = new VisADLineStripArray[n];
        int base = 0;
        for (int i = 0; i < n; ++i) {
            VisADGeometryArray array;
            int len = this.Sets[i].Length;
            byte[][] c = null;
            if (color_values != null) {
                c = new byte[dim][len];
                for (int j = 0; j < dim; ++j) {
                    for (int k = 0; k < len; ++k) {
                        c[j][k] = color_values[j][base + k];
                    }
                }
            }
            arrays[i] = (array = this.Sets[i].make1DGeometry(c)) instanceof VisADLineStripArray ? (VisADLineStripArray)array : null;
            base += len;
        }
        VisADLineStripArray array = VisADLineStripArray.merge(arrays);
        return array;
    }

    @Override
    public VisADGeometryArray[][] makeIsoLines(float[] intervals, float low, float hi, float base, float[] fieldValues, byte[][] color_values, boolean[] swap, boolean dash, boolean fill, ScalarMap[] smap, double[] scale, double label_size, boolean sphericalDisplayCS) throws VisADException {
        int j;
        if (this.DomainDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoLines: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new DisplayException("UnionSet.makeIsoLines: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int dim = color_values.length;
        VisADLineArray[][][] arrays = new VisADLineArray[n][][];
        int kbase = 0;
        for (int i = 0; i < n; ++i) {
            int len = this.Sets[i].Length;
            byte[][] c = new byte[dim][len];
            float[] f = new float[len];
            for (int j2 = 0; j2 < dim; ++j2) {
                for (int k = 0; k < len; ++k) {
                    c[j2][k] = color_values[j2][kbase + k];
                }
            }
            for (int k = 0; k < len; ++k) {
                f[k] = fieldValues[kbase + k];
            }
            arrays[i] = (VisADLineArray[][])this.Sets[i].makeIsoLines(intervals, low, hi, base, f, c, swap, dash, fill, smap, scale, label_size, sphericalDisplayCS);
            kbase += len;
        }
        VisADGeometryArray[][] arrays2 = new VisADLineArray[4][];
        for (j = 0; j < 2; ++j) {
            arrays2[j] = new VisADLineArray[1];
            VisADLineArray[] arrays3 = new VisADLineArray[n];
            for (int i = 0; i < n; ++i) {
                arrays3[i] = arrays[i][j][0];
            }
            arrays2[j][0] = VisADLineArray.merge(arrays3);
        }
        for (j = 2; j < 4; ++j) {
            int i;
            int cnt = 0;
            for (i = 0; i < n; ++i) {
                cnt += arrays[i][j].length;
            }
            arrays2[j] = new VisADLineArray[cnt];
            cnt = 0;
            for (i = 0; i < n; ++i) {
                for (int j2 = 0; j2 < arrays[i][j].length; ++j2) {
                    arrays2[j][cnt++] = arrays[i][j][j2];
                }
            }
        }
        return arrays2;
    }

    @Override
    public VisADGeometryArray makeIsoSurface(float isolevel, float[] fieldValues, byte[][] color_values, boolean indexed) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int dim = color_values.length;
        if (indexed) {
            VisADIndexedTriangleStripArray[] arrays = new VisADIndexedTriangleStripArray[n];
            int base = 0;
            for (int i = 0; i < n; ++i) {
                int len = this.Sets[i].Length;
                byte[][] c = new byte[dim][len];
                float[] f = new float[len];
                for (int j = 0; j < dim; ++j) {
                    for (int k = 0; k < len; ++k) {
                        c[j][k] = color_values[j][base + k];
                    }
                }
                for (int k = 0; k < len; ++k) {
                    f[k] = fieldValues[base + k];
                }
                arrays[i] = (VisADIndexedTriangleStripArray)this.Sets[i].makeIsoSurface(isolevel, f, c, indexed);
                base += len;
            }
            return VisADIndexedTriangleStripArray.merge(arrays);
        }
        VisADTriangleStripArray[] arrays = new VisADTriangleStripArray[n];
        int base = 0;
        for (int i = 0; i < n; ++i) {
            int len = this.Sets[i].Length;
            byte[][] c = new byte[dim][len];
            float[] f = new float[len];
            for (int j = 0; j < dim; ++j) {
                for (int k = 0; k < len; ++k) {
                    c[j][k] = color_values[j][base + k];
                }
            }
            for (int k = 0; k < len; ++k) {
                f[k] = fieldValues[base + k];
            }
            arrays[i] = (VisADTriangleStripArray)this.Sets[i].makeIsoSurface(isolevel, f, c, indexed);
            base += len;
        }
        return VisADTriangleStripArray.merge(arrays);
    }

    @Override
    public float[][] getSamples(boolean copy) throws VisADException {
        int n = this.getLength();
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        return this.indexToValue(indices);
    }

    @Override
    public float[][] indexToValue(int[] index) throws VisADException {
        int i;
        int j;
        int nsets = this.Sets.length;
        int npts = index.length;
        float[][] value = new float[this.DomainDimension][npts];
        if (npts == this.getLength()) {
            boolean ramp = true;
            for (int i2 = 0; i2 < npts; ++i2) {
                if (index[i2] == i2) continue;
                ramp = false;
                break;
            }
            if (ramp) {
                int k = 0;
                for (int j2 = 0; j2 < nsets; ++j2) {
                    int sub_length = this.Sets[j2].getLength();
                    int[] sub_inds = new int[sub_length];
                    for (int i3 = 0; i3 < sub_length; ++i3) {
                        sub_inds[i3] = i3;
                    }
                    float[][] sub_vals = this.Sets[j2].indexToValue(sub_inds);
                    for (int m = 0; m < this.DomainDimension; ++m) {
                        System.arraycopy(sub_vals[m], 0, value[m], k, sub_length);
                    }
                    k += sub_length;
                }
                return value;
            }
        }
        int[][] subindex = new int[nsets][];
        int[] ind_lens = new int[nsets];
        int[] set_num = new int[npts];
        int[] new_ind = new int[npts];
        for (j = 0; j < npts; ++j) {
            int curind;
            int q = 0;
            for (curind = index[j]; q < nsets && curind >= this.Sets[q].Length; curind -= this.Sets[q++].Length) {
            }
            if (q == nsets) {
                curind += this.Sets[--q].Length;
            }
            int n = q;
            ind_lens[n] = ind_lens[n] + 1;
            set_num[j] = q;
            new_ind[j] = curind;
        }
        for (int i4 = 0; i4 < nsets; ++i4) {
            subindex[i4] = ind_lens[i4] > 0 ? new int[ind_lens[i4]] : null;
            ind_lens[i4] = 0;
        }
        for (j = 0; j < npts; ++j) {
            int n = set_num[j];
            int n2 = ind_lens[n];
            ind_lens[n] = n2 + 1;
            subindex[set_num[j]][n2] = new_ind[j];
        }
        float[][][] subvals = new float[nsets][][];
        for (i = 0; i < nsets; ++i) {
            if (subindex[i] == null) continue;
            subvals[i] = this.Sets[i].indexToValue(subindex[i]);
        }
        for (i = 0; i < nsets; ++i) {
            ind_lens[i] = 0;
        }
        for (int j3 = 0; j3 < npts; ++j3) {
            for (int k = 0; k < this.DomainDimension; ++k) {
                value[k][j3] = subvals[set_num[j3]][k][ind_lens[set_num[j3]]];
            }
            int n = set_num[j3];
            ind_lens[n] = ind_lens[n] + 1;
        }
        return value;
    }

    @Override
    public int[] valueToIndex(float[][] value) throws VisADException {
        int nsets = this.Sets.length;
        int npts = value[0].length;
        int[] index = new int[npts];
        int[][] subindex = new int[nsets][];
        for (int i = 0; i < nsets; ++i) {
            subindex[i] = this.Sets[i].valueToIndex(value);
        }
        float[][][] subvalue = new float[nsets][][];
        for (int i = 0; i < nsets; ++i) {
            subvalue[i] = this.Sets[i].indexToValue(subindex[i]);
        }
        for (int j = 0; j < npts; ++j) {
            float[] dist_sqr = new float[nsets];
            int best_set = 0;
            for (int i = 0; i < nsets; ++i) {
                dist_sqr[i] = 0.0f;
                for (int k = 0; k < this.DomainDimension; ++k) {
                    if (subindex[i][j] == -1) {
                        dist_sqr[i] = Float.MAX_VALUE;
                        break;
                    }
                    float d = subvalue[i][k][j] - value[k][j];
                    int n = i;
                    dist_sqr[n] = dist_sqr[n] + d * d;
                }
                if (!(dist_sqr[best_set] > dist_sqr[i])) continue;
                best_set = i;
            }
            int ind = subindex[best_set][j];
            while (best_set > 0) {
                ind += this.Sets[--best_set].Length;
            }
            index[j] = ind;
        }
        return index;
    }

    @Override
    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int nsets = this.Sets.length;
        int length = indices.length;
        int offset = 0;
        for (int i = 0; i < nsets; ++i) {
            int[][] temp_indices = new int[length][];
            float[][] temp_weights = new float[length][];
            this.Sets[i].valueToInterp(value, temp_indices, temp_weights);
            for (int j = 0; j < length; ++j) {
                if (indices[j] != null || temp_indices[j] == null) continue;
                int m = temp_indices[j].length;
                indices[j] = new int[m];
                weights[j] = new float[m];
                for (int k = 0; k < m; ++k) {
                    indices[j][k] = temp_indices[j][k] + offset;
                    weights[j][k] = temp_weights[j][k];
                }
            }
            offset += this.Sets[i].getLength();
        }
    }

    @Override
    public Object clone() {
        UnionSet clone = (UnionSet)super.clone();
        if (this.Sets != null) {
            clone.Sets = new SampledSet[this.Sets.length];
            for (int i = 0; i < this.Sets.length; ++i) {
                clone.Sets[i] = (SampledSet)this.Sets[i].clone();
            }
        }
        return clone;
    }

    @Override
    public Object cloneButType(MathType type) throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        for (int i = 0; i < n; ++i) {
            sets[i] = (SampledSet)this.Sets[i].cloneButType(type);
        }
        return new UnionSet(type, sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    @Override
    public boolean equals(Object set) {
        if (!(set instanceof UnionSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        UnionSet uset = (UnionSet)set;
        if (uset.DomainDimension != this.DomainDimension || uset.ManifoldDimension != this.ManifoldDimension) {
            return false;
        }
        if (this.Sets.length != uset.Sets.length) {
            return false;
        }
        for (int i = 0; i < this.Sets.length; ++i) {
            if (this.Sets[i].equals(uset.Sets[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.DomainDimension ^ this.ManifoldDimension;
            for (int i = 0; i < this.Sets.length; ++i) {
                this.hashCode ^= this.Sets[i].hashCode();
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    @Override
    public boolean isMissing() {
        for (int i = 0; i < this.Sets.length; ++i) {
            if (!this.Sets[i].isMissing()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] argv) throws VisADException {
        RealType vis_xcoord = RealType.getRealType("1D");
        RealType[] vis_array = new RealType[]{vis_xcoord};
        RealTupleType vis_tuple = new RealTupleType(vis_array);
        float[][] sampG = new float[][]{{2.0f, 4.0f, 6.0f, 8.0f, 10.0f, 12.0f, 14.0f, 16.0f}};
        Gridded1DSet gSet = new Gridded1DSet((MathType)vis_tuple, (float[][])sampG, 8);
        float[][] sampI = new float[][]{{100.0f, 90.0f, 110.0f, 80.0f, 120.0f, 70.0f, 130.0f, 60.0f}};
        Irregular1DSet iSet = new Irregular1DSet((MathType)vis_tuple, sampI);
        SampledSet[] sets = new SampledSet[]{gSet, iSet};
        UnionSet uSet = new UnionSet((MathType)vis_tuple, sets);
        System.out.println("UnionSet created.");
        System.out.println("ManifoldDimension = " + uSet.getManifoldDimension());
        System.out.println("-----------------");
        System.out.println("indexToValue test:");
        int[] index1 = new int[]{0, 3, 9, 12, 6, 15};
        float[][] value1 = uSet.indexToValue(index1);
        for (int i = 0; i < index1.length; ++i) {
            System.out.print("index " + index1[i] + " \t==> (" + value1[0][i]);
            for (int j = 1; j < value1.length; ++j) {
                System.out.print(", " + value1[j][i]);
            }
            System.out.println(")");
        }
        System.out.println("-----------------");
        System.out.println("valueToIndex test:");
        float[][] value2 = new float[][]{{15.0f, 40.0f, 92.0f, 25.0f, 50.0f, 103.0f, 37.0f, 77.0f}};
        int[] index2 = uSet.valueToIndex(value2);
        for (int i = 0; i < index2.length; ++i) {
            System.out.print("(" + value2[0][i]);
            for (int j = 1; j < value2.length; ++j) {
                System.out.print(", " + value2[j][i]);
            }
            System.out.println(")\t==> index " + index2[i]);
        }
        System.out.println("-----------------");
        System.out.println("valueToInterp test:");
        int n = value2[0].length;
        int[][] indices = new int[n][];
        float[][] weights = new float[n][];
        uSet.valueToInterp(value2, indices, weights);
        for (int i = 0; i < n; ++i) {
            System.out.print("(" + value2[0][i]);
            for (int j = 1; j < value2.length; ++j) {
                System.out.print(", " + value2[j][i]);
            }
            System.out.print(")\t==>");
            if (indices[i] == null || indices[i].length == 0) {
                System.out.println(" missing");
                continue;
            }
            int m = indices[i].length;
            for (int j = 0; j < m; ++j) {
                System.out.print(" (" + indices[i][j] + "," + weights[i][j] + ")");
            }
            System.out.println(" ");
        }
        System.out.println();
    }

    @Override
    public String longString(String pre) throws VisADException {
        String s = pre + "UnionSet: Dimension = " + this.DomainDimension + " Length = " + this.getLength() + "\n";
        int n = this.Sets.length;
        for (int i = 0; i < n; ++i) {
            s = s + this.Sets[i].toString();
        }
        return s;
    }
}

