/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BadMappingException;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataShadow;
import visad.DisplayException;
import visad.DisplayInterruptException;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.ShadowType;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.VisADGroup;
import visad.cluster.NodeAgent;
import visad.cluster.NodeDisplayRendererJ3D;
import visad.cluster.ShadowNodeFunctionTypeJ3D;
import visad.cluster.ShadowNodeRealTupleTypeJ3D;
import visad.cluster.ShadowNodeRealTypeJ3D;
import visad.cluster.ShadowNodeSetTypeJ3D;
import visad.cluster.ShadowNodeTupleTypeJ3D;
import visad.collab.CollabUtil;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.util.Delay;

public class NodeRendererJ3D
extends DefaultRendererJ3D {
    private NodeAgent agent = null;
    private boolean enable_transform = false;
    private int resolution = 1;

    public NodeRendererJ3D() {
        this(null);
    }

    public NodeRendererJ3D(NodeAgent a) {
        this.agent = a;
    }

    @Override
    public ShadowType makeShadowFunctionType(FunctionType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowNodeFunctionTypeJ3D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowRealTupleType(RealTupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowNodeRealTupleTypeJ3D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowRealType(RealType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowNodeRealTypeJ3D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowSetType(SetType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowNodeSetTypeJ3D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowTupleType(TupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowNodeTupleTypeJ3D(type, link, parent);
    }

    public void setResolution(int r) {
        this.resolution = r;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void enableTransform() {
        this.enable_transform = true;
    }

    @Override
    public DataShadow prepareAction(boolean go, boolean initialize, DataShadow shadow) throws VisADException, RemoteException {
        return super.prepareAction(go, false, shadow);
    }

    @Override
    public boolean doAction() throws VisADException, RemoteException {
        boolean all_feasible = this.get_all_feasible();
        boolean any_changed = this.get_any_changed();
        boolean any_transform_control = this.get_any_transform_control();
        if (all_feasible && (any_changed || any_transform_control)) {
            boolean branch = false;
            this.clearAVControls();
            try {
                branch = this.fakeTransform();
            }
            catch (OutOfMemoryError e) {
                branch = false;
                new Delay(250);
                Runtime.getRuntime().gc();
                Runtime.getRuntime().runFinalization();
                try {
                    branch = this.fakeTransform();
                }
                catch (BadMappingException ee) {
                    this.addException(ee);
                }
                catch (UnimplementedException ee) {
                    this.addException(ee);
                    branch = false;
                }
                catch (RemoteException ee) {
                    this.addException(ee);
                    branch = false;
                }
                catch (DisplayInterruptException ee) {
                    branch = false;
                }
            }
            catch (BadMappingException e) {
                this.addException(e);
                branch = false;
            }
            catch (UnimplementedException e) {
                this.addException(e);
                branch = false;
            }
            catch (RemoteException e) {
                this.addException(e);
                branch = false;
            }
            catch (DisplayInterruptException e) {
                branch = false;
            }
            if (!branch) {
                all_feasible = false;
                this.set_all_feasible(all_feasible);
            }
        } else {
            DataDisplayLink[] links = this.getLinks();
            for (int i = 0; i < links.length; ++i) {
                links[i].clearData();
            }
        }
        return all_feasible && (any_changed || any_transform_control);
    }

    public boolean fakeTransform() throws VisADException, RemoteException {
        Data data;
        if (!this.enable_transform) {
            return true;
        }
        this.enable_transform = false;
        VisADGroup branch = new VisADGroup();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            return false;
        }
        DataDisplayLink link = Links[0];
        ShadowTypeJ3D type = (ShadowTypeJ3D)link.getShadow();
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        for (int i = 0; i < valueArrayLength; ++i) {
            valueArray[i] = Float.NaN;
        }
        try {
            data = link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, link);
                this.removeLink(link);
                return false;
            }
            throw re;
        }
        if (data == null) {
            branch = null;
            this.addException(new DisplayException("Data is null: NodeRendererJ3D.doTransform"));
        } else {
            boolean post_process;
            link.start_time = System.currentTimeMillis();
            link.time_flag = false;
            type.preProcess();
            try {
                post_process = type.doTransform(branch, data, valueArray, link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, link);
                    this.removeLink(link);
                    return false;
                }
                throw re;
            }
            if (post_process) {
                type.postProcess(branch);
            }
        }
        link.clearData();
        if (this.agent != null) {
            this.agent.sendToClient(branch);
            System.out.println("scene graph sent to client");
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("NodeRendererJ3D");
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        DisplayImplJ3D display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new NodeDisplayRendererJ3D(), 4);
        JFrame frame = new JFrame("test NodeRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

