/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataShadow;
import visad.Field;
import visad.FieldImpl;
import visad.Function;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodeField;

public class RemoteNodeFieldImpl
extends RemoteNodeDataImpl
implements RemoteNodeField {
    private Field adaptedField = null;
    private int length;

    public RemoteNodeFieldImpl(FunctionType type, Set set) throws VisADException, RemoteException {
        if (type == null) {
            throw new ClusterException("type cannot be null");
        }
        if (set == null) {
            throw new ClusterException("set cannot be null");
        }
        this.adaptedField = new FieldImpl(type, set);
        this.length = set.getLength();
    }

    public RemoteNodeFieldImpl(FieldImpl field) throws VisADException, RemoteException {
        if (field == null) {
            throw new ClusterException("field cannot be null");
        }
        this.adaptedField = field;
    }

    public void setSamples(RemoteNodeDataImpl[] range) throws VisADException, RemoteException {
        this.setSamples(range, false);
    }

    @Override
    public void setSamples(Data[] range, boolean copy) throws VisADException, RemoteException {
        int i;
        if (range == null) {
            throw new ClusterException("range cannot be null");
        }
        if (range.length != this.length) {
            throw new ClusterException("range length must match set length");
        }
        for (i = 0; i < range.length; ++i) {
            if (range[i] instanceof RemoteNodeDataImpl) continue;
            throw new ClusterException("range values must be RemoteNodeDataImpl");
        }
        this.adaptedField.setSamples(range, false);
        for (i = 0; i < this.length; ++i) {
            ((RemoteNodeDataImpl)range[i]).setParent(this);
        }
    }

    @Override
    public void setSamples(double[][] range) throws VisADException, RemoteException {
        throw new ClusterException("no setSamples(double[][]) method");
    }

    @Override
    public void setSamples(float[][] range) throws VisADException, RemoteException {
        throw new ClusterException("no setSamples(float[][]) method");
    }

    @Override
    public MathType getType() throws VisADException, RemoteException {
        return this.adaptedField.getType();
    }

    @Override
    public boolean isMissing() throws VisADException, RemoteException {
        return this.adaptedField.isMissing();
    }

    @Override
    public int getDomainDimension() throws VisADException, RemoteException {
        return this.adaptedField.getDomainDimension();
    }

    @Override
    public Set getDomainSet() throws VisADException, RemoteException {
        return this.adaptedField.getDomainSet();
    }

    @Override
    public int getLength() throws RemoteException {
        return this.length;
    }

    @Override
    public Unit[] getDomainUnits() throws VisADException, RemoteException {
        return this.adaptedField.getDomainUnits();
    }

    @Override
    public CoordinateSystem getDomainCoordinateSystem() throws VisADException, RemoteException {
        return this.adaptedField.getDomainCoordinateSystem();
    }

    @Override
    public Data getSample(int index) throws VisADException, RemoteException {
        return this.adaptedField.getSample(index);
    }

    @Override
    public void setSample(RealTuple domain, Data range, boolean copy) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    @Override
    public void setSample(RealTuple domain, Data range) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    @Override
    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    @Override
    public void setSample(int index, Data range) throws VisADException, RemoteException {
        throw new ClusterException("no setSample() method");
    }

    @Override
    public Field extract(int component) throws VisADException, RemoteException {
        throw new ClusterException("no extract() method");
    }

    @Override
    public Field domainMultiply() throws VisADException, RemoteException {
        throw new ClusterException("no domainMultiply() method");
    }

    @Override
    public Field domainMultiply(int depth) throws VisADException, RemoteException {
        throw new ClusterException("no domainMultiply() method");
    }

    @Override
    public Field domainFactor(RealType factor) throws VisADException, RemoteException {
        throw new ClusterException("no domainFactor() method");
    }

    @Override
    public double[][] getValues() throws VisADException, RemoteException {
        return this.adaptedField.getValues();
    }

    @Override
    public double[][] getValues(boolean copy) throws VisADException, RemoteException {
        return this.adaptedField.getValues(copy);
    }

    @Override
    public float[][] getFloats() throws VisADException, RemoteException {
        return this.adaptedField.getFloats();
    }

    @Override
    public float[][] getFloats(boolean copy) throws VisADException, RemoteException {
        return this.adaptedField.getFloats(copy);
    }

    @Override
    public String[][] getStringValues() throws VisADException, RemoteException {
        return this.adaptedField.getStringValues();
    }

    @Override
    public Unit[] getDefaultRangeUnits() throws VisADException, RemoteException {
        return this.adaptedField.getDefaultRangeUnits();
    }

    @Override
    public Unit[][] getRangeUnits() throws VisADException, RemoteException {
        return this.adaptedField.getRangeUnits();
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem() throws VisADException, RemoteException {
        return this.adaptedField.getRangeCoordinateSystem();
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem(int i) throws VisADException, RemoteException {
        return this.adaptedField.getRangeCoordinateSystem(i);
    }

    @Override
    public boolean isFlatField() throws VisADException, RemoteException {
        return false;
    }

    @Override
    public Enumeration domainEnumeration() throws VisADException, RemoteException {
        return this.adaptedField.domainEnumeration();
    }

    @Override
    public Data evaluate(Real domain) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    @Override
    public Data evaluate(Real domain, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    @Override
    public Data evaluate(RealTuple domain) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    @Override
    public Data evaluate(RealTuple domain, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no evaluate() method");
    }

    @Override
    public Field resample(Set set) throws VisADException, RemoteException {
        throw new ClusterException("no resample() method");
    }

    @Override
    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no resample() method");
    }

    @Override
    public Data derivative(RealTuple location, RealType[] d_partial_s, MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    @Override
    public Data derivative(int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    @Override
    public Data derivative(MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    @Override
    public Function derivative(RealType d_partial, int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    @Override
    public Function derivative(RealType d_partial, MathType derivType, int error_mode) throws VisADException, RemoteException {
        throw new ClusterException("no derivative() method");
    }

    @Override
    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        return this.adaptedField.computeRanges(type, shadow);
    }

    @Override
    public DataShadow computeRanges(ShadowType type, int n) throws VisADException, RemoteException {
        return this.adaptedField.computeRanges(type, n);
    }

    @Override
    public double[][] computeRanges(RealType[] reals) throws VisADException, RemoteException {
        throw new ClusterException("no computeRanges(RealType[]) method");
    }

    @Override
    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.adjustSamplingError(error, error_mode);
    }

    @Override
    public String longString() throws VisADException, RemoteException {
        return this.longString("");
    }

    @Override
    public String longString(String pre) throws VisADException, RemoteException {
        return pre + "RemoteNodeFieldImpl";
    }
}

