/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CellImpl;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteData;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.cluster.ClientRendererJ3D;
import visad.cluster.ClusterException;
import visad.cluster.RemoteClientFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeField;
import visad.cluster.RemoteNodeFieldImpl;
import visad.cluster.RemoteProxyAgent;
import visad.cluster.RemoteProxyAgentImpl;
import visad.cluster.UserDisplayRendererJ3D;
import visad.cluster.UserDummyDataImpl;
import visad.data.netcdf.Plain;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.ss.FancySSCell;
import visad.ss.SSCellData;

public class TestProxyCluster
extends FancySSCell
implements ActionListener {
    private RemoteDataReferenceImpl remote_ref = null;
    private RemoteProxyAgent agent = null;
    int[] res = new int[]{1, 1, 1, 1};

    public TestProxyCluster(String name, Frame parent, RemoteProxyAgent a) throws VisADException, RemoteException {
        super(name, parent);
        this.agent = a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String addData(int id, Data data, ConstantMap[] cmaps, String source, int type, boolean notify) throws VisADException, RemoteException {
        SSCellData cellData;
        DataReferenceImpl ref = new DataReferenceImpl(this.Name);
        if (data instanceof RemoteData) {
            this.remote_ref = new RemoteDataReferenceImpl(ref);
            this.remote_ref.setData(data);
        } else {
            ref.setData(data);
        }
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.addReferenceImpl(id, ref, cmaps, source, type, notify, true);
        }
        return cellData.getVariableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SSCellData addReferenceImpl(int id, DataReferenceImpl ref, ConstantMap[] cmaps, String source, int type, boolean notify, boolean checkErrors) throws VisADException, RemoteException {
        if (id == 0) {
            id = this.getFirstFreeId();
        }
        if (ref == null) {
            ref = new DataReferenceImpl(this.Name);
        }
        SSCellData cellData = new SSCellData(id, this, ref, cmaps, source, type, checkErrors);
        this.CellData.add(cellData);
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.addReference(ref, cmaps);
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl remoteRef = cellData.getRemoteReference();
                int len = this.Servers.size();
                for (int i = 0; i < len; ++i) {
                    RemoteServerImpl rs = (RemoteServerImpl)this.Servers.elementAt(i);
                    rs.addDataReference(remoteRef);
                }
            }
        }
        return cellData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setMaps(ScalarMap[] maps) throws VisADException, RemoteException {
        if (maps == null) {
            return;
        }
        VisADException vexc = null;
        RemoteException rexc = null;
        if (!this.IsRemote) {
            int i;
            ConstantMap[][] cmaps;
            DataReference[] dr;
            Vector vector = this.CellData;
            synchronized (vector) {
                int len = this.CellData.size();
                dr = new DataReference[len];
                cmaps = new ConstantMap[len][];
                for (int i2 = 0; i2 < len; ++i2) {
                    SSCellData cellData = (SSCellData)this.CellData.elementAt(i2);
                    dr[i2] = cellData.getReference();
                    cmaps[i2] = cellData.getConstantMaps();
                }
            }
            String save = this.getPartialSaveString();
            this.VDisplay.disableAction();
            this.clearMaps();
            for (i = 0; i < maps.length; ++i) {
                if (maps[i] == null) continue;
                try {
                    this.VDisplay.addMap(maps[i]);
                    continue;
                }
                catch (VisADException exc) {
                    vexc = exc;
                    continue;
                }
                catch (RemoteException exc) {
                    rexc = exc;
                }
            }
            for (i = 0; i < dr.length; ++i) {
                boolean ok;
                block18: {
                    ok = false;
                    Data data = dr[i].getData();
                    if (data != null && Possible3D) {
                        MathType type = data.getType();
                        try {
                            ok = ImageRendererJ3D.isRendererUsable(type, maps);
                        }
                        catch (VisADException exc) {
                            if (!DEBUG || DEBUG_LEVEL < 3) break block18;
                            exc.printStackTrace();
                        }
                    }
                }
                if (ok && this.Dim != 2) {
                    this.VDisplay.addReferences((DataRenderer)new ImageRendererJ3D(), dr[i], cmaps[i]);
                    continue;
                }
                if (this.remote_ref == null) {
                    this.VDisplay.addReference(dr[i], cmaps[i]);
                    continue;
                }
                this.RemoteVDisplay.addReference(this.remote_ref, cmaps[i]);
            }
            this.VDisplay.enableAction();
            this.setPartialSaveString(save, true);
        }
        this.HasMappings = true;
        if (vexc != null) {
            throw vexc;
        }
        if (rexc != null) {
            throw rexc;
        }
    }

    @Override
    public synchronized boolean constructDisplay() {
        boolean success = true;
        DisplayImpl newDisplay = this.VDisplay;
        RemoteDisplay rmtDisplay = this.RemoteVDisplay;
        if (this.IsSlave) {
            try {
                newDisplay = new DisplayImplJ2D("DUMMY");
            }
            catch (VisADException exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
            catch (RemoteException exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
        } else if (!CanDo3D && this.Dim != 2) {
            success = false;
        } else {
            try {
                TwoDDisplayRendererJ3D tdr;
                if (this.IsRemote) {
                    if (this.Dim == 1) {
                        newDisplay = new DisplayImplJ3D(rmtDisplay);
                    } else if (this.Dim == 2) {
                        newDisplay = new DisplayImplJ2D(rmtDisplay);
                    } else {
                        tdr = new TwoDDisplayRendererJ3D();
                        newDisplay = new DisplayImplJ3D(rmtDisplay, (DisplayRendererJ3D)tdr);
                    }
                } else {
                    if (this.Dim == 1) {
                        UserDisplayRendererJ3D udr = new UserDisplayRendererJ3D(this.agent, 100000L);
                        newDisplay = new DisplayImplJ3D(this.Name, (DisplayRendererJ3D)udr);
                    } else if (this.Dim == 2) {
                        newDisplay = new DisplayImplJ2D(this.Name);
                    } else {
                        tdr = new TwoDDisplayRendererJ3D();
                        newDisplay = new DisplayImplJ3D(this.Name, (DisplayRendererJ3D)tdr);
                    }
                    rmtDisplay = new RemoteDisplayImpl(newDisplay);
                }
            }
            catch (NoClassDefFoundError err) {
                if (DEBUG) {
                    err.printStackTrace();
                }
                success = false;
            }
            catch (UnsatisfiedLinkError err) {
                if (DEBUG) {
                    err.printStackTrace();
                }
                success = false;
            }
            catch (Exception exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
        }
        if (success) {
            block32: {
                if (this.VDisplay != null) {
                    try {
                        this.VDisplay.destroy();
                    }
                    catch (VisADException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!DEBUG) break block32;
                        exc.printStackTrace();
                    }
                }
            }
            this.VDisplay = newDisplay;
            this.RemoteVDisplay = rmtDisplay;
        }
        return success;
    }

    public static void main(String[] args) throws RemoteException, VisADException, IOException {
        boolean user;
        int node_divide = 2;
        int number_of_nodes = node_divide * node_divide;
        RemoteNodeField[] node_wrfs = new RemoteNodeField[number_of_nodes];
        if (args == null || args.length < 1) {
            System.out.println("usage: 'java visad.cluster.TestProxyCluster n file'");
            System.out.println("            for nodes where n = 1 - " + number_of_nodes);
            System.out.println("       'java visad.cluster.TestProxyCluster 0 node1 node2 node3 node4' for host");
            System.out.println("       'java visad.cluster.TestProxyCluster 5 host' for user");
            System.exit(0);
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("usage: 'java visad.cluster.TestProxyCluster n file'");
            System.out.println("            for nodes where n = 1 - " + number_of_nodes);
            System.out.println("       'java visad.cluster.TestProxyCluster 0 node1 node2 node3 node4' for host");
            System.out.println("       'java visad.cluster.TestProxyCluster 5 host' for user");
            System.exit(0);
        }
        if (pid < 0 || pid > number_of_nodes + 1) {
            System.out.println("usage: 'java visad.cluster.TestProxyCluster n file'");
            System.out.println("            for nodes where n = 1 - " + number_of_nodes);
            System.out.println("       'java visad.cluster.TestProxyCluster 0 node1 node2 node3 node4' for host");
            System.out.println("       'java visad.cluster.TestProxyCluster 5 host' for user");
            System.exit(0);
        }
        if (pid > 0 && pid <= number_of_nodes && args.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestProxyCluster n file'");
            System.out.println("            for nodes where n = 1 - " + number_of_nodes);
            System.out.println("       'java visad.cluster.TestProxyCluster 0 node1 node2 node3 node4' for host");
            System.out.println("       'java visad.cluster.TestProxyCluster 5 host' for user");
            System.exit(0);
        }
        boolean host = pid == 0;
        boolean bl = user = pid == number_of_nodes + 1;
        if (!host && !user) {
            Plain plain = new Plain();
            FieldImpl wrf = (FieldImpl)plain.open(args[1]);
            if (wrf == null) {
                System.out.println("cannot open " + args[1]);
                return;
            }
            FunctionType wrf_type = (FunctionType)wrf.getType();
            System.out.println("wrf_type = " + wrf_type);
            Set time_set = wrf.getDomainSet();
            int time_length = time_set.getLength();
            RealTupleType wrf_domain_type = wrf_type.getDomain();
            RealType time_type = (RealType)wrf_domain_type.getComponent(0);
            TupleType wrf_range_type = (TupleType)wrf_type.getRange();
            FunctionType wrf_non_stag_type = (FunctionType)wrf_range_type.getComponent(3);
            RealTupleType wrf_non_stag_domain_type = wrf_non_stag_type.getDomain();
            RealTupleType wrf_non_stag_Range_type = (RealTupleType)wrf_non_stag_type.getRange();
            FunctionType wrf_surface_type = (FunctionType)wrf_range_type.getComponent(5);
            RealTupleType nav_wrf_grid_domain_type = RealTupleType.SpatialEarth3DTuple;
            FunctionType nav_wrf_grid_type = new FunctionType(nav_wrf_grid_domain_type, wrf_non_stag_Range_type);
            FunctionType nav_wrf_type = new FunctionType(time_type, nav_wrf_grid_type);
            FieldImpl nav_wrf = new FieldImpl(nav_wrf_type, time_set);
            Gridded3DSet nav_grid_set = null;
            int nrows = 0;
            int ncols = 0;
            int nlevs = 0;
            int grid_size = 0;
            boolean nvert = false;
            for (int i = 0; i < time_length; ++i) {
                Tuple wrf_step = (Tuple)wrf.getSample(i);
                FlatField wrf_non_stag = (FlatField)wrf_step.getComponent(3);
                FlatField wrf_surface = (FlatField)wrf_step.getComponent(5);
                FlatField wrf_vert = (FlatField)wrf_step.getComponent(6);
                float[][] wrf_vert_samples = wrf_vert.getFloats(false);
                Gridded3DSet wrf_grid_set = (Gridded3DSet)wrf_non_stag.getDomainSet();
                ncols = wrf_grid_set.getLength(0);
                nrows = wrf_grid_set.getLength(1);
                nlevs = wrf_grid_set.getLength(2);
                float[][] wrf_surface_samples = wrf_surface.getFloats(false);
                float[] lats = wrf_surface_samples[9];
                float[] lons = wrf_surface_samples[10];
                if (lats.length != nrows * ncols) {
                    throw new ClusterException("lats.length = " + lats.length + " != " + nrows + " * " + ncols);
                }
                float[][] range_values = wrf_non_stag.getFloats(false);
                grid_size = nrows * ncols * nlevs;
                float[][] nav_wrf_samples = new float[3][grid_size];
                nav_wrf_samples[0] = new float[grid_size];
                nav_wrf_samples[1] = new float[grid_size];
                for (int lev = 0; lev < nlevs; ++lev) {
                    int base = lev * nrows * ncols;
                    for (int rc = 0; rc < nrows * ncols; ++rc) {
                        nav_wrf_samples[0][base + rc] = lons[rc];
                        nav_wrf_samples[1][base + rc] = lats[rc];
                    }
                }
                nav_wrf_samples[2] = range_values[11];
                nav_grid_set = new Gridded3DSet(nav_wrf_grid_domain_type, nav_wrf_samples, ncols, nrows, nlevs, null, null, null, false, false);
                FlatField nav_wrf_grid = new FlatField(nav_wrf_grid_type, nav_grid_set);
                nav_wrf_grid.setSamples(range_values, false);
                nav_wrf.setSample(i, (Data)nav_wrf_grid);
                System.out.println("done with time step " + i);
            }
            System.out.println("pid = " + pid);
            RemoteNodeFieldImpl node_data = new RemoteNodeFieldImpl(nav_wrf);
            int kk = pid - 1;
            System.out.println("kk = " + kk);
            String url = "///TestProxyCluster" + kk;
            try {
                Naming.rebind(url, node_data);
            }
            catch (Exception e) {
                System.out.println("rebind " + kk + " " + e);
                return;
            }
            CellImpl cell = new CellImpl(){

                @Override
                public void doAction() throws VisADException, RemoteException {
                }
            };
            System.out.println("data ready as " + nav_wrf_type);
            return;
        }
        if (host) {
            int i;
            if (args.length != 5) {
                System.out.println("usage: 'java visad.cluster.TestProxyCluster n file'");
                System.out.println("            for nodes where n = 1 - " + number_of_nodes);
                System.out.println("       'java visad.cluster.TestProxyCluster 0 node1 node2 node3 node4' for host");
                System.out.println("       'java visad.cluster.TestProxyCluster 5 host' for user");
                System.exit(0);
            }
            for (int k = 0; k < number_of_nodes; ++k) {
                String url = "//" + args[1 + k] + "/TestProxyCluster" + k;
                try {
                    node_wrfs[k] = (RemoteNodeField)Naming.lookup(url);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("lookup " + k + " " + e);
                    return;
                }
            }
            FunctionType nav_wrf_type = (FunctionType)node_wrfs[0].getType();
            Set time_set = node_wrfs[0].getDomainSet();
            RemoteClientFieldImpl host_wrf = new RemoteClientFieldImpl(nav_wrf_type, time_set);
            RemoteClusterData[] table = new RemoteClusterData[number_of_nodes + 1];
            for (i = 0; i < number_of_nodes; ++i) {
                table[i] = node_wrfs[i];
            }
            table[number_of_nodes] = host_wrf;
            for (i = 0; i < table.length; ++i) {
                table[i].setupClusterData(null, table);
            }
            RemoteProxyAgentImpl rpai = new RemoteProxyAgentImpl(host_wrf);
            String url = "///TestProxyCluster_Proxy";
            try {
                Naming.rebind(url, rpai);
            }
            catch (Exception e) {
                System.out.println("rebind proxy " + e);
                return;
            }
            CellImpl cell = new CellImpl(){

                @Override
                public void doAction() throws VisADException, RemoteException {
                }
            };
            System.out.println("data ready as " + nav_wrf_type);
        }
        if (user) {
            if (args.length != 2) {
                System.out.println("usage: 'java visad.cluster.TestProxyCluster n file'");
                System.out.println("            for nodes where n = 1 - " + number_of_nodes);
                System.out.println("       'java visad.cluster.TestProxyCluster 0 node1 node2 node3 node4' for host");
                System.out.println("       'java visad.cluster.TestProxyCluster 5 host' for user");
                System.exit(0);
            }
            String url = "//" + args[1] + "/TestProxyCluster_Proxy";
            RemoteProxyAgent rpa = null;
            try {
                rpa = (RemoteProxyAgent)Naming.lookup(url);
            }
            catch (Exception e) {
                System.out.println("lookup proxy " + e);
                return;
            }
            UserDummyDataImpl user_wrf = new UserDummyDataImpl(rpa.getRemoteClientData());
            JFrame frame = new JFrame("test UserRendererJ3D");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            TestProxyCluster ss = new TestProxyCluster("TestProxyCluster", frame, rpa);
            ss.addData(user_wrf);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            frame.getContentPane().add(panel);
            JPanel bpanel = new JPanel();
            bpanel.setLayout(new BoxLayout(bpanel, 0));
            JButton maps = new JButton("Maps");
            maps.addActionListener(ss);
            maps.setActionCommand("map");
            bpanel.add(maps);
            JButton show = new JButton("Widgets");
            show.addActionListener(ss);
            show.setActionCommand("widgets");
            bpanel.add(show);
            JButton res1 = new JButton("Res 1");
            res1.addActionListener(ss);
            res1.setActionCommand("res1");
            bpanel.add(res1);
            JButton res2 = new JButton("Res 2");
            res2.addActionListener(ss);
            res2.setActionCommand("res2");
            bpanel.add(res2);
            JButton res3 = new JButton("Res 3");
            res3.addActionListener(ss);
            res3.setActionCommand("res3");
            bpanel.add(res3);
            JButton res4 = new JButton("Res 4");
            res4.addActionListener(ss);
            res4.setActionCommand("res4");
            bpanel.add(res4);
            panel.add(ss);
            panel.add(bpanel);
            frame.setSize(600, 600);
            frame.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("map")) {
            this.hideWidgetFrame();
            this.addMapDialog();
        } else if (cmd.equals("widgets")) {
            this.showWidgetFrame();
        } else if (cmd.equals("res1")) {
            this.flipRes(0);
        } else if (cmd.equals("res2")) {
            this.flipRes(1);
        } else if (cmd.equals("res3")) {
            this.flipRes(2);
        } else if (cmd.equals("res4")) {
            this.flipRes(3);
        }
    }

    private void flipRes(int k) {
        this.res[k] = 5 - this.res[k];
        DisplayImpl display = this.getDisplay();
        Vector renderers = display.getRendererVector();
        for (int i = 0; i < renderers.size(); ++i) {
            DataRenderer renderer = (DataRenderer)renderers.elementAt(i);
            if (!(renderer instanceof ClientRendererJ3D)) continue;
            ((ClientRendererJ3D)renderer).setResolutions(this.res);
        }
        display.reDisplayAll();
    }
}

