/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DBoolean;
import dods.dap.DByte;
import dods.dap.DFloat32;
import dods.dap.DFloat64;
import dods.dap.DGrid;
import dods.dap.DInt16;
import dods.dap.DInt32;
import dods.dap.DList;
import dods.dap.DSequence;
import dods.dap.DString;
import dods.dap.DStructure;
import dods.dap.DUInt16;
import dods.dap.DUInt32;
import dods.dap.PrimitiveVector;
import java.rmi.RemoteException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.ArrayVariableAdapter;
import visad.data.dods.BooleanVariableAdapter;
import visad.data.dods.ByteVariableAdapter;
import visad.data.dods.Float32VariableAdapter;
import visad.data.dods.Float64VariableAdapter;
import visad.data.dods.GridVariableAdapter;
import visad.data.dods.GridVariableMapAdapter;
import visad.data.dods.Int16VariableAdapter;
import visad.data.dods.Int32VariableAdapter;
import visad.data.dods.ListVariableAdapter;
import visad.data.dods.SequenceVariableAdapter;
import visad.data.dods.StringVariableAdapter;
import visad.data.dods.StructureVariableAdapter;
import visad.data.dods.UInt16VariableAdapter;
import visad.data.dods.UInt32VariableAdapter;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VectorAdapter;
import visad.data.dods.VectorAdapterFactory;

public class VariableAdapterFactory {
    private static final VariableAdapterFactory instance = new VariableAdapterFactory();
    private static final VectorAdapterFactory vectorAdapterFactory = VectorAdapterFactory.vectorAdapterFactory();

    protected VariableAdapterFactory() {
    }

    public static VariableAdapterFactory variableAdapterFactory() {
        return instance;
    }

    public VariableAdapter variableAdapter(BaseType var, DAS das) throws BadFormException, VisADException, RemoteException {
        VariableAdapter adapter;
        if (var instanceof DString) {
            adapter = this.stringVariableAdapter((DString)var, das);
        } else if (var instanceof DBoolean) {
            adapter = this.booleanVariableAdapter((DBoolean)var, das);
        } else if (var instanceof DByte) {
            adapter = this.byteVariableAdapter((DByte)var, das);
        } else if (var instanceof DUInt16) {
            adapter = this.uInt16VariableAdapter((DUInt16)var, das);
        } else if (var instanceof DInt16) {
            adapter = this.int16VariableAdapter((DInt16)var, das);
        } else if (var instanceof DUInt32) {
            adapter = this.uInt32VariableAdapter((DUInt32)var, das);
        } else if (var instanceof DInt32) {
            adapter = this.int32VariableAdapter((DInt32)var, das);
        } else if (var instanceof DFloat32) {
            adapter = this.float32VariableAdapter((DFloat32)var, das);
        } else if (var instanceof DFloat64) {
            adapter = this.float64VariableAdapter((DFloat64)var, das);
        } else if (var instanceof DStructure) {
            adapter = this.structureVariableAdapter((DStructure)var, das);
        } else if (var instanceof DList) {
            adapter = this.listVariableAdapter((DList)var, das);
        } else if (var instanceof DSequence) {
            adapter = this.sequenceVariableAdapter((DSequence)var, das);
        } else if (var instanceof DArray) {
            adapter = this.arrayVariableAdapter((DArray)var, das);
        } else if (var instanceof DGrid) {
            adapter = this.gridVariableAdapter((DGrid)var, das);
        } else {
            throw new BadFormException(this.getClass().getName() + ".variableAdapter(...): Unknown DODS type: " + var.getTypeName());
        }
        return adapter;
    }

    public StringVariableAdapter stringVariableAdapter(DString var, DAS das) throws VisADException, RemoteException {
        return StringVariableAdapter.stringVariableAdapter(var, das);
    }

    public BooleanVariableAdapter booleanVariableAdapter(DBoolean var, DAS das) throws VisADException, RemoteException {
        return BooleanVariableAdapter.booleanVariableAdapter(var, das);
    }

    public ByteVariableAdapter byteVariableAdapter(DByte var, DAS das) throws VisADException, RemoteException {
        return ByteVariableAdapter.byteVariableAdapter(var, das);
    }

    public UInt16VariableAdapter uInt16VariableAdapter(DUInt16 var, DAS das) throws VisADException, RemoteException {
        return UInt16VariableAdapter.uInt16VariableAdapter(var, das);
    }

    public Int16VariableAdapter int16VariableAdapter(DInt16 var, DAS das) throws VisADException, RemoteException {
        return Int16VariableAdapter.int16VariableAdapter(var, das);
    }

    public UInt32VariableAdapter uInt32VariableAdapter(DUInt32 var, DAS das) throws VisADException, RemoteException {
        return UInt32VariableAdapter.uInt32VariableAdapter(var, das);
    }

    public Int32VariableAdapter int32VariableAdapter(DInt32 var, DAS das) throws VisADException, RemoteException {
        return Int32VariableAdapter.int32VariableAdapter(var, das);
    }

    public Float32VariableAdapter float32VariableAdapter(DFloat32 var, DAS das) throws VisADException, RemoteException {
        return Float32VariableAdapter.float32VariableAdapter(var, das);
    }

    public Float64VariableAdapter float64VariableAdapter(DFloat64 var, DAS das) throws VisADException, RemoteException {
        return Float64VariableAdapter.float64VariableAdapter(var, das);
    }

    public StructureVariableAdapter structureVariableAdapter(DStructure var, DAS das) throws VisADException, RemoteException {
        return StructureVariableAdapter.structureVariableAdapter(var, das, this);
    }

    public ListVariableAdapter listVariableAdapter(DList var, DAS das) throws VisADException, RemoteException {
        return ListVariableAdapter.listVariableAdapter(var, das, this);
    }

    public SequenceVariableAdapter sequenceVariableAdapter(DSequence var, DAS das) throws VisADException, RemoteException {
        return SequenceVariableAdapter.sequenceVariableAdapter(var, das, this);
    }

    public ArrayVariableAdapter arrayVariableAdapter(DArray var, DAS das) throws VisADException, RemoteException {
        return ArrayVariableAdapter.arrayVariableAdapter(var, das, this);
    }

    public GridVariableAdapter gridVariableAdapter(DGrid var, DAS das) throws VisADException, RemoteException {
        return GridVariableAdapter.gridVariableAdapter(var, das, this);
    }

    public GridVariableMapAdapter gridVariableMapAdapter(DArray array, DAS das) throws VisADException, RemoteException {
        return GridVariableMapAdapter.gridVariableMapAdapter(array, das, this);
    }

    public VectorAdapter vectorAdapter(PrimitiveVector vector, DAS das) throws VisADException, RemoteException {
        return vectorAdapterFactory.vectorAdapter(vector, das, this);
    }
}

