/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.ExtensionHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.TruncatedFileException;

public class DumpHeader {
    private static void dumpBasic(PrintStream ps, String indentStr, BasicHDU hdu) {
        double minValue;
        double maxValue;
        String reference;
        String author;
        double equinox;
        String object;
        String observer;
        String instrument;
        String telescope;
        String origin;
        Date observation;
        String bunit;
        double bscale;
        double bzero;
        int groupCount;
        int paramCount;
        int[] axes;
        try {
            String bpName;
            int bitpix = hdu.getBitPix();
            switch (bitpix) {
                case 8: {
                    bpName = "byte";
                    break;
                }
                case 16: {
                    bpName = "short";
                    break;
                }
                case 32: {
                    bpName = "int";
                    break;
                }
                case -32: {
                    bpName = "float";
                    break;
                }
                case -64: {
                    bpName = "double";
                    break;
                }
                default: {
                    bpName = "?" + bitpix + '?';
                }
            }
            ps.println(indentStr + "bitpix " + bpName);
        }
        catch (FitsException e) {
            ps.println(indentStr + "bitpix *** " + e.getMessage());
        }
        try {
            axes = hdu.getAxes();
        }
        catch (FitsException e) {
            System.err.println("Bad axes: " + e.getMessage());
            axes = null;
        }
        if (axes != null) {
            ps.print(indentStr + "axes ");
            for (int i = 0; i < axes.length; ++i) {
                ps.print((i == 0 ? "" : "x") + axes[i]);
            }
            ps.println("");
        }
        if ((paramCount = hdu.getParameterCount()) != 0) {
            ps.println(indentStr + "paramCount " + paramCount);
        }
        if ((groupCount = hdu.getGroupCount()) != 1) {
            ps.println(indentStr + "groupCount " + groupCount);
        }
        if ((bzero = hdu.getBZero()) != 0.0) {
            ps.println(indentStr + "bzero " + bzero);
        }
        if ((bscale = hdu.getBScale()) != 1.0) {
            ps.println(indentStr + "bscale " + bscale);
        }
        if ((bunit = hdu.getBUnit()) != null) {
            ps.println(indentStr + "bunit " + bunit);
        }
        try {
            int blankValue = hdu.getBlankValue();
            ps.println(indentStr + "blank " + blankValue);
        }
        catch (FitsException blankValue) {
            // empty catch block
        }
        Date creation = hdu.getCreationDate();
        if (creation != null) {
            ps.println(indentStr + "creation date " + creation);
        }
        if ((observation = hdu.getObservationDate()) != null) {
            ps.println(indentStr + "observation date " + observation);
        }
        if ((origin = hdu.getOrigin()) != null) {
            ps.println(indentStr + "origin " + origin);
        }
        if ((telescope = hdu.getTelescope()) != null) {
            ps.println(indentStr + "telescope " + telescope);
        }
        if ((instrument = hdu.getInstrument()) != null) {
            ps.println(indentStr + "instrument " + instrument);
        }
        if ((observer = hdu.getObserver()) != null) {
            ps.println(indentStr + "observer " + observer);
        }
        if ((object = hdu.getObject()) != null) {
            ps.println(indentStr + "object " + object);
        }
        if ((equinox = hdu.getEquinox()) != -1.0) {
            ps.println(indentStr + "equinox " + equinox);
        }
        if ((author = hdu.getAuthor()) != null) {
            ps.println(indentStr + "author " + author);
        }
        if ((reference = hdu.getReference()) != null) {
            ps.println(indentStr + "reference " + reference);
        }
        if ((maxValue = hdu.getMaximumValue()) != 0.0) {
            ps.println(indentStr + "maximum value " + maxValue);
        }
        if ((minValue = hdu.getMinimumValue()) != 0.0) {
            ps.println(indentStr + "minimum value " + minValue);
        }
    }

    private static void dumpPrimary(PrintStream ps, String indentStr, PrimaryHDU hdu) throws IOException {
        DumpHeader.dumpBasic(ps, indentStr, (BasicHDU)hdu);
        Data foo = hdu.getData();
    }

    private static void dumpBinaryTable(PrintStream ps, String indentStr, BinaryTableHDU hdu) {
        int num = hdu.getNumColumns();
        if (num == 0) {
            ps.println(indentStr + "No columns");
            return;
        }
        for (int i = 0; i < num; ++i) {
            String type;
            String name;
            try {
                name = hdu.getColumnName(i);
                type = hdu.getColumnFITSType(i);
            }
            catch (FitsException e) {
                break;
            }
            ps.println(indentStr + i + ": " + name + " = " + type);
        }
    }

    private static void dumpExtension(PrintStream ps, String indentStr, ExtensionHDU hdu) throws IOException {
        int level;
        int vers;
        DumpHeader.dumpBasic(ps, indentStr, (BasicHDU)hdu);
        String name = hdu.getExtensionName();
        if (name != null) {
            ps.println(indentStr + "name " + name);
        }
        if ((vers = hdu.getExtensionVersion()) != 1) {
            ps.println(indentStr + "version " + vers);
        }
        if ((level = hdu.getExtensionLevel()) != 1) {
            ps.println(indentStr + "level " + level);
        }
        if (hdu instanceof BinaryTableHDU) {
            ps.println(indentStr + "Binary Table:");
            DumpHeader.dumpBinaryTable(ps, indentStr + indentStr, (BinaryTableHDU)hdu);
        } else {
            try {
                String type = hdu.getExtensionType();
                if (type == null) {
                    ps.println(indentStr + "Null extension type");
                } else {
                    ps.println(indentStr + "type " + type);
                }
            }
            catch (FitsException e) {
                ps.println(indentStr + indentStr + "Bad extension type: " + e.getMessage());
            }
        }
        Data foo = hdu.getData();
    }

    private static void dumpImage(PrintStream ps, String indentStr, ImageHDU hdu) throws IOException {
        DumpHeader.dumpBasic(ps, indentStr, (BasicHDU)hdu);
        ps.println(indentStr + "...");
        Data foo = hdu.getData();
    }

    private static void dumpRandomGroups(PrintStream ps, String indentStr, RandomGroupsHDU hdu) throws IOException {
        DumpHeader.dumpBasic(ps, indentStr, (BasicHDU)hdu);
        ps.println(indentStr + "...");
        Data foo = hdu.getData();
    }

    public static void dump(PrintStream ps, String name) throws FitsException, IOException {
        Fits fits;
        try {
            fits = new Fits(name);
        }
        catch (FitsException e) {
            System.err.println("Couldn't open \"" + name + "\": " + e.getMessage());
            return;
        }
        ps.println(name + ':');
        int hduNum = 0;
        while (true) {
            block19: {
                BasicHDU hdu;
                try {
                    hdu = fits.readHDU();
                }
                catch (OutOfMemoryError e) {
                    System.err.println("  *** Out of memory for HDU #" + hduNum);
                    e.printStackTrace(System.err);
                    break;
                }
                catch (TruncatedFileException e) {
                    System.err.println("  *** File truncated at HDU #" + hduNum + " (" + e.getMessage() + ")");
                    break;
                }
                catch (IOException e) {
                    System.err.println("  *** I/O error at HDU #" + hduNum + " (" + e.getMessage() + ")");
                    break;
                }
                catch (BadHeaderException e) {
                    System.err.println("  *** HDU #" + hduNum + " threw " + e.getMessage());
                    break block19;
                }
                catch (FitsException e) {
                    System.err.println("  *** HDU #" + hduNum + " threw " + e.getMessage());
                    break block19;
                }
                if (hdu == null) break;
                String indentStr = "\t";
                if (hdu instanceof PrimaryHDU) {
                    if (hduNum == 0) {
                        ps.println(indentStr + "Primary:");
                    } else {
                        ps.println(indentStr + "Primary " + hduNum + ':');
                    }
                    ps.flush();
                    DumpHeader.dumpPrimary(ps, indentStr + indentStr, (PrimaryHDU)hdu);
                } else if (hdu instanceof ExtensionHDU) {
                    ps.println(indentStr + "Extension " + hduNum + ':');
                    ps.flush();
                    DumpHeader.dumpExtension(ps, indentStr + indentStr, (ExtensionHDU)hdu);
                } else if (hdu instanceof ImageHDU) {
                    ps.println(indentStr + "Image " + hduNum + ':');
                    ps.flush();
                    DumpHeader.dumpImage(ps, indentStr + indentStr, (ImageHDU)hdu);
                } else if (hdu instanceof RandomGroupsHDU) {
                    ps.println(indentStr + "RandomGroups " + hduNum + ':');
                    ps.flush();
                    DumpHeader.dumpRandomGroups(ps, indentStr + indentStr, (RandomGroupsHDU)hdu);
                } else {
                    throw new FitsException("Unknown header found: " + hdu);
                }
            }
            ++hduNum;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                DumpHeader.dump(System.out, args[i]);
                continue;
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace(System.out);
                continue;
            }
            catch (FitsException e) {
                e.printStackTrace(System.out);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

