/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import visad.DerivedUnit;
import visad.SI;
import visad.Unit;
import visad.UnitException;
import visad.data.units.DefaultUnitsDB;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.SimpleCharStream;
import visad.data.units.Token;
import visad.data.units.UnitParserConstants;
import visad.data.units.UnitParserTokenManager;
import visad.data.units.UnitsDB;

public class UnitParser
implements UnitParserConstants {
    protected static UnitsDB unitsDB = null;
    protected static final Unit SECOND;
    protected static final long julianDayOrigin;
    private static final Unit ONE;
    public UnitParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[34];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[9];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static long julianDay(int year, int month, int day) {
        int jm;
        int jy;
        long igreg = 588829L;
        if (year == 0) {
            year = 1;
        }
        int iy = year;
        if (year < 0) {
            ++iy;
        }
        if (month > 2) {
            jy = iy;
            jm = month + 1;
        } else {
            jy = iy - 1;
            jm = month + 13;
        }
        long julday = day + (int)(30.6001 * (double)jm);
        if (jy >= 0) {
            julday += (long)(365 * jy);
            julday = (long)((double)julday + 0.25 * (double)jy);
        } else {
            double xi = 365.25 * (double)jy;
            if ((double)((int)xi) != xi) {
                xi -= 1.0;
            }
            julday += (long)((int)xi);
        }
        julday += 1720995L;
        if ((long)(day + 31 * (month + 12 * iy)) >= igreg) {
            int ja = jy / 100;
            julday -= (long)ja;
            julday += 2L;
            julday += (long)(ja / 4);
        }
        return julday;
    }

    public static double encodeTimestamp(int year, int month, int day, int hour, int minute, float second, int zone) {
        return (double)(UnitParser.julianDay(year, month, day) - julianDayOrigin) * 86400.0 + (double)((hour * 60 + minute - zone) * 60) + (double)second;
    }

    private static void myAssert(UnitParser parser, String spec, Unit expect) throws UnitException, ParseException {
        if (!parser.parse(spec).equals(expect)) {
            throw new AssertionError((Object)("Got \"" + spec + "; expected \"" + expect + "\""));
        }
        System.out.println(spec + " -> " + expect);
    }

    public Unit parse(String spec) throws ParseException, UnitException {
        this.ReInit(new ByteArrayInputStream(spec.getBytes()));
        return this.unitSpec();
    }

    public static void main(String[] args) throws Exception {
        UnitParser parser = new UnitParser(System.in);
        LineNumberReader lineInput = new LineNumberReader(new InputStreamReader(System.in));
        Unit s = unitsDB.get("s");
        Unit m = unitsDB.get("m");
        Unit kg = unitsDB.get("kg");
        Unit w = unitsDB.get("W");
        Unit epoch = s.shift(UnitParser.encodeTimestamp(1970, 1, 1, 0, 0, 0.0f, 0));
        UnitParser.myAssert(parser, "m m", m.multiply(m));
        UnitParser.myAssert(parser, "m.m", m.multiply(m));
        UnitParser.myAssert(parser, "(m)(m)", m.pow(2));
        UnitParser.myAssert(parser, "m/s/s", m.divide(s).divide(s));
        UnitParser.myAssert(parser, "m2", m.pow(2));
        UnitParser.myAssert(parser, "m2.s", m.pow(2).multiply(s));
        UnitParser.myAssert(parser, "m2/s", m.pow(2).divide(s));
        UnitParser.myAssert(parser, "m^2/s", m.pow(2).divide(s));
        UnitParser.myAssert(parser, "m s @ 5", m.multiply(s).shift(5.0));
        UnitParser.myAssert(parser, "m2 s @ 5", m.pow(2).multiply(s).shift(5.0));
        UnitParser.myAssert(parser, "m2 s-1 @ 5", m.pow(2).divide(s).shift(5.0));
        UnitParser.myAssert(parser, "m s from 5", m.multiply(s).shift(5.0));
        UnitParser.myAssert(parser, "m s kg @ 5", m.multiply(s).multiply(kg).shift(5.0));
        UnitParser.myAssert(parser, "s@19700101", epoch);
        UnitParser.myAssert(parser, "s@19700101T000000", epoch);
        UnitParser.myAssert(parser, "s@19700101T000000.00", epoch);
        UnitParser.myAssert(parser, "s @ 1970-01-01T00:00:00.00", epoch);
        UnitParser.myAssert(parser, "s @ 1970-01-01 00:00:00.00", epoch);
        UnitParser.myAssert(parser, "s @ 1970-01-01T00:00:00.00 -12", s.shift(UnitParser.encodeTimestamp(1970, 1, 1, 12, 0, 0.0f, 0)));
        UnitParser.myAssert(parser, "s @ 1970-01-01T00:00:00.00 -12", s.shift(UnitParser.encodeTimestamp(1970, 1, 1, 0, 0, 0.0f, -720)));
        UnitParser.myAssert(parser, "lg(re: 1)", ONE.log(10.0));
        UnitParser.myAssert(parser, "0.1 lg(re 1 mW)", w.scale(0.001).log(10.0).scale(0.1));
        UnitParser.myAssert(parser, "m", m);
        UnitParser.myAssert(parser, "2 m s", m.multiply(s).scale(2.0));
        UnitParser.myAssert(parser, "3.14 m.s", m.multiply(s).scale(3.14));
        UnitParser.myAssert(parser, "1e9 (m)", m.scale(1.0E9));
        UnitParser.myAssert(parser, "(m s)2", m.multiply(s).pow(2));
        UnitParser.myAssert(parser, "m2.s-1", m.pow(2).divide(s));
        UnitParser.myAssert(parser, "m2 s^-1", m.pow(2).divide(s));
        UnitParser.myAssert(parser, "(m/s)2", m.divide(s).pow(2));
        UnitParser.myAssert(parser, "m2/s-1", m.pow(2).divide(s.pow(-1)));
        UnitParser.myAssert(parser, "m2/s^-1", m.pow(2).divide(s.pow(-1)));
        UnitParser.myAssert(parser, ".5 m/(.25 s)2", m.scale(0.5).divide(s.scale(0.25).pow(2)));
        UnitParser.myAssert(parser, "m.m-1.m", m.multiply(m.pow(-1)).multiply(m));
        UnitParser.myAssert(parser, "2.0 m 1/2 s-1*(m/s^1)^-1 (1e9 m-1)(1e9 s-1)-1.m/s", m.scale(2.0).scale(0.5).multiply(s.pow(-1)).multiply(m.divide(s.pow(1)).pow(-1)).multiply(m.pow(-1).scale(1.0E9)).multiply(s.pow(-1).scale(1.0E9).pow(-1)).multiply(m).divide(s));
        UnitParser.myAssert(parser, "m/km", m.divide(m.scale(1000.0)));
        while (true) {
            System.out.print("Enter a unit specification or ^D to quit: ");
            String spec = lineInput.readLine();
            if (spec == null) break;
            if ((spec = spec.trim()).length() <= 0) continue;
            parser.ReInit(new ByteArrayInputStream(spec.getBytes()));
            try {
                Unit unit = parser.unitSpec();
                System.out.println("unit = " + unit);
                System.out.println("definition = " + unit.getDefinition());
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println("");
    }

    public final Unit unitSpec() throws ParseException, UnitException {
        Unit unit = ONE;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                unit = this.shiftExpr();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        if ("" != null) {
            return unit;
        }
        throw new Error("Missing return statement in function");
    }

    public final Unit shiftExpr() throws ParseException, UnitException {
        Unit unit = this.productExpr();
        if (this.jj_2_1(2)) {
            this.jj_consume_token(15);
            if (Unit.canConvert(unit, SECOND)) {
                double origin = this.timeOriginExpr();
                unit = unit.shift(unit.toThis(origin, SECOND));
            } else {
                double origin = this.number();
                if (origin != 0.0) {
                    unit = unit.shift(origin);
                }
            }
        }
        if ("" != null) {
            return unit;
        }
        throw new Error("Missing return statement in function");
    }

    public final Unit productExpr() throws ParseException, UnitException {
        Unit unit;
        block17: {
            unit = this.powerExpr();
            block14: while (true) {
                Unit unit2;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block17;
                    }
                }
                if (this.jj_2_2(2)) {
                    this.jj_consume_token(14);
                    unit2 = this.powerExpr();
                    unit = unit.divide(unit2);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 12: 
                    case 13: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 1: 
                            case 12: 
                            case 13: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 12: {
                                        this.jj_consume_token(12);
                                        break block6;
                                    }
                                    case 13: {
                                        this.jj_consume_token(13);
                                        break block6;
                                    }
                                    case 1: {
                                        this.jj_consume_token(1);
                                        break block6;
                                    }
                                }
                                this.jj_la1[2] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                            }
                        }
                        unit2 = this.powerExpr();
                        unit = unit.multiply(unit2);
                        continue block14;
                    }
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return unit;
        }
        throw new Error("Missing return statement in function");
    }

    public final Unit powerExpr() throws ParseException, UnitException {
        Unit unit = this.basicExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                int exponent = this.integer();
                unit = unit.pow(exponent);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        if ("" != null) {
            return unit;
        }
        throw new Error("Missing return statement in function");
    }

    public final Unit basicExpr() throws ParseException, UnitException {
        Unit unit;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: 
            case 12: {
                double number = this.number();
                unit = ONE.scale(number);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                unit = this.unitIdentifier();
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                unit = this.logExpr();
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                unit = this.shiftExpr();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return unit;
        }
        throw new Error("Missing return statement in function");
    }

    public final Unit unitIdentifier() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Unit unit = unitsDB.get(token.image);
        if (unit == null) {
            throw new NoSuchUnitException("Unit not in database");
        }
        if ("" != null) {
            return unit;
        }
        throw new Error("Missing return statement in function");
    }

    public final Unit logExpr() throws ParseException, UnitException {
        double base;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                base = 2.0;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                base = Math.E;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                base = 10.0;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Unit ref = this.productExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(9);
        if ("" != null) {
            return ref.log(base);
        }
        throw new Error("Missing return statement in function");
    }

    public final double number() throws ParseException {
        double number;
        if (this.jj_2_3(3)) {
            number = this.real();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 5: {
                    number = this.integer();
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return number;
        }
        throw new Error("Missing return statement in function");
    }

    public final double real() throws ParseException {
        double udecimal;
        int sign = 1;
        double tenFactor = 1.0;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        if (this.jj_2_4(2)) {
            udecimal = this.unsignedDecimal();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    tenFactor = this.tenFactor();
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    udecimal = this.unsignedInteger();
                    tenFactor = this.tenFactor();
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return (double)sign * udecimal * tenFactor;
        }
        throw new Error("Missing return statement in function");
    }

    public final int sign() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                if ("" == null) break;
                return 1;
            }
            case 3: {
                this.jj_consume_token(3);
                if ("" == null) break;
                return -1;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final double unsignedDecimal() throws ParseException {
        int integer = 0;
        double fraction = 0.0;
        if (this.jj_2_5(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    integer = this.unsignedInteger();
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            this.jj_consume_token(12);
            Token token = this.jj_consume_token(5);
            fraction = Double.valueOf("." + token.image);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    integer = this.unsignedInteger();
                    this.jj_consume_token(12);
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return (double)integer + fraction;
        }
        throw new Error("Missing return statement in function");
    }

    public final double tenFactor() throws ParseException {
        Token token = this.jj_consume_token(10);
        if ("" != null) {
            return Double.valueOf("1" + token.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final int integer() throws ParseException {
        int sign = 1;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        int magnitude = this.unsignedInteger();
        if ("" != null) {
            return sign * magnitude;
        }
        throw new Error("Missing return statement in function");
    }

    public final int unsignedInteger() throws ParseException {
        Token token = this.jj_consume_token(5);
        if ("" != null) {
            return Integer.valueOf(token.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final double timeOriginExpr() throws ParseException {
        Calendar calendar = this.dateExpr();
        if (this.jj_2_7(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: {
                    this.jj_consume_token(17);
                    break;
                }
                case 1: {
                    this.jj_consume_token(1);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.clockExpr(calendar);
            if (this.jj_2_6(2)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                this.zoneExpr(calendar);
            }
        }
        if ("" != null) {
            return UnitParser.encodeTimestamp(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), (float)((double)calendar.get(13) + (double)calendar.get(14) / 1000.0), calendar.get(15) / 60000);
        }
        throw new Error("Missing return statement in function");
    }

    public final Calendar dateExpr() throws ParseException {
        int sign = 1;
        int month = 1;
        int day = 1;
        boolean packed = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        int year = this.unsignedInteger();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                month = this.unsignedInteger();
                packed = false;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        this.jj_consume_token(3);
                        day = this.unsignedInteger();
                        break block3;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        if (packed) {
            if (year >= 10000101) {
                day = year % 100;
                year /= 100;
            }
            if (year >= 100001) {
                month = year % 100;
                year /= 100;
            }
            if (sign < 0) {
                year = -year;
            }
        }
        if (month < 1 || month > 12) {
            throw new ParseException("invalid month in timestamp");
        }
        if (day < 1 || day > 31) {
            throw new ParseException("invalid day in timestamp");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(year, month - 1, day);
        if ("" != null) {
            return calendar;
        }
        throw new Error("Missing return statement in function");
    }

    public final Calendar clockExpr(Calendar calendar) throws ParseException {
        double hour;
        int minute = 0;
        double seconds = 0.0;
        boolean packed = true;
        if (this.jj_2_8(2)) {
            hour = this.unsignedDecimal();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    hour = this.unsignedInteger();
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                minute = this.unsignedInteger();
                packed = false;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        if (this.jj_2_9(2)) {
                            seconds = this.unsignedDecimal();
                            break block3;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                seconds = this.unsignedInteger();
                                break block3;
                            }
                        }
                        this.jj_la1[27] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[28] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        if (packed) {
            if (hour >= 100000.0) {
                seconds = hour % 100.0;
                hour /= 100.0;
            }
            if (hour >= 1000.0) {
                minute = (int)(hour % 100.0);
                hour /= 100.0;
            }
        }
        if (hour < 0.0 || hour > 23.0) {
            throw new ParseException("invalid hour in timestamp");
        }
        if (minute < 0 || minute > 59) {
            throw new ParseException("invalid minute in timestamp");
        }
        if (seconds < 0.0 || seconds > 61.0) {
            throw new ParseException("invalid seconds in timestamp");
        }
        calendar.set(11, (int)Math.round(hour));
        calendar.set(12, minute);
        int s = (int)seconds;
        calendar.set(13, s);
        int ms = (int)((seconds - (double)s) * 1000.0);
        calendar.set(14, ms);
        if ("" != null) {
            return calendar;
        }
        throw new Error("Missing return statement in function");
    }

    public final Calendar zoneExpr(Calendar calendar) throws ParseException {
        TimeZone timeZone;
        int sign = 1;
        int zoneMinute = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 2: 
                    case 3: {
                        sign = this.sign();
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                int zoneHour = this.unsignedInteger();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: 
                    case 5: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                this.jj_consume_token(4);
                                break;
                            }
                            default: {
                                this.jj_la1[31] = this.jj_gen;
                            }
                        }
                        zoneMinute = this.unsignedInteger();
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                if (zoneHour >= 100) {
                    zoneMinute += zoneHour % 100;
                    zoneHour /= 100;
                }
                if (zoneHour > 23 || zoneMinute > 59) {
                    throw new ParseException("invalid time-zone in timestamp");
                }
                timeZone = TimeZone.getDefault();
                timeZone.setRawOffset(sign * (zoneHour * 60 + zoneMinute) * 60 * 1000);
                break;
            }
            case 18: {
                Token token = this.jj_consume_token(18);
                timeZone = TimeZone.getTimeZone(token.image);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        calendar.setTimeZone(timeZone);
        if ("" != null) {
            return calendar;
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_35() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_12();
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_2();
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_33()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_22() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_12();
    }

    private boolean jj_3R_23() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_23()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_24()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_11() {
        if (this.jj_3R_12()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_5() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_14()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_5()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(18)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(16)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_11()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_19() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_18() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_17() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        return this.jj_3R_25();
    }

    private boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_6();
    }

    private boolean jj_3R_10() {
        if (this.jj_3R_12()) {
            return true;
        }
        return this.jj_3R_22();
    }

    private boolean jj_3R_21() {
        return this.jj_3R_22();
    }

    private boolean jj_3_9() {
        return this.jj_3R_4();
    }

    private boolean jj_3_4() {
        if (this.jj_3R_4()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_18()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_19()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(1)) {
                return true;
            }
        }
        return this.jj_3R_7();
    }

    private boolean jj_3R_9() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_9()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_10()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_30() {
        return this.jj_3R_34();
    }

    private boolean jj_3_8() {
        return this.jj_3R_4();
    }

    private boolean jj_3_3() {
        return this.jj_3R_3();
    }

    private boolean jj_3R_2() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_15()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4133164, 4157742, 12290, 12290, 4141358, 2048, 2092, 2, 2, 4133164, 458752, 0x380000, 2, 44, 12, 1024, 32, 12, 32, 32, 12, 131074, 2, 12, 8, 8, 32, 32, 16, 16, 12, 16, 48, 262188};
    }

    public UnitParser(InputStream stream) {
        this(stream, null);
    }

    public UnitParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new UnitParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public UnitParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new UnitParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public UnitParser(UnitParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(UnitParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[23];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 34; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 23; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 9; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        try {
            unitsDB = DefaultUnitsDB.instance();
        }
        catch (UnitException unitException) {
            // empty catch block
        }
        SECOND = SI.second;
        julianDayOrigin = UnitParser.julianDay(2001, 1, 1);
        ONE = new DerivedUnit();
        UnitParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

